/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.viewcalsteps;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.accountplan.AccountPlanBuryPointUtil;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.jsondto.AccountPlanJsonDto;
import kd.wtc.wtbs.common.model.jsondto.BucketJsonDto;
import kd.wtc.wtbs.common.model.jsondto.PhaseJsonDto;
import kd.wtc.wtbs.common.model.jsondto.StepJsonDto;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class CalCulateStepFormPlugin
extends HRCoreBaseBillEdit {
    private static final Log LOG = LogFactory.getLog(CalCulateStepFormPlugin.class);
    private static final String WTC_WTTE_FORMPLUGIN = "wtc-wtte-formplugin";
    private static final int MAX_TIME_SEQ_NUM = 9;
    private static HRBaseServiceHelper hisServiceHelper = new HRBaseServiceHelper("wtdtd_attrecorddetailhis");
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
    private static HRBaseServiceHelper dataJsonHelper = new HRBaseServiceHelper("wtte_datajson");
    private static HRBaseServiceHelper accountPlanServiceHelper = new HRBaseServiceHelper("wtp_accountplan");
    private static HRBaseServiceHelper accountStepServiceHelper = new HRBaseServiceHelper("wtp_accountsteps");

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        for (int i = 1; i <= 9; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"calparameters" + i});
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        List parentIds = (List)customParams.get("parentIds");
        Long personId = (Long)customParams.get("personid");
        Long attItemId = (Long)customParams.get("attitemid");
        String ownDate = (String)customParams.get("owndate");
        String version = (String)customParams.get("versionid");
        Date parse = null;
        try {
            parse = new SimpleDateFormat("yyyy-MM-dd").parse(ownDate);
        }
        catch (ParseException parseException) {
            LOG.error((Throwable)parseException);
        }
        QFilter dataJson_personQFilter = new QFilter("personid", "=", (Object)personId);
        QFilter ownDateQFilter = new QFilter("owndate", "=", (Object)parse);
        QFilter versionQFilter = new QFilter("version", "=", (Object)version);
        DynamicObject dataJsonObj = dataJsonHelper.loadDynamicObject(new QFilter[]{dataJson_personQFilter, ownDateQFilter, versionQFilter});
        if (Objects.nonNull(dataJsonObj)) {
            String dataJson = dataJsonObj.getString("datajson");
            AccountPlanJsonDto accountPlanJsonDto = null;
            try {
                accountPlanJsonDto = (AccountPlanJsonDto)JsonUtil.decodeFromString((String)dataJson, AccountPlanJsonDto.class);
                LOG.info("accountPlanJsonDto->{},dataJson->{}", (Object)accountPlanJsonDto, (Object)dataJson);
            }
            catch (Exception exception) {
                LOG.error("jsonProcessingException_error", (Throwable)exception);
            }
            if (accountPlanJsonDto == null) {
                LOG.info("accountPlanJsonDto is null, personId={},attItemId={},ownDate={} ", new Object[]{personId, attItemId, ownDate});
                return;
            }
            List<Object> currentList = new ArrayList<BucketJsonDto>(16);
            List allBucketJsonDto = accountPlanJsonDto.takeAllBucketJsonDto();
            List<Long> parent = parentIds.stream().map(parentId -> Long.parseLong(parentId.trim())).collect(Collectors.toList());
            this.getCurrentList(currentList, allBucketJsonDto, parent);
            currentList = currentList.stream().distinct().collect(Collectors.toList());
            this.getCurrentPlanDto(accountPlanJsonDto, currentList);
            accountPlanJsonDto.clear();
            QFilter versionIdQFilter = new QFilter("attmain.versionid", "=", (Object)version);
            QFilter attItemIdQFilter = new QFilter("attitemid", "=", (Object)attItemId);
            QFilter personQFilter = new QFilter("attmain.personid", "=", (Object)personId);
            DynamicObject reCoredHisObj = HRStringUtils.equals((String)"wtte_recordreport", (String)parentFormId) ? serviceHelper.loadDynamicObject(new QFilter[]{personQFilter, ownDateQFilter, versionIdQFilter, attItemIdQFilter}) : hisServiceHelper.loadDynamicObject(new QFilter[]{personQFilter, ownDateQFilter, versionIdQFilter, attItemIdQFilter});
            List phaseList = accountPlanJsonDto.getPhaseList();
            this.loadPersonInfo(reCoredHisObj, phaseList);
            ArrayList headerNode = Lists.newArrayListWithExpectedSize((int)16);
            this.loadPhaseInfo(phaseList, headerNode);
            this.initMao(headerNode);
        }
    }

    private void bulitPhaseNameMap(List<PhaseJsonDto> phaseList, Map<Long, String> phaseMap, Map<Long, String> stepMap) {
        ArrayList phaseIdList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList stepIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (PhaseJsonDto phase : phaseList) {
            Long id = phase.getId();
            if (id != null) {
                phaseIdList.add(id);
                Long buryPointPhaseId = AccountPlanBuryPointUtil.getPointPhaseId((boolean)true);
                if (id.equals(buryPointPhaseId)) {
                    phaseMap.put(id, AccountPlanBuryPointUtil.getPointPhaseName((boolean)true));
                    stepMap.put(AccountPlanBuryPointUtil.getPointStepId((boolean)true), AccountPlanBuryPointUtil.getPointStepName((boolean)true));
                }
            }
            stepIdList.addAll(phase.getSteps().stream().map(StepJsonDto::getStepId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(phaseList)) {
            return;
        }
        phaseMap.putAll(Arrays.stream(accountPlanServiceHelper.queryOriginalArray("entryentity.id, entryentity.phasenamelang", new QFilter[]{new QFilter("entryentity.id", "in", (Object)phaseIdList)})).collect(Collectors.toMap(ob -> ob.getLong("entryentity.id"), ob -> ob.getString("entryentity.phasenamelang"))));
        if (CollectionUtils.isEmpty((Collection)stepIdList)) {
            return;
        }
        stepMap.putAll(Arrays.stream(accountStepServiceHelper.queryOriginalArray("id, name", new QFilter[]{new QFilter("id", "in", (Object)stepIdList)})).collect(Collectors.toMap(ob -> ob.getLong("id"), ob -> ob.getString("name"))));
    }

    private void loadPhaseInfo(List<PhaseJsonDto> phaseList, List<AnchorItems> headerNode) {
        HashMap phaseMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap stepMap = Maps.newHashMapWithExpectedSize((int)16);
        this.bulitPhaseNameMap(phaseList, phaseMap, stepMap);
        int phaseIndex = 1;
        String phaseLangName = ResManager.loadKDString((String)"\u9636\u6bb5%1$s: %2$s", (String)"CalCulateStepFormPlugin_0", (String)WTC_WTTE_FORMPLUGIN, (Object[])new Object[0]);
        for (PhaseJsonDto phase : phaseList) {
            String name;
            int stepIndex = 1;
            List steps = phase.getSteps();
            AnchorItems phaseAnchor = new AnchorItems();
            String phaseNameValue = phase.getName();
            Long id = phase.getId();
            if (id != null && !HRStringUtils.isEmpty((String)(name = (String)phaseMap.get(id)))) {
                phaseNameValue = name;
            }
            String phaseName = String.format(Locale.ROOT, phaseLangName, phaseIndex, phaseNameValue);
            phaseAnchor.setCaption(phaseName);
            phaseAnchor.setTarget("calparameters" + phaseIndex);
            ArrayList<AnchorItems> stepNodes = new ArrayList<AnchorItems>(16);
            for (int ii = 0; ii < steps.size(); ++ii) {
                String name2;
                StepJsonDto stepJsonDto = (StepJsonDto)steps.get(ii);
                AnchorItems stepNode = new AnchorItems();
                Long stepId = stepJsonDto.getStepId();
                String stepNameValue = stepJsonDto.getName();
                if (stepId != null && !HRStringUtils.isEmpty((String)(name2 = (String)stepMap.get(stepId)))) {
                    stepNameValue = name2;
                }
                String stepName = phaseIndex + "." + stepIndex + " " + stepNameValue;
                stepNode.setCaption(stepName);
                stepNode.setTarget("calparameters" + phaseIndex);
                stepNodes.add(stepNode);
                List<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>(16);
                List bucketDtoList = stepJsonDto.getBucketDto();
                this.dealWithBucketDto(phaseName, ii, stepName, tempList, bucketDtoList);
                tempList = tempList.stream().distinct().collect(Collectors.toList());
                this.getView().setVisible(Boolean.TRUE, new String[]{"calparameters" + phaseIndex});
                this.loadParmForm(this.createFlex(true, phaseIndex, stepIndex), "wtte_phasewithstep", tempList);
                String type = WTCCollectionIndexUtil.getEleFromList((List)bucketDtoList, (int)0).isPresent() ? ((BucketJsonDto)WTCCollectionIndexUtil.getEleFromList((List)bucketDtoList, (int)0).get()).getType() : null;
                String stepListFlex = this.createFlex(false, phaseIndex, stepIndex);
                if (HRStringUtils.equals((String)type, (String)"0")) {
                    this.loadForm(stepListFlex, "wtte_timebucketraw", bucketDtoList);
                } else if (HRStringUtils.equals((String)type, (String)"1")) {
                    this.loadForm(stepListFlex, "wtte_attvalueraw", bucketDtoList);
                }
                ++stepIndex;
            }
            phaseAnchor.setItems(stepNodes);
            headerNode.add(phaseAnchor);
            ++phaseIndex;
        }
    }

    private String createFlex(boolean isStep, int phaseIndex, int stepIndex) {
        String newFlexKey;
        int index;
        Container flexPanel = (Container)this.getView().getControl("calparameters" + phaseIndex);
        if (isStep) {
            index = (stepIndex - 1) * 2;
            newFlexKey = "stepflex" + phaseIndex + stepIndex;
        } else {
            index = 2 * stepIndex - 1;
            newFlexKey = "steplistflex" + phaseIndex + stepIndex;
        }
        flexPanel.deleteControls(new String[]{newFlexKey});
        FlexPanelAp childFlex = new FlexPanelAp();
        childFlex.setKey(newFlexKey);
        flexPanel.insertControls(index, Collections.singletonList(childFlex.createControl()));
        return newFlexKey;
    }

    private void dealWithBucketDto(String phaseName, int ii, String stepName, List<Map<String, Object>> tempList, List<BucketJsonDto> bucketDtoList) {
        for (BucketJsonDto bucketDto : bucketDtoList) {
            Long ruleVId = bucketDto.getParamId();
            String ruleSource = bucketDto.getEntityName();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)6);
            if (ii == 0) {
                paramMap.put("phasename", phaseName);
            }
            paramMap.put("stepname", stepName);
            paramMap.put("rulevid", ruleVId);
            paramMap.put("rulesource", ruleSource);
            tempList.add(paramMap);
        }
    }

    private void getCurrentPlanDto(AccountPlanJsonDto accountPlanJsonDto, List<BucketJsonDto> currentList) {
        List steps;
        List phaseList = accountPlanJsonDto.getPhaseList();
        for (PhaseJsonDto phase : phaseList) {
            steps = phase.getSteps();
            for (StepJsonDto step : steps) {
                step.setBucketDto(null);
            }
        }
        for (PhaseJsonDto phase : phaseList) {
            steps = phase.getSteps();
            this.addStepData(currentList, steps);
        }
    }

    private void addStepData(List<BucketJsonDto> currentList, List<StepJsonDto> steps) {
        for (StepJsonDto step : steps) {
            ArrayList<BucketJsonDto> tempList = new ArrayList<BucketJsonDto>(16);
            Long stepId = step.getStepId();
            Long stepEntryId = step.getStepEntryId();
            for (BucketJsonDto bucket : currentList) {
                Long bucketStepId = bucket.getStepId();
                Long bocketStepEntryId = bucket.getStepEntryId();
                if (stepEntryId == null) {
                    if (!bucketStepId.equals(stepId)) continue;
                    tempList.add(bucket);
                    continue;
                }
                if (!stepEntryId.equals(bocketStepEntryId)) continue;
                tempList.add(bucket);
            }
            step.setBucketDto(tempList);
        }
    }

    private void getCurrentList(List<BucketJsonDto> currentList, List<BucketJsonDto> allBucketJsonDto, List<Long> parentIds) {
        for (Long lastId : parentIds) {
            List collect = allBucketJsonDto.stream().filter(bucket -> bucket.getBucketId().equals(lastId)).collect(Collectors.toList());
            BucketJsonDto bucketJsonDto = (BucketJsonDto)collect.get(0);
            currentList.add(bucketJsonDto);
            List parentBucketId = bucketJsonDto.getParentBucketId();
            if (CollectionUtils.isEmpty((Collection)parentBucketId)) continue;
            this.getCurrentList(currentList, allBucketJsonDto, parentBucketId);
        }
    }

    private void initMao(List<AnchorItems> headerNode) {
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("anchorcontrolap");
        anchorCtl.setHighlight(true);
        anchorCtl.addItems(headerNode);
    }

    private void loadPersonInfo(DynamicObject dynamicObject, List<PhaseJsonDto> phaseList) {
        IDataModel dataModel = this.getModel();
        DynamicObject personDy = dynamicObject.getDynamicObject("attmain.personid");
        personDy = AttendPersonServiceImpl.getInstance().queryAttendPersonByPersonId(Long.valueOf(personDy.getLong("id")));
        this.getView().getModel().setValue("attperson", (Object)personDy);
        Map personInfoMap = HRPIMServiceImpl.getInstance().getPersonBaseInfo(Long.valueOf(personDy.getLong("id")));
        String headPic = (String)personInfoMap.get("headsculpture");
        String url = "/images/pc/emotion/default_person_82_82.png";
        if (StringUtils.isNotBlank((CharSequence)headPic) && !"/images/pc/emotion/default_person_82_82.png".equals(headPic)) {
            url = !HRStringUtils.isEmpty((String)headPic) && !HRStringUtils.startsWithIgnoreCase((String)headPic, (String)"http") ? UrlService.getImageFullUrl((String)headPic.trim()) : headPic;
        }
        ImageAp portrait = new ImageAp();
        portrait.setKey("personpicture");
        portrait.setImageKey(url);
        this.getView().updateControlMetadata(portrait.getKey(), portrait.createControl());
        dataModel.setValue("personname", dynamicObject.get("attmain.personid.name"));
        dataModel.setValue("personnumber", dynamicObject.get("attmain.personid.number"));
        String sexName = personDy.getString("gender.name");
        dataModel.setValue("sex", (Object)sexName);
        dataModel.setValue("owndate", dynamicObject.get("owndate"));
        dataModel.setValue("ittemname", dynamicObject.get("attitemid.name"));
        dataModel.setValue("ittemcode", dynamicObject.get("attitemid.number"));
        dataModel.setValue("stepsnum", (Object)phaseList.size());
        dataModel.setValue("calculatetime", dynamicObject.get("attmain.calculatedate"));
        this.stDateInfo(phaseList, dataModel);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)1);
        idList.add(dynamicObject.getLong("attmain.attfileid"));
        List dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(null, (List)idList);
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            LOG.info("attfileDy  is null, attfileid = {}", (Object)dynamicObject.getLong("attmain.attfileid"));
            return;
        }
        DynamicObject attFileDy = (DynamicObject)dynamicObjects.get(0);
        dataModel.setValue("company", attFileDy.get("org.name"));
        dataModel.setValue("depempname", attFileDy.get("affiliateadminorg.name"));
        dataModel.setValue("country", (Object)attFileDy.getString("dependency.name"));
        dataModel.setValue("dependencytype", attFileDy.get("dependencytype.name"));
        dataModel.setValue("number", attFileDy.get("number"));
        DynamicObject attTag = attFileDy.getDynamicObject("atttag");
        if (null != attTag) {
            dataModel.setValue("atttag", (Object)attTag.getString("name"));
            String attendStatus = attTag.getString("attendstatus");
            boolean isNormal = HRStringUtils.equals((String)AttStatusEnum.ATT_NORMAL.getCode(), (String)attendStatus);
            this.getView().setVisible(Boolean.valueOf(isNormal), new String[]{"attnormal"});
            this.getView().setVisible(Boolean.valueOf(!isNormal), new String[]{"attstop"});
        }
    }

    private void stDateInfo(List<PhaseJsonDto> phaseList, IDataModel dataModel) {
        List steps;
        if (phaseList.isEmpty()) {
            return;
        }
        List list = steps = WTCCollectionIndexUtil.getEleFromList(phaseList, (int)0).isPresent() ? ((PhaseJsonDto)WTCCollectionIndexUtil.getEleFromList(phaseList, (int)0).get()).getSteps() : Collections.emptyList();
        if (steps.isEmpty()) {
            return;
        }
        StepJsonDto stepJsonDto = (StepJsonDto)steps.get(0);
        List bucketDto = stepJsonDto.getBucketDto();
        if (bucketDto.isEmpty()) {
            return;
        }
        BucketJsonDto bucketJsonDto = (BucketJsonDto)bucketDto.get(0);
        if (bucketJsonDto == null) {
            return;
        }
        if (null != bucketJsonDto.getDateAttribute()) {
            dataModel.setValue("dateatt", (Object)(bucketJsonDto.getDateAttributeEntry() == null ? bucketJsonDto.getDateAttribute() : bucketJsonDto.getDateAttributeEntry().getName()));
            Long dateType = bucketJsonDto.getDateType();
            if (dateType != null && dateType != 0L) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_datetype");
                DynamicObject dateTypeDy = helper.queryOne((Object)dateType);
                dataModel.setValue("datetype", dateTypeDy != null ? dateTypeDy.getString("name") : null);
            }
        } else {
            long attPersonId = dataModel.getDataEntity().getLong("attperson.id");
            Date ownDate = dataModel.getDataEntity().getDate("owndate");
            DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShifts(Collections.singletonList(attPersonId), (Date)ownDate, (Date)ownDate);
            Optional dutyShiftOptional = dutyShifts.getDutyShift(Long.valueOf(attPersonId), ownDate);
            if (!dutyShiftOptional.isPresent()) {
                return;
            }
            DutyShift dutyShift = (DutyShift)dutyShiftOptional.get();
            dataModel.setValue("dateatt", null != dutyShift.getDateAttribute() ? dutyShift.getDateAttribute().getName() : null);
            dataModel.setValue("datetype", dutyShift.getDateTypeModel() != null ? dutyShift.getDateTypeModel().getName() : null);
        }
    }

    private void loadForm(String targetKey, String formId, List<BucketJsonDto> dataList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(formId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCustomParam("data", dataList);
        this.getView().showForm(showParameter);
    }

    private void loadParmForm(String targetKey, String formId, List<Map<String, Object>> tempList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(formId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCustomParam("paralist", tempList);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing opation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && HRStringUtils.equals((String)(opation = (Donothing)args.getSource()).getOperateKey(), (String)"refresh")) {
            FormView view = (FormView)this.getView();
            view.updateView();
        }
    }
}

