/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.viewcalsteps;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.jsondto.QuotaAccountPlanJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaBucketJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaPhaseJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaRuleJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaStepJsonDto;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountSteps;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class QuotaCalCulateStepFormPlugin
extends HRCoreBaseBillEdit {
    private static final Log LOG = LogFactory.getLog(QuotaCalCulateStepFormPlugin.class);
    private static final String WTC_WTTE_FORMPLUGIN = "wtc-wtte-formplugin";
    private static final int MAX_TIME_SEQ_NUM = 9;
    private static HRBaseServiceHelper dataJsonHelper = new HRBaseServiceHelper("wtte_quotadatajson");

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        for (int i = 1; i <= 9; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"calparameters" + i});
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter idQfilter = new QFilter("id", "=", customParams.get("id"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_quotadetail");
        if (customParams.containsKey("key_fromHis")) {
            serviceHelper = new HRBaseServiceHelper("wtte_quotadetahis");
        }
        DynamicObject reCoredHisObj = serviceHelper.loadDynamicObject(new QFilter[]{idQfilter});
        String sourceAttItemIds = reCoredHisObj.getString("sourceattitemids");
        String[] split = sourceAttItemIds.split(",");
        List parentIds = Arrays.stream(split).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        Long personId = reCoredHisObj.getLong("attfileid.attperson.id");
        Long attItemId = reCoredHisObj.getLong("attitemvid.id");
        String genTime = HRDateTimeUtils.format((Date)reCoredHisObj.getDate("gentime"), (String)"yyyy-MM-dd");
        String version = reCoredHisObj.getString("version");
        Date parse = null;
        try {
            parse = new SimpleDateFormat("yyyy-MM-dd").parse(genTime);
        }
        catch (ParseException parseException) {
            LOG.error((Throwable)parseException);
        }
        Integer periodNum = reCoredHisObj.getInt("periodnum");
        Long qtTypeId = reCoredHisObj.getLong("qttypeid.id");
        Long attFileBid = reCoredHisObj.getLong("attfileid.id");
        QFilter dataJson_personQFilter = new QFilter("personid", "=", (Object)personId);
        QFilter qtTypeIdQfilter = new QFilter("qttypeid", "=", (Object)qtTypeId);
        QFilter periodNumQfilter = new QFilter("periodnum", "=", (Object)periodNum);
        QFilter versionQFilter = new QFilter("version", "=", (Object)version);
        DynamicObject dataJsonObj = null;
        DynamicObject[] dataJsonObjs = dataJsonHelper.loadDynamicObjectArray(new QFilter[]{dataJson_personQFilter, qtTypeIdQfilter, periodNumQfilter, versionQFilter});
        if (dataJsonObjs.length == 0) {
            QFilter deductChainTypeFilter = new QFilter("qttypeid", "=", (Object)0L);
            QFilter deductChainPeriodNumFilter = new QFilter("periodnum", "=", (Object)0L);
            dataJsonObjs = dataJsonHelper.loadDynamicObjectArray(new QFilter[]{dataJson_personQFilter, deductChainTypeFilter, deductChainPeriodNumFilter, versionQFilter});
        }
        if (dataJsonObjs != null && dataJsonObjs.length > 0) {
            for (int index = 0; index < dataJsonObjs.length; ++index) {
                DynamicObject dy = dataJsonObjs[index];
                if (attFileBid.equals(dy.getLong("attfileid.id"))) {
                    dataJsonObj = dy;
                    break;
                }
                if (dataJsonObjs.length != 1) continue;
                dataJsonObj = dataJsonObjs[0];
            }
        }
        if (null != dataJsonObj) {
            String dataJson = dataJsonObj.getString("datajson");
            QuotaAccountPlanJsonDto accountPlanJsonDto = null;
            try {
                accountPlanJsonDto = (QuotaAccountPlanJsonDto)JsonUtil.decodeFromString((String)dataJson, QuotaAccountPlanJsonDto.class);
                LOG.info("quotaAccountPlanJsonDto->{},dataJson->{}", (Object)accountPlanJsonDto, (Object)dataJson);
            }
            catch (Exception exception) {
                LOG.error("jsonProcessingException_error", (Throwable)exception);
            }
            if (accountPlanJsonDto == null) {
                LOG.info("quotaAccountPlanJsonDto is null, personId={},attItemId={},genTime={} ", new Object[]{personId, attItemId, genTime});
                return;
            }
            List<Object> currentList = new ArrayList<QuotaBucketJsonDto>(16);
            List allBucketJsonDto = accountPlanJsonDto.takeAllBucketJsonDto();
            List<Long> parent = parentIds.stream().map(parentId -> Long.parseLong(parentId.trim())).collect(Collectors.toList());
            this.getCurrentList(currentList, allBucketJsonDto, parent);
            currentList = currentList.stream().distinct().collect(Collectors.toList());
            this.getCurrentPlanDto(accountPlanJsonDto, currentList);
            accountPlanJsonDto.clear();
            List phaseList = accountPlanJsonDto.getPhaseList();
            this.loadPersonInfo(reCoredHisObj, phaseList, parse);
            ArrayList headerNode = Lists.newArrayListWithExpectedSize((int)16);
            String type = (String)customParams.get("type");
            this.loadPhaseInfo(phaseList, headerNode, type);
            this.initMao(headerNode);
        }
    }

    private void loadPhaseInfo(List<QuotaPhaseJsonDto> phaseList, List<AnchorItems> headerNode, String type) {
        int phaseIndex = 1;
        String phaseLangName = ResManager.loadKDString((String)"\u9636\u6bb5%1$s: %2$s", (String)"CalCulateStepFormPlugin_0", (String)WTC_WTTE_FORMPLUGIN, (Object[])new Object[0]);
        for (QuotaPhaseJsonDto phase : phaseList) {
            int stepIndex = 1;
            List steps = phase.getSteps();
            AnchorItems phaseAnchor = new AnchorItems();
            String phaseName = String.format(Locale.ROOT, phaseLangName, phaseIndex, phase.getName());
            phaseAnchor.setCaption(phaseName);
            phaseAnchor.setTarget("calparameters" + phaseIndex);
            ArrayList<AnchorItems> stepNodes = new ArrayList<AnchorItems>(16);
            for (int ii = 0; ii < steps.size(); ++ii) {
                QuotaStepJsonDto stepJsonDto = (QuotaStepJsonDto)steps.get(ii);
                AnchorItems stepNode = new AnchorItems();
                String stepName = phaseIndex + "." + stepIndex + " " + stepJsonDto.getName();
                stepNode.setCaption(stepName);
                stepNode.setTarget("calparameters" + phaseIndex);
                stepNodes.add(stepNode);
                List<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>(16);
                List bucketDtoList = stepJsonDto.getBucketDto();
                this.dealWithBucketDto(phaseName, ii, stepName, tempList, bucketDtoList);
                tempList = tempList.stream().distinct().collect(Collectors.toList());
                this.getView().setVisible(Boolean.TRUE, new String[]{"calparameters" + phaseIndex});
                this.loadParmForm(this.createFlex(true, phaseIndex, stepIndex), "wtte_quotaphasewithstep", tempList);
                String stepListFlex = this.createFlex(false, phaseIndex, stepIndex);
                String attItemPage = "wtte_quotaattvalueraw";
                switch (type) {
                    case "LB-008": {
                        if (!PreDataAccountSteps.QU_1140_S.equals(stepJsonDto.getStepId())) break;
                        attItemPage = "wtte_quotaattvalueraw";
                        break;
                    }
                }
                this.loadForm(stepListFlex, attItemPage, bucketDtoList);
                ++stepIndex;
            }
            phaseAnchor.setItems(stepNodes);
            headerNode.add(phaseAnchor);
            ++phaseIndex;
        }
    }

    private String createFlex(boolean isStep, int phaseIndex, int stepIndex) {
        String newFlexKey;
        int index;
        Container flexPanel = (Container)this.getView().getControl("calparameters" + phaseIndex);
        if (isStep) {
            index = (stepIndex - 1) * 2;
            newFlexKey = "stepflex" + phaseIndex + stepIndex;
        } else {
            index = 2 * stepIndex - 1;
            newFlexKey = "steplistflex" + phaseIndex + stepIndex;
        }
        flexPanel.deleteControls(new String[]{newFlexKey});
        FlexPanelAp childFlex = new FlexPanelAp();
        childFlex.setKey(newFlexKey);
        flexPanel.insertControls(index, Collections.singletonList(childFlex.createControl()));
        return newFlexKey;
    }

    private void dealWithBucketDto(String phaseName, int ii, String stepName, List<Map<String, Object>> tempList, List<QuotaBucketJsonDto> bucketDtoList) {
        for (QuotaBucketJsonDto bucketDto : bucketDtoList) {
            Long ruleVId = bucketDto.getParamId();
            String ruleSource = bucketDto.getEntityName();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)6);
            if (ii == 0) {
                paramMap.put("phasename", phaseName);
            }
            paramMap.put("stepname", stepName);
            paramMap.put("rulevid", ruleVId);
            paramMap.put("rulesource", ruleSource);
            List quotaRuleJsonDto = bucketDto.getQuotaRuleJsonDtoList();
            if (!CollectionUtils.isEmpty((Collection)quotaRuleJsonDto)) {
                paramMap.put("rulevid", StringUtils.join((Iterable)quotaRuleJsonDto.stream().map(QuotaRuleJsonDto::getParamId).collect(Collectors.toList()), (String)","));
                paramMap.put("rulesource", StringUtils.join((Iterable)quotaRuleJsonDto.stream().map(QuotaRuleJsonDto::getEntityName).collect(Collectors.toList()), (String)","));
            }
            tempList.add(paramMap);
        }
    }

    private void getCurrentPlanDto(QuotaAccountPlanJsonDto accountPlanJsonDto, List<QuotaBucketJsonDto> currentList) {
        List steps;
        List phaseList = accountPlanJsonDto.getPhaseList();
        for (QuotaPhaseJsonDto phase : phaseList) {
            steps = phase.getSteps();
            for (QuotaStepJsonDto step : steps) {
                step.setBucketDto(null);
            }
        }
        for (QuotaPhaseJsonDto phase : phaseList) {
            steps = phase.getSteps();
            this.addStepData(currentList, steps);
        }
    }

    private void addStepData(List<QuotaBucketJsonDto> currentList, List<QuotaStepJsonDto> steps) {
        for (QuotaStepJsonDto step : steps) {
            ArrayList<QuotaBucketJsonDto> tempList = new ArrayList<QuotaBucketJsonDto>(16);
            Long stepId = step.getStepId();
            for (QuotaBucketJsonDto bucket : currentList) {
                Long bucketStepId = bucket.getStepId();
                if (!bucketStepId.equals(stepId)) continue;
                tempList.add(bucket);
            }
            step.setBucketDto(tempList);
        }
    }

    private void getCurrentList(List<QuotaBucketJsonDto> currentList, List<QuotaBucketJsonDto> allBucketJsonDto, List<Long> parentIds) {
        for (Long lastId : parentIds) {
            List collect = allBucketJsonDto.stream().filter(bucket -> bucket.getBucketId().equals(lastId)).collect(Collectors.toList());
            QuotaBucketJsonDto bucketJsonDto = (QuotaBucketJsonDto)collect.get(0);
            currentList.add(bucketJsonDto);
            List parentBucketId = bucketJsonDto.getParentBucketId();
            if (CollectionUtils.isEmpty((Collection)parentBucketId)) continue;
            this.getCurrentList(currentList, allBucketJsonDto, parentBucketId);
        }
    }

    private void initMao(List<AnchorItems> headerNode) {
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("anchorcontrolap");
        anchorCtl.setHighlight(true);
        anchorCtl.addItems(headerNode);
    }

    private void loadPersonInfo(DynamicObject dynamicObject, List<QuotaPhaseJsonDto> phaseList, Date calculDate) {
        IDataModel dataModel = this.getModel();
        DynamicObject personDy = dynamicObject.getDynamicObject("attfileid.attperson");
        personDy = AttendPersonServiceImpl.getInstance().queryAttendPersonByPersonId(Long.valueOf(personDy.getLong("id")));
        this.getView().getModel().setValue("attperson", (Object)personDy);
        Map personInfoMap = HRPIMServiceImpl.getInstance().getPersonBaseInfo(Long.valueOf(personDy.getLong("id")));
        String headPic = (String)personInfoMap.get("headsculpture");
        String url = "/images/pc/emotion/default_person_82_82.png";
        if (StringUtils.isNotBlank((CharSequence)headPic) && !"/images/pc/emotion/default_person_82_82.png".equals(headPic)) {
            url = !HRStringUtils.isEmpty((String)headPic) && !HRStringUtils.startsWithIgnoreCase((String)headPic, (String)"http") ? UrlService.getImageFullUrl((String)headPic.trim()) : headPic;
        }
        ImageAp portrait = new ImageAp();
        portrait.setKey("personpicture");
        portrait.setImageKey(url);
        this.getView().updateControlMetadata(portrait.getKey(), portrait.createControl());
        dataModel.setValue("personname", dynamicObject.get("attfileid.attperson.name"));
        dataModel.setValue("personnumber", dynamicObject.get("attfileid.attperson.number"));
        String sexName = personDy.getString("gender.name");
        dataModel.setValue("sex", (Object)sexName);
        dataModel.setValue("owndate", (Object)calculDate);
        dataModel.setValue("ittemname", dynamicObject.get("attitemvid.name"));
        dataModel.setValue("ittemcode", dynamicObject.get("attitemvid.number"));
        dataModel.setValue("stepsnum", (Object)phaseList.size());
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)1);
        idList.add(dynamicObject.getLong("attfileid.id"));
        List dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(null, (List)idList);
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            LOG.info("attfileDy  is null, attfileid = {}", (Object)dynamicObject.getLong("attfileid"));
            return;
        }
        DynamicObject attFileDy = (DynamicObject)dynamicObjects.get(0);
        dataModel.setValue("company", attFileDy.get("org.name"));
        dataModel.setValue("depempname", attFileDy.get("affiliateadminorg.name"));
        dataModel.setValue("country", (Object)attFileDy.getString("dependency.name"));
        dataModel.setValue("dependencytype", attFileDy.get("dependencytype.name"));
        dataModel.setValue("number", attFileDy.get("number"));
        DynamicObject attTag = attFileDy.getDynamicObject("atttag");
        if (null != attTag) {
            dataModel.setValue("atttag", (Object)attTag.getString("name"));
            String attendStatus = attTag.getString("attendstatus");
            boolean isNormal = HRStringUtils.equals((String)AttStatusEnum.ATT_NORMAL.getCode(), (String)attendStatus);
            this.getView().setVisible(Boolean.valueOf(isNormal), new String[]{"attnormal"});
            this.getView().setVisible(Boolean.valueOf(!isNormal), new String[]{"attstop"});
        }
    }

    private void stDateInfo(List<QuotaPhaseJsonDto> phaseList, IDataModel dataModel) {
        if (!phaseList.isEmpty()) {
            QuotaBucketJsonDto bucketJsonDto;
            QuotaStepJsonDto stepJsonDto;
            List bucketDto;
            List steps;
            List list = steps = WTCCollectionIndexUtil.getEleFromList(phaseList, (int)0).isPresent() ? ((QuotaPhaseJsonDto)WTCCollectionIndexUtil.getEleFromList(phaseList, (int)0).get()).getSteps() : Collections.emptyList();
            if (steps.isEmpty() || (bucketDto = (stepJsonDto = (QuotaStepJsonDto)steps.get(0)).getBucketDto()).isEmpty() || (bucketJsonDto = (QuotaBucketJsonDto)bucketDto.get(0)) != null) {
                // empty if block
            }
        }
    }

    private void loadForm(String targetKey, String formId, List<QuotaBucketJsonDto> dataList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(formId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCustomParam("data", dataList);
        this.getView().showForm(showParameter);
    }

    private void loadParmForm(String targetKey, String formId, List<Map<String, Object>> tempList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(formId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCustomParam("paralist", tempList);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing opation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && HRStringUtils.equals((String)(opation = (Donothing)args.getSource()).getOperateKey(), (String)"refresh")) {
            FormView view = (FormView)this.getView();
            view.updateView();
        }
    }
}

