/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.viewcalsteps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.userconfig.GridConfigDAO;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.model.jsondto.BucketJsonDto;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtte.business.viewcalsteps.AttRecordService;

public class TimeBucketRawFromPlugin
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final int NEED_DEFAULT_HIDDEN_INDEX_BEGIN = 9;

    public void registerListener(EventObject eventObject) {
        EntryGrid entryEntity = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryEntity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IFormView view = this.getView();
        view.getFormShowParameter().setStatus(OperationStatus.VIEW);
        FormShowParameter formParam = view.getFormShowParameter();
        JSONArray bucketDto = (JSONArray)formParam.getCustomParam("data");
        List list = JSON.parseArray((String)bucketDto.toJSONString(), BucketJsonDto.class);
        List<BucketJsonDto> timeBuckets = list.stream().filter(ob -> ob.getStartDate() != null).collect(Collectors.toList());
        List nonTimeBuckets = list.stream().filter(ob -> ob.getStartDate() == null).collect(Collectors.toList());
        timeBuckets.sort(Comparator.comparing(BucketJsonDto::getStartDate));
        timeBuckets.addAll(nonTimeBuckets);
        this.setDataFormEntryRow(timeBuckets);
    }

    private void setDataFormEntryRow(List<BucketJsonDto> bucketDtoList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        int index = 0;
        for (BucketJsonDto bucketJsonDto : bucketDtoList) {
            tvs.set("shiftid", (Object)bucketJsonDto.getShiftId(), index);
            tvs.set("shiftdate", (Object)bucketJsonDto.getShiftDate(), index);
            tvs.set("startdate", (Object)bucketJsonDto.getStartDate(), index);
            tvs.set("starttimepointsource", (Object)bucketJsonDto.getStartTimePointSource(), index);
            tvs.set("enddate", (Object)bucketJsonDto.getEndDate(), index);
            tvs.set("endtimepointsource", (Object)bucketJsonDto.getEndTimePointSource(), index);
            tvs.set("atttiem", (Object)AttRecordService.genAttItemStr((List)bucketJsonDto.getAttitemList()), index);
            tvs.set("shifttimebucketseq", (Object)Long.parseLong(bucketJsonDto.getShiftTimeBucketSeq()), index);
            tvs.set("shiftsessiontype", (Object)bucketJsonDto.getShiftSessionType(), index);
            tvs.set("datetype", (Object)bucketJsonDto.getDateType(), index);
            tvs.set("dateattribute", (Object)bucketJsonDto.getDateAttribute(), index);
            tvs.set("punchcardtag", (Object)bucketJsonDto.getPunchCardTag(), index);
            tvs.set("attendancebilltag", (Object)bucketJsonDto.getAttendanceBillTag(), index);
            tvs.set("attendancestatus", (Object)TimeBucketRawFromPlugin.getList2string(bucketJsonDto.getAttendanceStatus()), index);
            tvs.set("shifttimeprop", (Object)bucketJsonDto.getShiftTimeProp(), index);
            tvs.set("timebucketlabellist", (Object)TimeBucketRawFromPlugin.getList2string(bucketJsonDto.getTimeBucketLabelList()), index);
            tvs.set("absencebillstate", (Object)bucketJsonDto.getAbsenceBillState(), index);
            tvs.set("travelbillstate", (Object)bucketJsonDto.getTravelBillState(), index);
            ++index;
        }
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, tvs);
        this.getView().updateView(KEY_ENTRYENTITY);
        model.endInit();
    }

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List cachedGridRowSets = gridConfigDAO.getGridConfig(showParameter.getFormId(), KEY_ENTRYENTITY);
        if (WTCCollections.isEmpty((Collection)cachedGridRowSets)) {
            gridConfigDAO.deleteGridConfig(showParameter.getFormId(), KEY_ENTRYENTITY);
            List setRows = GridConfigRenderUtils.getFieldApInfo((IFormView)this.getView(), (String)showParameter.getFormId(), (String)KEY_ENTRYENTITY);
            if (WTCCollections.isNotEmpty((Collection)setRows) && setRows.size() > 9) {
                for (int i = 9; i < setRows.size(); ++i) {
                    ((GridConfigurationRow)setRows.get(i)).setHide(true);
                }
                gridConfigDAO.saveGridConfig(showParameter.getFormId(), KEY_ENTRYENTITY, setRows);
            }
        }
    }

    private static String getList2string(List<String> stringList) {
        StringBuilder str = new StringBuilder();
        if (null != stringList && !stringList.isEmpty()) {
            for (String status : stringList) {
                str.append(status).append(',');
            }
        }
        return str.toString();
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        int rowId = args.getRowIndex();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(rowId);
        DynamicObject shiftid = dynamicObject.getDynamicObject("shiftid");
        Object pkValue = shiftid.getPkValue();
        this.showFormParameter(pkValue);
    }

    private void showFormParameter(Object pkValue) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("wtbd_shift");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setBillStatus(BillOperationStatus.VIEW);
        billShowParameter.setCustomParam("checkRightAppId", (Object)"wtp");
        billShowParameter.setPkId(pkValue);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

