/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.api.result;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.common.enums.SystemType;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class ApiSaveResult
extends ApiServiceResult {
    private long successCount;
    private long failCount;
    private List<ApiSaveItemData> result = new ArrayList<ApiSaveItemData>();
    transient List<ApiSaveItemData> inserts;
    transient List<ApiSaveItemData> updates;

    public ApiSaveResult() {
    }

    public static ApiSaveResult of(List<ApiSaveItemData> insertIds, List<ApiSaveItemData> updateIds) {
        return new ApiSaveResult(insertIds, updateIds);
    }

    public ApiSaveResult(List<ApiSaveItemData> insertIds, List<ApiSaveItemData> updateIds) {
        this.inserts = insertIds.stream().peek(r -> r.setType("Add")).collect(Collectors.toList());
        this.updates = updateIds.stream().peek(r -> r.setType("Update")).collect(Collectors.toList());
        this.result.addAll(this.inserts);
        this.result.addAll(this.updates);
        this.failCount = this.result.stream().filter(r -> !r.isBillStatus()).count();
        this.successCount = (long)this.result.size() - this.failCount;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(long successCount) {
        this.successCount = successCount;
    }

    public long getFailCount() {
        return this.failCount;
    }

    public void setFailCount(long failCount) {
        this.failCount = failCount;
    }

    public void setInsideInserts(List<ApiSaveItemData> insertIds) {
        this.inserts = insertIds;
    }

    public void setInsideUpdates(List<ApiSaveItemData> updateIds) {
        this.updates = updateIds;
    }

    public List<ApiSaveItemData> getResult() {
        return this.result;
    }

    @Override
    public String fetchFirstErrorMessage() {
        ArrayList errorlist = new ArrayList();
        this.getResult().forEach(item -> item.getErrors().stream().filter(errors -> errors != null).forEach(errors -> errorlist.addAll(errors.getRowMsg())));
        if (errorlist.isEmpty()) {
            return super.fetchFirstErrorMessage();
        }
        return errorlist.size() == 1 ? (String)errorlist.get(0) : String.format(ResManager.loadKDString((String)"%1$s...\u7b49%2$s\u5904\u9519\u8bef", (String)"ApiSaveResult_0", (String)SystemType.API.getType(), (Object[])new Object[0]), errorlist.get(0), errorlist.size());
    }
}

