/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.security.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthResult;

public class ParameterUtil {
    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !ParameterUtil.isEmpty(str);
    }

    public static String getBasicAuthAccessKeyAuthParamsBy(Map<String, String> queryMap, Map<String, String> headerMap, String requestURI, String paramsName) {
        String accessKey = "";
        if (ParameterUtil.isNotEmpty(requestURI) && requestURI.indexOf("/$/openApiSign") > 0) {
            String pathVars = requestURI.substring(requestURI.indexOf("/$/") + "/$/".length());
            Map<String, String> pathVarMap = ParameterUtil.getPathVarMap(pathVars);
            accessKey = pathVarMap.get(paramsName);
        } else {
            String string = accessKey = headerMap != null && !headerMap.isEmpty() ? headerMap.get(paramsName) : "";
            if (ParameterUtil.isEmpty(accessKey)) {
                String string2 = accessKey = queryMap != null && !queryMap.isEmpty() ? queryMap.get(paramsName) : "";
            }
        }
        if (ParameterUtil.isNotEmpty(accessKey)) {
            try {
                accessKey = URLDecoder.decode(accessKey, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            accessKey = accessKey.trim();
        }
        return accessKey;
    }

    public static Map<String, String> getAccountIdAndSignCode(String accessKey) {
        String signWithAccountId = new String(Base64.getUrlDecoder().decode(accessKey));
        String[] signWithAccountIds = signWithAccountId.split(":");
        String signCode = "";
        String accountId = "";
        if (signWithAccountIds != null && signWithAccountIds.length == 2) {
            signCode = signWithAccountIds[0];
            accountId = signWithAccountIds[1];
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (ParameterUtil.isNotEmpty(signCode)) {
            signCode = signCode.trim();
        }
        result.put("signCode", signCode);
        result.put("accountId", accountId);
        return result;
    }

    public static Map<String, String> getPathVarMap(String pathVar) {
        HashMap<String, String> pathVarMap = new HashMap<String, String>(16);
        if (ParameterUtil.isEmpty(pathVar)) {
            return pathVarMap;
        }
        String[] vars = pathVar.split("/");
        if (vars != null && vars.length > 0) {
            for (int i = 0; i < vars.length; i += 2) {
                String value;
                String key = i < vars.length ? vars[i] : null;
                String string = value = i + 1 < vars.length ? vars[i + 1] : null;
                if (!ParameterUtil.isNotEmpty(key)) continue;
                if ("openapisign".equals(key.toLowerCase(Locale.ENGLISH))) {
                    key = key.toLowerCase(Locale.ENGLISH);
                }
                pathVarMap.put(key, value);
            }
        }
        return pathVarMap;
    }

    public static OpenApiResponse<ApiCommonResult> getCustomAuthFailResult(Object data, Map<String, String> header, int httpStatus) {
        return ParameterUtil.getCustomAuthFailResult(null, null, null, data, header, httpStatus);
    }

    public static OpenApiResponse<ApiCommonResult> getCustomAuthFailResult(OpenApiResponse response, String errorCode, String message, Object data, Map<String, String> header, int httpStatus) {
        if (response == null) {
            response = new OpenApiResponse<ApiCommonResult>();
        }
        if (ParameterUtil.isEmpty(errorCode)) {
            errorCode = "401";
        }
        if (ParameterUtil.isEmpty(message)) {
            message = "customAuthFailed.";
        }
        ApiCommonResult result = ApiCommonResult.getFailResult((String)errorCode, (String)message);
        AuthResult authResult = new AuthResult();
        authResult.setStatus(false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("responseData", data);
        authResult.setParams(params);
        result.setData((Object)authResult);
        result.setStatus(Boolean.valueOf(false));
        response.setData(result);
        response.setResponseHeaders(header);
        response.setHttpStatus(httpStatus);
        return response;
    }
}

