/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.context;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ServiceApiContext<REQ, RESP> {
    private static final Log LOGGER = LogFactory.getLog(ServiceApiContext.class);
    private static final ThreadLocal<ServiceApiContext<?, ?>> threadLocal = new ThreadLocal();
    private final OpenApiRequest<REQ> request;
    private final OpenApiResponse<RESP> response;

    @SdkInternal
    public ServiceApiContext(OpenApiRequest<REQ> request, OpenApiResponse<RESP> response) {
        this.request = request;
        this.response = response;
    }

    @SdkInternal
    public static <REQ, RESP> void set(ServiceApiContext<REQ, RESP> openApiContext) {
        threadLocal.set(openApiContext);
    }

    public static <REQ, RESP> ServiceApiContext<REQ, RESP> getContext() {
        return threadLocal.get();
    }

    public static <REQ, RESP> OpenApiRequest<REQ> getRequest() {
        ServiceApiContext<REQ, RESP> openApiContext = ServiceApiContext.getContext();
        if (openApiContext == null) {
            throw new NullPointerException("ServiceApiContext is null, please set Request Context");
        }
        return openApiContext.request;
    }

    public static <REQ, RESP> OpenApiResponse<RESP> getResponse() {
        ServiceApiContext<REQ, RESP> openApiContext = ServiceApiContext.getContext();
        if (openApiContext == null) {
            throw new NullPointerException("ServiceApiContext is null, please set Request Context");
        }
        return openApiContext.response;
    }

    public static <RESP> OpenApiResponse<RESP> getResponse(RESP data) {
        OpenApiResponse<RESP> response = ServiceApiContext.getResponse();
        if (response != null) {
            response.setData(data);
        }
        return response;
    }

    @SdkInternal
    public static <REQ, RESP> void close() {
        try {
            ServiceApiContext<REQ, RESP> openApiContext = ServiceApiContext.getContext();
            if (openApiContext != null) {
                ServiceApiContext.remove();
                openApiContext = null;
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred while releasing the ServiceApiContext:" + ex.getMessage(), (Throwable)ex);
        }
    }

    @SdkInternal
    public static void remove() {
        threadLocal.remove();
    }
}

