/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.nocode.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public enum PermItemEnum {
    VIEW("1JBQ8FS1/MM1", null),
    EXPORT("1G2FW/G3YIL8", VIEW),
    PRINT("4730fc9e000000ac", VIEW),
    STATISTIC("34IO/M+ROL2N", VIEW),
    SHARE_VIEW_LOGIN("34INQBN6=C66", VIEW),
    SHARE_VIEW("34INREXU/KK9", VIEW),
    NEW("12MM+OWI/D0Y", null),
    IMPORT("1G25ZATTQPQ=", NEW),
    SHARE_NEW_LOGIN("34INT71K2CEW", NEW),
    SHARE_NEW("34INU=A+O6A=", NEW),
    MODIFY("0AQ3YJ2LET+U", null),
    SHARE_MODIFY_LOGIN("34IO+CERTMX+", MODIFY),
    DELETE("4715e1f1000000ac", null);

    private String id;
    private PermItemEnum prePermItem;
    private static Map<String, List<String>> subPermItemMap;

    private PermItemEnum(String id, PermItemEnum prePermItem) {
        this.id = id;
        this.prePermItem = prePermItem;
    }

    public String getId() {
        return this.id;
    }

    public PermItemEnum getPrePermItem() {
        return this.prePermItem;
    }

    public static PermItemEnum of(String id) {
        PermItemEnum result = null;
        for (PermItemEnum type : PermItemEnum.values()) {
            if (!Objects.equals(type.getId(), id)) continue;
            result = type;
            break;
        }
        if (result == null) {
            result = VIEW;
        }
        return result;
    }

    public static Set<String> getIds() {
        HashSet<String> ids = new HashSet<String>(PermItemEnum.values().length);
        for (PermItemEnum permItemEnum : PermItemEnum.values()) {
            ids.add(permItemEnum.getId());
        }
        return ids;
    }

    public static Map<String, List<String>> getSubPermItemMap() {
        return subPermItemMap;
    }

    static {
        int length = PermItemEnum.values().length;
        subPermItemMap = new HashMap<String, List<String>>(length);
        for (PermItemEnum permItem : PermItemEnum.values()) {
            PermItemEnum prePermItem = permItem.getPrePermItem();
            if (prePermItem == null) continue;
            subPermItemMap.computeIfAbsent(prePermItem.getId(), v -> new ArrayList(length)).add(permItem.getId());
        }
    }
}

