/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.authorize.model;

public enum AuthTypeEnum {
    AUTH_ACCESS_TOKEN("1"),
    AUTH_DIGEST("2"),
    AUTH_JWT("3"),
    AUTH_BASE("4"),
    AUTH_SIGN("5"),
    API_AUTH_EXT("6");

    public static final String AUTH_ACCESS_TOKEN_ID = "1";
    public static final String AUTH_DIGEST_ID = "2";
    public static final String AUTH_JWT_ID = "3";
    public static final String AUTH_BASE_ID = "4";
    public static final String AUTH_SIGN_ID = "5";
    public static final String AUTH_EXT_ID = "6";
    private final String id;

    private AuthTypeEnum(String id) {
        this.id = id;
    }

    public static AuthTypeEnum getAuthEnum(String id) {
        for (AuthTypeEnum auth : AuthTypeEnum.values()) {
            if (!auth.getId().equalsIgnoreCase(id)) continue;
            return auth;
        }
        return null;
    }

    public static boolean isValid(String id) {
        if (id == null) {
            return false;
        }
        return AUTH_ACCESS_TOKEN_ID.equalsIgnoreCase(id = id.trim()) || AUTH_BASE_ID.equalsIgnoreCase(id) || AUTH_DIGEST_ID.equalsIgnoreCase(id) || AUTH_JWT_ID.equalsIgnoreCase(id) || AUTH_SIGN_ID.equalsIgnoreCase(id);
    }

    public String getId() {
        return this.id;
    }
}

