/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.algox;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algox.monitor.AlgoXJobMonitor;
import kd.bos.cbs.plugin.algox.CommonVariables;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class AlgoXJobMonitorImpl
implements AlgoXJobMonitor {
    private static final Log logger = LogFactory.getLog(AlgoXJobMonitorImpl.class);
    private static final String[] fields = new String[]{"FID", "FJOBNAME", "FJOBTYPE", "FOPERATOR", "FMASTERWEBURL", "FSTATUS", "FSTARTTIME", "FENDTIME", "FDURATION", "FJOBDETAILS", "FSTATISTICALANALYZE", "FJOBID"};
    private static final String queryByJobID = "SELECT FID,FJOBID,FJOBNAME,FJOBTYPE,FOPERATOR,FMASTERWEBURL,FSTATUS,FSTARTTIME,FENDTIME,FDURATION,FJOBDETAILS,FSTATISTICALANALYZE FROM T_CBS_ALGOX_JOBINST WHERE FJOBID=?";
    private static final String insertSql = "INSERT INTO T_CBS_ALGOX_JOBINST(FID,FJOBNAME,FJOBTYPE,FOPERATOR,FMASTERWEBURL,FSTATUS,FSTARTTIME,FENDTIME,FDURATION,FJOBDETAILS,FSTATISTICALANALYZE,FJOBID) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String updateSql = "UPDATE T_CBS_ALGOX_JOBINST SET FID=?,FJOBNAME=?,FJOBTYPE=?,FOPERATOR=?,FMASTERWEBURL=?,FSTATUS=?,FSTARTTIME=?,FENDTIME=?,FDURATION=?,FJOBDETAILS=?,FSTATISTICALANALYZE=? WHERE FJOBID=?";

    public String getJobDetailUrl(Object jobId) {
        String clickUrlPrefixWithRegion = AlgoXJobMonitorImpl.getClickUrlPrefix().replace("{region}", AlgoXJobMonitorImpl.getRegionByJobId(jobId));
        return clickUrlPrefixWithRegion + jobId;
    }

    public Map<String, Object> query(Object jobId) {
        String jobIdStr = String.valueOf(jobId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(11);
        DB.query((DBRoute)DBRoute.basedata, (String)queryByJobID, (Object[])new Object[]{jobIdStr}, resultSet -> {
            while (resultSet.next()) {
                resultMap.put("FID", resultSet.getLong("FID"));
                resultMap.put("FJOBID", resultSet.getString("FJOBID"));
                resultMap.put("FJOBNAME", resultSet.getString("FJOBNAME"));
                resultMap.put("FJOBTYPE", resultSet.getString("FJOBTYPE"));
                resultMap.put("FOPERATOR", resultSet.getString("FOPERATOR"));
                resultMap.put("FMASTERWEBURL", resultSet.getString("FMASTERWEBURL"));
                resultMap.put("FSTATUS", resultSet.getInt("FSTATUS"));
                resultMap.put("FDURATION", resultSet.getLong("FDURATION"));
                resultMap.put("FSTARTTIME", new Date(resultSet.getTimestamp("FSTARTTIME").getTime()));
                Timestamp endTime = resultSet.getTimestamp("FENDTIME");
                resultMap.put("FENDTIME", endTime == null ? null : new Date(endTime.getTime()));
                String jobDetails = resultSet.getString("FJOBDETAILS");
                resultMap.put("FJOBDETAILS", jobDetails == null ? " " : jobDetails);
                resultMap.put("FSTATISTICALANALYZE", resultSet.getString("FSTATISTICALANALYZE"));
            }
            return null;
        });
        return resultMap;
    }

    public void save(Object jobId, Map<String, Object> dataMap) {
        Map<String, Object> oldDataMap = this.query(jobId);
        Map<String, Object> newDataMap = this.completeMap(dataMap);
        try (TXHandle txHandle = TX.requiresNew();){
            if (oldDataMap != null && !oldDataMap.isEmpty()) {
                if (newDataMap.get("FSTATUS").equals(CommonVariables.STATUS_RUNNING)) {
                    newDataMap.replace("FDURATION", ((Date)newDataMap.get("FSTARTTIME")).getTime() - ((Date)oldDataMap.get("FSTARTTIME")).getTime());
                } else {
                    newDataMap.replace("FDURATION", ((Date)newDataMap.get("FENDTIME")).getTime() - ((Date)oldDataMap.get("FSTARTTIME")).getTime());
                }
                newDataMap.replace("FID", oldDataMap.get("FID"));
                newDataMap.replace("FSTARTTIME", oldDataMap.get("FSTARTTIME"));
                newDataMap.replace("FJOBTYPE", oldDataMap.get("FJOBTYPE"));
                newDataMap.replace("FOPERATOR", oldDataMap.get("FOPERATOR"));
                newDataMap.replace("FMASTERWEBURL", oldDataMap.get("FMASTERWEBURL"));
                DB.update((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])this.mapToParamList(newDataMap));
            } else {
                newDataMap.replace("FDURATION", System.currentTimeMillis() - ((Date)newDataMap.get("FSTARTTIME")).getTime());
                if (newDataMap.get("FJOBTYPE") == null) {
                    newDataMap.replace("FJOBTYPE", " ");
                }
                if (newDataMap.get("FOPERATOR") == null) {
                    newDataMap.replace("FOPERATOR", " ");
                }
                if (newDataMap.get("FMASTERWEBURL") == null) {
                    newDataMap.replace("FMASTERWEBURL", " ");
                }
                newDataMap.replace("FID", DB.genLongId((String)"T_CBS_ALGOX_JOBINST"));
                DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])this.mapToParamList(newDataMap));
            }
        }
        catch (Exception e) {
            logger.error("save algox monitor data is failed. ERROR_INFO: ", (Object)e.getMessage());
        }
    }

    private static String getClickUrlPrefix() {
        String domainUrl = UrlService.getDomainContextUrl();
        String urlHost = "";
        int flag = 0;
        for (int i = 0; i < domainUrl.length(); ++i) {
            if ('/' != domainUrl.charAt(i) || ++flag != 3) continue;
            urlHost = domainUrl.substring(i + 1, domainUrl.length());
            break;
        }
        return StringUtils.isEmpty((String)urlHost) ? domainUrl + "/cbs/rt/ax/index?region={region}&&server=/cbs/rt/ax/proxy3/cyh/cbs/algoxfp/#/jobs/" : domainUrl + "/cbs/rt/ax/index?region={region}&&server=/" + urlHost + "/cbs/rt/ax/proxy3/cyh/cbs/algoxfp/#/jobs/";
    }

    private Map<String, Object> completeMap(Map<String, Object> dataMap) {
        HashMap<String, Object> newDataMap = new HashMap<String, Object>(fields.length);
        for (String field : fields) {
            if ("FJOBNAME".equals(field) && dataMap.get(field) != null) {
                String jobName = (String)dataMap.get(field);
                jobName = jobName.length() > 40 ? jobName.substring(jobName.length() - 40) : jobName;
                newDataMap.put(field, jobName);
                continue;
            }
            newDataMap.put(field, dataMap.get(field));
        }
        return newDataMap;
    }

    private Object[] mapToParamList(Map<String, Object> dataMap) {
        Object[] paramList = new Object[fields.length];
        for (int i = 0; i < paramList.length; ++i) {
            paramList[i] = dataMap.get(fields[i]);
        }
        return paramList;
    }

    private static String getRegionByJobId(Object jobId) {
        String sql = "SELECT FJOBTYPE FROM T_CBS_ALGOX_JOBINST WHERE FJOBID=?";
        String[] region = new String[1];
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{jobId}, resultSet -> {
            while (resultSet.next()) {
                region[0] = resultSet.getString("FJOBTYPE");
            }
            return null;
        });
        return StringUtils.isEmpty((String)region[0]) ? "default" : region[0];
    }
}

