/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.algox;

import kd.bos.algox.jobclient.JobClientFactory;
import kd.bos.algox.monitor.AlgoXJobMonitorFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AlgoxJobinstListPlugin
extends AbstractListPlugin {
    public static final String ENTITY_NAME = "cbs_algox_jobinst";

    public void preOpenForm(PreOpenFormEventArgs e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("view".equals(evt.getItemKey())) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (selectedRows.size() == 1) {
                this.openSelectedRow(selectedRows);
            } else if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u4efb\u52a1\u3002", (String)"AlgoxJobinstListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        this.openSelectedRow(selectedRows);
        args.setCancel(true);
    }

    private void openSelectedRow(ListSelectedRowCollection selectedRows) {
        Object fid = selectedRows.get(0).getPrimaryKeyValue();
        QFilter filter = new QFilter("id", "=", fid);
        Object jobId = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"jobid", (QFilter[])new QFilter[]{filter}).get("jobid");
        boolean exists = JobClientFactory.get().checkJobExists((String)jobId);
        if (exists) {
            this.getView().openUrl(AlgoXJobMonitorFactory.getAlgoXJobMonitor().getJobDetailUrl(jobId));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u65e0\u6cd5\u67e5\u8be2\u5230\u4efb\u52a1\u8be6\u60c5\u3002", (String)"AlgoxJobinstListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
    }
}

