/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.algox;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algox.JobProgressListener;
import kd.bos.algox.cluster.ClusterFactory;
import kd.bos.algox.monitor.AlgoXJobMonitorFactory;
import kd.bos.cbs.plugin.algox.CommonVariables;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

public class JobProgressListenerImpl
extends JobProgressListener {
    private static final String VERTICE_ID = "{verticeID}";
    private static final String JOB_ID = "{jobID}";
    private static Log logger = LogFactory.getLog(JobProgressListenerImpl.class);
    private static final int readtimeout = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "30"));

    protected void onStart(Object jobId, String jobName, String region) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("FJOBID", String.valueOf(jobId));
        dataMap.put("FJOBNAME", jobName);
        dataMap.put("FJOBTYPE", region);
        dataMap.put("FSTARTTIME", new Date(System.currentTimeMillis()));
        dataMap.put("FSTATUS", CommonVariables.STATUS_RUNNING);
        dataMap.put("FOPERATOR", RequestContext.get().getUserName());
        AlgoXJobMonitorFactory.getAlgoXJobMonitor().save(jobId, dataMap);
    }

    protected void onFailed(Object jobId, String jobName, String region) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("FJOBID", String.valueOf(jobId));
        dataMap.put("FJOBNAME", jobName);
        dataMap.put("FJOBTYPE", region);
        dataMap.put("FENDTIME", new Date(System.currentTimeMillis()));
        dataMap.put("FSTATUS", CommonVariables.STATUS_FAILED);
        try {
            dataMap.put("FJOBDETAILS", this.getJobDetails(jobId, region));
        }
        catch (Exception e) {
            logger.error("getJobDetails error:", (Throwable)e);
        }
        AlgoXJobMonitorFactory.getAlgoXJobMonitor().save(jobId, dataMap);
    }

    protected void onFinished(Object jobId, String jobName, String region) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("FJOBID", String.valueOf(jobId));
        dataMap.put("FJOBNAME", jobName);
        dataMap.put("FJOBTYPE", region);
        dataMap.put("FENDTIME", new Date(System.currentTimeMillis()));
        dataMap.put("FSTATUS", CommonVariables.STATUS_FINISHED);
        try {
            dataMap.put("FJOBDETAILS", this.getJobDetails(jobId, region));
        }
        catch (Exception e) {
            logger.error("getJobDetails error:", (Throwable)e);
        }
        AlgoXJobMonitorFactory.getAlgoXJobMonitor().save(jobId, dataMap);
    }

    private String getJobDetails(Object jobId, String region) throws Exception {
        Map m;
        Object vertices;
        String jobIdStr = String.valueOf(jobId);
        HashMap<String, String> jobDetailsMap = new HashMap<String, String>();
        String jobReqPath = "/jobs/{jobID}".replace(JOB_ID, jobIdStr);
        String jobJson = this.httpGet(jobReqPath, region);
        jobDetailsMap.put(jobReqPath, jobJson);
        String configReqPath = "/jobs/{jobID}/config".replace(JOB_ID, jobIdStr);
        jobDetailsMap.put(configReqPath, this.httpGet(configReqPath, region));
        String exceptionReqPath = "/jobs/{jobID}/exceptions".replace(JOB_ID, jobIdStr);
        jobDetailsMap.put(exceptionReqPath, this.httpGet(exceptionReqPath, region));
        if (!StringUtils.isEmpty((Object)jobJson) && (vertices = (m = (Map)JSONUtils.cast((String)jobJson, Map.class)).get("vertices")) != null) {
            for (LinkedHashMap map : (ArrayList)vertices) {
                String verticeID = (String)map.get("id");
                if (verticeID == null) continue;
                String verticeRequestPath = "/jobs/{jobID}/vertices/{verticeID}".replace(JOB_ID, jobIdStr).replace(VERTICE_ID, verticeID);
                jobDetailsMap.put(verticeRequestPath, this.httpGet(verticeRequestPath, region));
                String verticeMetricReqPath = "/jobs/{jobID}/vertices/{verticeID}/metrics".replace(JOB_ID, jobIdStr).replace(VERTICE_ID, verticeID);
                jobDetailsMap.put(verticeMetricReqPath, this.httpGet(verticeMetricReqPath, region));
            }
        }
        return JSONUtils.toString(jobDetailsMap);
    }

    private String httpGet(String path, String region) throws Exception {
        String monitorUrl = ClusterFactory.getFactory().getClusterClient().getMonitorUrl(region);
        String reqPath = monitorUrl + path;
        return HttpClientUtils.get((String)reqPath, (int)5000, (int)(readtimeout * 1000));
    }
}

