/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.common.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.archive.service.ArchiveService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.exception.ExceptionUtil;

public class ArchiveFormUtils {
    private static ThreadLocal<Object> thSyncObject = ThreadLocals.create();

    public static Boolean taskLock(String entityName) {
        CountDownLatch cd = new CountDownLatch(1);
        AtomicBoolean ret = new AtomicBoolean(false);
        AtomicBoolean zkRunning = new AtomicBoolean(true);
        Object syncObject = new Object();
        ThreadPools.executeOnce((String)"taskLock", () -> {
            block10: {
                String lockKey = ArchiveService.getArchiveTaskLockKey((String)RequestContext.get().getAccountId(), (String)entityName);
                try {
                    DLock lock = DLock.create((String)lockKey);
                    if (!lock.tryLock()) break block10;
                    ret.set(true);
                    Object object = syncObject;
                    synchronized (object) {
                        try {
                            syncObject.wait(10000L);
                        }
                        catch (InterruptedException e) {
                            throw ExceptionUtil.wrap((Throwable)e);
                        }
                    }
                    lock.unlock();
                }
                catch (Exception e) {
                    zkRunning.set(false);
                }
                finally {
                    cd.countDown();
                }
            }
        });
        try {
            cd.await();
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
        if (zkRunning.get()) {
            boolean acquired = ret.get();
            if (acquired) {
                thSyncObject.set(syncObject);
            }
            return acquired;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseTaskLock() {
        Object syncObject = thSyncObject.get();
        if (syncObject != null) {
            Object object = syncObject;
            synchronized (object) {
                syncObject.notifyAll();
            }
            thSyncObject.remove();
        }
    }

    public static HashMap<String, String> parseCondition(String condition) {
        return (HashMap)JSON.parseObject((String)condition, HashMap.class);
    }

    public static List<IDataEntityProperty> getEntityPropertiesForChoose(String formId, boolean forIndices) {
        ArrayList<IDataEntityProperty> dps = new ArrayList<IDataEntityProperty>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection ps = dt.getProperties();
        int n = ps.size();
        for (int i = 0; i < n; ++i) {
            FieldProp fp;
            IDataEntityProperty dp = (IDataEntityProperty)ps.get(i);
            if ((ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp) || dp.getName().endsWith("_id") || !(dp instanceof PKFieldProp) && !(dp instanceof DateTimeProp) && !(dp instanceof ComboProp) && !(dp instanceof BasedataProp) && dp.getClass() != TextProp.class && !(dp instanceof DecimalProp)) && !(dp instanceof BooleanProp) || dp.getTableGroup() != null && !forIndices || dp instanceof TextProp && dp instanceof FieldProp && (fp = (FieldProp)dp).isSysField()) continue;
            dps.add(dp);
        }
        dps.sort(new Comparator<IDataEntityProperty>(){

            @Override
            public int compare(IDataEntityProperty o1, IDataEntityProperty o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return dps;
    }
}

