/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.common.util;

import java.util.List;
import java.util.Objects;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.StringUtils;

public class ArchiveScheduleUtils
implements ArchiveConstant {
    private static final ORM orm = ORM.create();

    private ArchiveScheduleUtils() {
    }

    public static PlanInfo getPlanInfo(String planId) {
        if (StringUtils.isEmpty((String)planId)) {
            return null;
        }
        DynamicObject scheduleObj = ORM.create().queryOne("sch_schedule", new QFilter("id", "=", (Object)planId).toArray());
        return Objects.isNull(scheduleObj) ? null : ArchiveScheduleUtils.convert2Pojo(scheduleObj);
    }

    private static PlanInfo convert2Pojo(DynamicObject scheduleObj) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setId(scheduleObj.getString("id"));
        planInfo.setNumber(scheduleObj.getString("number"));
        planInfo.setName(scheduleObj.getString("name"));
        planInfo.setJobId(ArchiveScheduleUtils.getJobId(scheduleObj));
        planInfo.setHost(scheduleObj.getString("txthost"));
        planInfo.setRepeatMode(ArchiveScheduleUtils.getRepeatMode(scheduleObj.getString("repeatmode")));
        planInfo.setPeriod(scheduleObj.getInt("cycleNum"));
        return planInfo;
    }

    private static String getJobId(DynamicObject scheduleObj) {
        DynamicObject job = scheduleObj.getDynamicObject("job");
        return Objects.isNull(job) ? "" : job.getString("id");
    }

    private static RepeatModeEnum getRepeatMode(String repeatMode) {
        RepeatModeEnum repeatModeEnum;
        if ("n".equalsIgnoreCase(repeatMode) || "def".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.NONE;
        } else if ("mi".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByMinutes;
        } else if ("h".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByHours;
        } else if ("d".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByDays;
        } else if ("w".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByWeeks;
        } else if ("m".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByMonths;
        } else if ("y".equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByYears;
        } else {
            throw ExceptionUtil.wrap((String)ResManager.loadKDString((String)"RepeatModeEnum\u4e0d\u5b58\u5728\u8be5\u679a\u4e3e\u503c\uff1a%s", (String)"ArchiveScheduleUtils_1", (String)"bos-cbs-plugin", (Object[])new Object[]{repeatMode}));
        }
        return repeatModeEnum;
    }

    public static void execute(Object scheduleId) {
        DynamicObject queryObj = orm.queryOne("bos_cbs_archi_schema", new QFilter("id", "=", scheduleId).toArray());
        String planId = queryObj.getString("scheduleplanid");
        List jobIds = ScheduleService.getInstance().getObjectFactory().getScheduleDao().getJobIdByScheduleId(planId);
        jobIds.forEach(jobId -> {
            JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(jobId);
            jobInfo.setScheduleId(planId);
            jobInfo.setScheduleMsgInfo(ArchiveScheduleUtils.buildScheduleMsgInfo(planId));
            ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        });
    }

    public static ScheduleMsgInfo buildScheduleMsgInfo(String scheduleId) {
        DynamicObject[] doList = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"schprincipal,sfailnotify,ssuccessnotify,snotifytype,msgreceiver,smsgcontent,stimeout", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scheduleId)});
        ScheduleMsgInfo msgInfo = new ScheduleMsgInfo();
        if (doList != null) {
            DynamicObject dynamicObject = doList[0];
            Object schprincipal = dynamicObject.get("schprincipal");
            if (schprincipal == null) {
                msgInfo.setSchPrincipal(0L);
            } else {
                DynamicObject schp = (DynamicObject)schprincipal;
                msgInfo.setSchPrincipal(((Long)schp.getPkValue()).longValue());
            }
            Object msgreceiver = dynamicObject.get("msgreceiver");
            if (msgreceiver == null) {
                msgInfo.setMsgreceiver(0L);
            } else {
                DynamicObject msgr = (DynamicObject)msgreceiver;
                msgInfo.setMsgreceiver(((Long)msgr.getPkValue()).longValue());
            }
            msgInfo.setFailNotify(dynamicObject.getBoolean("sfailnotify"));
            msgInfo.setSuccessNotify(dynamicObject.getBoolean("ssuccessnotify"));
            msgInfo.setNotifyType(dynamicObject.getString("snotifytype"));
            msgInfo.setMsgContent(dynamicObject.getString("smsgcontent"));
            msgInfo.setTimeOut(dynamicObject.getBoolean("stimeout"));
        }
        return msgInfo;
    }
}

