/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.service.elasticsearch.config.ESConfig;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveBillConfigUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;

public class ArchiveBillSetEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("entitynumber".equals(property)) {
            Map<String, String> map = this.getSelectedEntityNumberAndNameMap();
            if (!map.isEmpty()) {
                String entityNumber = map.get("number");
                try {
                    if (ORM.create().exists("bos_cbs_archi_billset", new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber)})) {
                        view.showMessage(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u5355\u636e\u8bbe\u7f6e\u5df2\u5b58\u5728\uff1a%s", (String)"ArchiveBillSetEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber));
                        this.getModel().setValue("entitynumber", null);
                        return;
                    }
                }
                catch (Exception exception) {
                    view.showMessage(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u5f52\u6863\u5355\u636e\u8bbe\u7f6e\u662f\u5426\u5df2\u5b58\u5728\u5f02\u5e38\uff1a%s", (String)"ArchiveBillSetEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), exception.getMessage()));
                }
                try {
                    Set allArchiveRoutes;
                    MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(entityNumber);
                    if (mainConfig != null && !(allArchiveRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes()).isEmpty()) {
                        view.showMessage(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u8fdb\u884c\u8fc7\u5206\u8868\u5f52\u6863\u914d\u7f6e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u5f52\u6863\u3002", (String)"ArchiveBillSetEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        this.getModel().setValue("entitynumber", null);
                        return;
                    }
                }
                catch (Exception exception) {
                    view.showMessage(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u5f52\u6863\u5355\u636e\u8bbe\u7f6e\u662f\u5426\u5b58\u5728\u5206\u8868\u5f52\u6863\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38\uff1a%s", (String)"ArchiveBillSetEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]), exception.getMessage()));
                }
                String name = map.get("name");
                model.setValue("number", (Object)entityNumber);
                model.setValue("name", (Object)name);
                if (ArchiveService.isLogEntity((String)entityNumber).booleanValue()) {
                    if (ESConfig.getDcESServer().isEslogEnable()) {
                        model.setValue("is_sync", (Object)false);
                        view.setEnable(Boolean.valueOf(true), new String[]{"is_store"});
                        view.setEnable(Boolean.valueOf(false), new String[]{"is_sync"});
                        view.setEnable(Boolean.valueOf(true), new String[]{"is_clean"});
                    } else {
                        view.setEnable(Boolean.valueOf(true), new String[]{"is_store"});
                        view.setEnable(Boolean.valueOf(true), new String[]{"is_sync"});
                        view.setEnable(Boolean.valueOf(true), new String[]{"is_clean"});
                    }
                } else if (ArchiveServiceConfig.isEnableAllEntityClean()) {
                    view.setEnable(Boolean.valueOf(true), new String[]{"is_store"});
                    view.setEnable(Boolean.valueOf(true), new String[]{"is_sync"});
                    view.setEnable(Boolean.valueOf(true), new String[]{"is_clean"});
                } else {
                    model.setValue("is_clean", (Object)false);
                    view.setEnable(Boolean.valueOf(true), new String[]{"is_store"});
                    view.setEnable(Boolean.valueOf(true), new String[]{"is_sync"});
                    view.setEnable(Boolean.valueOf(false), new String[]{"is_clean"});
                }
            }
        } else {
            boolean isStore = false;
            boolean isClean = false;
            boolean isSync = false;
            if ("is_store".equals(property)) {
                isStore = (Boolean)model.getValue("is_store");
            } else if ("is_clean".equals(property)) {
                isClean = (Boolean)model.getValue("is_clean");
            } else if ("is_sync".equals(property)) {
                isSync = (Boolean)model.getValue("is_sync");
            }
            if (isStore) {
                model.setValue("is_clean", (Object)(!isStore ? 1 : 0));
                model.setValue("is_sync", (Object)(!isStore ? 1 : 0));
            } else if (isClean) {
                model.setValue("is_store", (Object)(!isClean ? 1 : 0));
                model.setValue("is_sync", (Object)(!isClean ? 1 : 0));
            } else if (isSync) {
                model.setValue("is_clean", (Object)(!isSync ? 1 : 0));
                model.setValue("is_store", (Object)(!isSync ? 1 : 0));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    protected Map<String, String> getSelectedEntityNumberAndNameMap() {
        HashMap<String, String> result = new HashMap<String, String>(2);
        DynamicObject curBill = (DynamicObject)this.getModel().getValue("entitynumber");
        if (curBill != null) {
            BasedataEntityType rdType = (BasedataEntityType)curBill.getDataEntityType();
            result.put("number", (String)curBill.get(rdType.getNumberProperty()));
            result.put("name", ((ILocaleString)curBill.get(rdType.getNameProperty())).getLocaleValue());
        }
        return result;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, String> map = this.getSelectedEntityNumberAndNameMap();
        if (!map.isEmpty()) {
            String entityNumber = map.get("number");
            boolean isStore = (Boolean)this.getModel().getValue("is_store");
            if (!ArchiveServiceConfig.isEnableAllEntityClean() && !ArchiveService.isLogEntity((String)entityNumber).booleanValue() && isStore || ArchiveBillConfigUtils.existsArchiveConfig(entityNumber) || ArchiveBillConfigUtils.existCascadeConfig(entityNumber) || ArchiveBillConfigUtils.existIndexConfig(entityNumber)) {
                IFormView view = this.getView();
                view.setEnable(Boolean.valueOf(false), new String[]{"is_store"});
                view.setEnable(Boolean.valueOf(false), new String[]{"is_clean"});
                view.setEnable(Boolean.valueOf(false), new String[]{"is_sync"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        Map<String, String> map = this.getSelectedEntityNumberAndNameMap();
        if ("save".equalsIgnoreCase(operateKey)) {
            String entityNumber = map.get("number");
            Object entityObj = this.getModel().getValue("entitynumber");
            if (entityObj == null) {
                args.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5b9e\u4f53\u3002", (String)"ArchiveBillSetEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (ArchiveService.isLogEntity((String)entityNumber).booleanValue()) {
                boolean isSync = (Boolean)this.getModel().getValue("is_sync");
                if (isSync && ESConfig.getDcESServer().isEslogEnable()) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"ES\u5b58\u50a8\u65e5\u5fd7\u5355\u636e\u4e0d\u53ef\u4ee5\u9009\u62e9\u5f52\u6863\u540c\u6b65\u3002", (String)"ArchiveBillSetEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
            } else {
                boolean isClean = (Boolean)this.getModel().getValue("is_clean");
                if (isClean && !ArchiveServiceConfig.isEnableAllEntityClean()) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u65e5\u5fd7\u5355\u636e\u4e0d\u53ef\u4ee5\u9009\u62e9\u5f52\u6863\u6e05\u9664\u3002", (String)"ArchiveBillSetEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

