/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveBillConfigUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.query.impl.BaseData;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ArchiveCascadeEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit billSet = (BasedataEdit)this.getView().getControl("billset");
        BasedataEdit parent = (BasedataEdit)this.getView().getControl("parent");
        billSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"joinfield"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control formControl = (Control)evt.getSource();
        String key = formControl.getKey();
        if (Objects.equals("joinfield", key)) {
            this.showFieldChooseView();
        }
    }

    private void showFieldChooseView() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BaseData billInfo = ArchiveBillConfigUtils.getBaseData(model, "billset");
        if (Objects.isNull(billInfo)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5355\u636e\u3002", (String)"ArchiveCascadeEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        BaseData parentBill = ArchiveBillConfigUtils.getBaseData(model, "parent");
        if (Objects.isNull(parentBill)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7236\u5355\u636e\u3002", (String)"ArchiveCascadeEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_cbs_archi_fields");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.getCustomParams().put("ismulti", Boolean.FALSE.toString());
        fsp.getCustomParams().put("entitynumber", billInfo.getNumber());
        fsp.getCustomParams().put("fields", model.getValue("joinfield"));
        fsp.setCaption(ResManager.loadKDString((String)"\u5173\u8054\u5c5e\u6027", (String)"ArchiveCascadeEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "joinfield"));
        this.getView().showForm(fsp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String fieldName = e.getProperty().getName();
        if (Objects.equals("billset", fieldName)) {
            BaseData billInfo = ArchiveBillConfigUtils.getBaseData(this.getModel(), "billset");
            model.setValue("joinfield", null);
            if (Objects.isNull(billInfo)) {
                return;
            }
            model.setValue("entitynumber", (Object)billInfo.getNumber());
            model.setValue("number", (Object)billInfo.getNumber());
            model.setValue("name", (Object)billInfo.getName());
            if (ArchiveBillConfigUtils.existsArchiveConfig(billInfo.getNumber())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"parent"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"joinfield"});
                model.setValue("parent", null);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"parent"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"joinfield"});
            }
        } else if (Objects.equals("parent", fieldName)) {
            BaseData parent = ArchiveBillConfigUtils.getBaseData(model, "parent");
            if (Objects.isNull(parent)) {
                model.setValue("parentnumber", null);
            } else {
                model.setValue("parentnumber", (Object)parent.getNumber());
            }
            TextEdit joinField = (TextEdit)view.getControl("joinfield");
            joinField.setMustInput(Objects.nonNull(parent));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        if ("joinfield".equals(actionId)) {
            model.setValue("joinfield", retData);
        }
    }

    private boolean isDuplicate(String entityNumber) {
        QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_archi_cascade", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return Objects.nonNull(object);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IFormView view = this.getView();
        String fieldName = e.getProperty().getName();
        if (Objects.equals(fieldName, "parent")) {
            BaseData billInfo = ArchiveBillConfigUtils.getBaseData(this.getModel(), "billset");
            if (billInfo == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5355\u636e\u3002", (String)"ArchiveCascadeEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String entityNumber = billInfo.getNumber();
            e.addCustomQFilter(new QFilter("number", "!=", (Object)entityNumber));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseData billInfo = ArchiveBillConfigUtils.getBaseData(this.getModel(), "billset");
        BaseData parentBill = ArchiveBillConfigUtils.getBaseData(this.getModel(), "parent");
        if (Objects.nonNull(billInfo)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billset"});
            if (ArchiveBillConfigUtils.existsArchiveConfig(billInfo.getNumber()) || this.existsAndEnableRootBillArchiveConfig()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"parent"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"joinfield"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"billset"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"parent"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"joinfield"});
        }
        if (Objects.nonNull(parentBill)) {
            TextEdit joinField = (TextEdit)this.getView().getControl("joinfield");
            joinField.setMustInput(true);
            this.getModel().setValue("parentnumber", (Object)parentBill.getNumber());
        }
    }

    private boolean existsAndEnableRootBillArchiveConfig() {
        BaseData parentBill = ArchiveBillConfigUtils.getBaseData(this.getModel(), "parent");
        if (Objects.isNull(parentBill)) {
            return false;
        }
        Long parentPkValue = (Long)parentBill.getId();
        DynamicObject rootBill = ArchiveBillConfigUtils.getCascadeRootBill(parentPkValue);
        String entityNumber = rootBill.getString("number");
        return ArchiveBillConfigUtils.existsAndEnableArchiveConfig(entityNumber);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IFormView view = this.getView();
        if ("save".equalsIgnoreCase(operateKey) || "saveandnew".equalsIgnoreCase(operateKey)) {
            String routeKey;
            BaseData billInfo = ArchiveBillConfigUtils.getBaseData(this.getModel(), "billset");
            if (Objects.isNull(billInfo)) {
                return;
            }
            String entityNumber = billInfo.getNumber();
            if (this.isDuplicate(entityNumber)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u5b58\u5728\u7ea7\u8054\u914d\u7f6e\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ArchiveCascadeEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                args.setCancel(true);
                return;
            }
            if (ArchiveBillConfigUtils.existsAndEnableArchiveConfig(entityNumber)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u914d\u7f6e\u542f\u7528\u5f52\u6863\u89c4\u5219\uff0c\u8bf7\u5148\u7981\u7528\u8be5\u5355\u636e\u7684\u5f52\u6863\u89c4\u5219\u518d\u6dfb\u52a0\u7ea7\u8054\u914d\u7f6e\u3002", (String)"ArchiveCascadeEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                args.setCancel(true);
                return;
            }
            BaseData parentData = ArchiveBillConfigUtils.getBaseData(this.getModel(), "parent");
            if (Objects.isNull(parentData)) {
                return;
            }
            String parentNumber = parentData.getNumber();
            String number = billInfo.getNumber();
            String parentRouteKey = ORM.create().getDataEntityType(parentNumber).getDBRouteKey();
            if (!Objects.equals(parentRouteKey, routeKey = ORM.create().getDataEntityType(number).getDBRouteKey())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u5355\u636e\u548c\u7236\u5355\u636e\u9700\u8981\u5728\u540c\u4e00\u4e2a\u5e94\u7528\u5e93\u4e0b\u3002", (String)"ArchiveCascadeEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject rootBill = ArchiveBillConfigUtils.getCascadeRootBill((Long)parentData.getId());
            String rootEntityNumber = rootBill.getString("entitynumber");
            if (ArchiveBillConfigUtils.existsAndEnableArchiveConfig(rootEntityNumber)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6839\u5355\u636e[%s]\u5df2\u914d\u7f6e\u542f\u7528\u5f52\u6863\u89c4\u5219\uff0c\u8bf7\u5148\u7981\u7528\u6839\u5355\u636e\u7684\u5f52\u6863\u89c4\u5219\u3002", (String)"ArchiveCascadeEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[]{rootEntityNumber}));
                args.setCancel(true);
            } else if ((Integer)this.getModel().getValue("level") > 3) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u9650\u5236\u6700\u591a\u7ea7\u8054\u4e09\u7ea7\u3002", (String)"ArchiveCascadeEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[]{parentNumber}));
                args.setCancel(true);
            }
        }
    }
}

