/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.archive.framework.plugin.ArchivePlugin;
import kd.bos.archive.service.ArchiveService;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveFormUtils;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ArchiveConditionEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        JSONObject conditionParams = (JSONObject)view.getFormShowParameter().getCustomParam("conditionParams");
        String filterType = (String)view.getFormShowParameter().getCustomParam("filtertype");
        if ("custom".equals(filterType)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"flexfilter"});
            view.setVisible(Boolean.valueOf(true), new String[]{"flexcustom"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"flexfilter"});
            view.setVisible(Boolean.valueOf(false), new String[]{"flexcustom"});
            if (!conditionParams.isEmpty()) {
                String entityNumber = conditionParams.getString("number");
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
                filterGrid.setEntityNumber(entityNumber);
                ArrayList<String> keys = new ArrayList<String>();
                List<IDataEntityProperty> dps = ArchiveFormUtils.getEntityPropertiesForChoose(entityNumber, false);
                if ("es".equals(filterType) || ArchiveService.isLogEntity((String)entityNumber).booleanValue()) {
                    keys.add("opdate");
                } else {
                    dps.forEach(dp -> {
                        String alias = dp.getAlias();
                        if (Objects.nonNull(alias) || StringUtils.isNotEmpty((CharSequence)alias)) {
                            if (dp instanceof BasedataProp) {
                                keys.add(dp.getName() + "." + ((BasedataProp)dp).getNumberProp());
                            } else {
                                keys.add(dp.getName());
                            }
                        }
                    });
                }
                filterGrid.setFilterFieldKeys(keys);
            }
        }
    }

    public void afterBindData(EventObject e) {
        String filterType = this.getPageCache().get("filtertype");
        if (!"custom".equals(filterType)) {
            FilterCondition filterCondition;
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            String filter = this.loadFilter();
            FilterCondition filterCondition2 = filterCondition = filter == null ? null : (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            if (filterCondition != null) {
                filterGrid.SetValue(filterCondition);
            } else {
                List filterFieldKeys = filterGrid.getFilterFieldKeys();
                if (filterFieldKeys.contains("bizdate") || filterFieldKeys.contains("biztime")) {
                    filterCondition = filterGrid.getFilterGridState().getFilterCondition();
                    List filterRow = filterCondition.getFilterRow();
                    ArrayList filterValues = new ArrayList(2);
                    filterRow.add(new SimpleFilterRow("", CompareTypeEnum.BETWEEN.getId(), filterFieldKeys.contains("bizdate") ? "bizdate" : "biztime", "", "0", filterValues));
                    filterGrid.SetValue(filterCondition);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String filterType = (String)this.getView().getFormShowParameter().getCustomParam("filtertype");
        this.getPageCache().put("filtertype", filterType);
        if ("custom".equals(filterType)) {
            this.getModel().setValue("archiveplugin", (Object)this.loadFilter());
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btn_ok")) {
            String filter;
            String filterType = this.getPageCache().get("filtertype");
            HashMap<String, String> map = new HashMap<String, String>(2);
            if ("custom".equals(filterType)) {
                filter = (String)this.getModel().getValue("archiveplugin");
                if (StringUtils.isNotEmpty((CharSequence)filter)) {
                    try {
                        Class<ArchivePlugin> archivePluginClazz = Class.forName(filter);
                        if (!ArchivePlugin.class.isAssignableFrom(archivePluginClazz) || archivePluginClazz.isAssignableFrom(ArchivePlugin.class)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u9700\u8981\u5b9e\u73b0ArchivePlugin\u7c7b", (String)"ArchiveConfigEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]), filter));
                            return;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u63d2\u4ef6\u7c7b\uff1a%s", (String)"ArchiveConfigEditPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]), filter));
                        return;
                    }
                }
            } else {
                FilterCondition filterCondition = this.getFilter();
                filter = this.saveFilter(filterCondition);
            }
            map.put(filterType, filter);
            JSONObject jsonObject = new JSONObject(map);
            this.getView().returnDataToParent((Object)jsonObject.toString());
            this.getView().close();
        }
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private String loadFilter() {
        String condition = (String)this.getView().getFormShowParameter().getCustomParam("condition");
        if (StringUtils.isBlank((CharSequence)condition)) {
            return null;
        }
        HashMap<String, String> map = ArchiveFormUtils.parseCondition(condition);
        String filterType = this.getPageCache().get("filtertype");
        String filter = map.get(filterType);
        return filter;
    }

    private String saveFilter(FilterCondition filterCondition) {
        String filter = "";
        if (filterCondition != null && !filterCondition.getFilterRow().isEmpty()) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filter;
    }
}

