/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.TwoSymbolSequence;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.archive.RouteInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ArchiveDataBaseEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    private static final char delim = '$';
    private static Set<String> noSuffixes = new HashSet<String>(2);
    private static final Pattern regex = Pattern.compile("[A-Za-z][A-Za-z\\d]");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initDatabaseCombo();
    }

    public void beforeBindData(EventObject e) {
        this.initDatabaseCombo();
    }

    private Set<ArchiveInfo> getAllArchiveInfoSet() {
        List routeInfoList = MCArchive.get();
        TreeSet<ArchiveInfo> archiveInfoSet = new TreeSet<ArchiveInfo>(Comparator.comparing(ArchiveInfo::getKey));
        for (RouteInfo routeInfo : routeInfoList) {
            String routeKey = routeInfo.getRouteKey();
            List archiveInfo = routeInfo.getArchiveInfo();
            for (ArchiveInfo archive : archiveInfo) {
                if (routeKey.equals(archive.getKey())) continue;
                archiveInfoSet.add(archive);
            }
        }
        List esRouteInfoList = MCArchive.getESArchiveInfo();
        for (ArchiveInfo archive : esRouteInfoList) {
            archiveInfoSet.add(archive);
        }
        return archiveInfoSet;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("database".equals(property)) {
            this.initLogicArchiveKey();
        } else if ("database_type".equals(property)) {
            this.initDatabaseCombo();
        }
    }

    private void initLogicArchiveKey() {
        IDataModel model = this.getModel();
        String databaseType = (String)model.getValue("database_type");
        String databaseKey = (String)model.getValue("database");
        if (StringUtils.isNotEmpty((String)databaseKey)) {
            LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)databaseKey);
            String realArchiveKey = logicArchiveRoute.getRealArchiveKey();
            QFilter qf = new QFilter("archiveroute", "like", (Object)(realArchiveKey + "%"));
            int count = ORM.create().count("ArchiveDataBaseEditPluginAlgoKey", "bos_cbs_archi_database", qf.toArray());
            String logicSuffix = TwoSymbolSequence.toString(count);
            model.setValue("number", (Object)(databaseKey + "_" + logicSuffix).toUpperCase());
            model.setValue("logicsuffix", (Object)('$' + logicSuffix));
            model.setValue("archiveroute", (Object)(databaseKey + '$' + logicSuffix));
        }
    }

    private void initDatabaseCombo() {
        IDataModel model = this.getModel();
        String databasetypeKey = (String)model.getValue("database_type");
        if (StringUtils.isNotEmpty((String)databasetypeKey)) {
            databasetypeKey = databasetypeKey.toLowerCase();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
            ComboEdit archiveRoute = (ComboEdit)this.getControl("database");
            Set<ArchiveInfo> archiveInfoSet = this.getAllArchiveInfoSet();
            for (ArchiveInfo archiveInfo : archiveInfoSet) {
                if (!archiveInfo.getRouteType().getKey().equals(databasetypeKey)) continue;
                ComboItem comboItem = new ComboItem(new LocaleString(archiveInfo.getName()), archiveInfo.getKey());
                comboItems.add(comboItem);
            }
            if (ArchiveRouteType.DB.getKey().equals(databasetypeKey)) {
                ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u5e93", (String)"ArchiveDataBaseEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0])), "cur_database");
                comboItems.add(comboItem);
            }
            archiveRoute.setComboItems(comboItems);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        MainEntityType dataEntityType = model.getDataEntityType();
        if ("save".equals(operateKey)) {
            String logicSuffix = (String)model.getValue("logicsuffix");
            if (StringUtils.isNotEmpty((String)logicSuffix)) {
                String databaseKey = (String)model.getValue("database");
                Matcher matcher = regex.matcher((logicSuffix = logicSuffix.toLowerCase()).substring(1));
                if (!matcher.matches()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u903b\u8f91\u5e93\u540e\u7f00\u662f\u4ee5\u5b57\u6bcd\u5f00\u5934\u7684\u4e24\u4e2a\u5b57\u7b26\u7ec4\u5408\u3002", (String)"ArchivePlanEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    model.setValue("logicsuffix", null);
                    e.setCancel(true);
                    return;
                }
                if (noSuffixes.contains(logicSuffix)) {
                    logicSuffix = '$' + TwoSymbolSequence.next(logicSuffix.substring(1));
                    model.setValue("logicsuffix", (Object)logicSuffix);
                    model.setValue("number", (Object)(databaseKey + "_" + logicSuffix.substring(1)).toUpperCase());
                    model.setValue("archiveroute", (Object)(databaseKey + logicSuffix));
                    view.invokeOperation("save");
                    e.setCancel(true);
                    return;
                }
                String archiveKey = (String)model.getValue("archiveroute");
                if (StringUtils.isNotEmpty((String)archiveKey) && ORM.create().exists("bos_cbs_archi_database", new QFilter("archiveroute", "=", (Object)archiveKey).and(dataEntityType.getPrimaryKey().getName(), "!=", model.getDataEntity().getPkValue()).toArray())) {
                    logicSuffix = '$' + TwoSymbolSequence.next(logicSuffix.substring(1));
                    model.setValue("logicsuffix", (Object)logicSuffix);
                    model.setValue("number", (Object)(databaseKey + "_" + logicSuffix.substring(1)).toUpperCase());
                    model.setValue("archiveroute", (Object)(databaseKey + logicSuffix));
                    view.invokeOperation("save");
                    e.setCancel(true);
                    return;
                }
            }
            model.setValue("status", (Object)"C");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ShardingConfigTemplateEditConfig_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            this.getView().invokeOperation("close");
        }
    }

    static {
        noSuffixes.add("$ai");
        noSuffixes.add("$am");
        noSuffixes.addAll(Arrays.asList("$a0,$a1,$a2,$a3,$a4,$a5,$a6,$a7,$a8,$a9,$pk".split(",")));
    }
}

