/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.EventObject;
import java.util.Map;
import kd.bos.archive.config.AccountArchiveEnableChangedNotifier;
import kd.bos.archive.config.ArchiveParameterValues;
import kd.bos.archive.config.ArchiveParameters;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ArchiveParameterEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    private static final String lockKey = "/archive/parameter/save";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        ArchiveParameterValues pv = ArchiveParameters.get();
        model.setValue("is_archive_enable", (Object)pv.isEnable());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("save".equals(itemKey)) {
            try (DLock lock = DLock.create((String)lockKey);){
                if (lock.tryLock()) {
                    IDataModel model = this.getModel();
                    boolean isArchiveEnable = (Boolean)model.getValue("is_archive_enable");
                    ArchiveParameterValues pv = ArchiveParameters.get();
                    pv.setEnable(isArchiveEnable);
                    String data = SerializationUtils.toJsonString((Object)pv.getAll());
                    Map<String, Object> map = this.queryArchiveParameter();
                    if (map != null && !map.isEmpty()) {
                        this.updateArchiveParameter(data);
                    } else {
                        this.insertArchiveParameter(data);
                    }
                    AccountArchiveEnableChangedNotifier.fireReloadAccountArchiveEnable((boolean)isArchiveEnable);
                    pv.flushToMovingService(RequestContext.get().getAccountId());
                }
            }
        }
    }

    private Map<String, Object> queryArchiveParameter() {
        String data = (String)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT FDATA FROM T_CBS_ARCHI_PARAM WHERE FTYPE = ?", (Object[])new Object[]{"archive"}, rs -> {
            if (rs.next()) {
                return rs.getString("FDATA");
            }
            return null;
        });
        Map dataMap = StringUtils.isNotBlank((CharSequence)data) ? (Map)SerializationUtils.fromJsonString((String)data, Map.class) : null;
        return dataMap;
    }

    private void insertArchiveParameter(String data) {
        DB.execute((DBRoute)DBRoute.basedata, (String)"INSERT INTO T_CBS_ARCHI_PARAM(FID,FDATA,FTYPE) VALUES (?,?,?)", (Object[])new Object[]{DB.genGlobalLongId(), data, "archive"});
    }

    private void updateArchiveParameter(String data) {
        DB.update((DBRoute)DBRoute.basedata, (String)"UPDATE T_CBS_ARCHI_PARAM SET FDATA = ? WHERE FTYPE = ?", (Object[])new Object[]{data, "archive"});
    }
}

