/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveManager;
import kd.bos.bill.BillShowParameter;
import kd.bos.cbs.plugin.archive.common.config.ArchiveControlConfig;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.metadata.form.control.BarItemAp;

public class ArchiveReverseFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
ArchiveLogable,
ArchiveConstant {
    private static final String billListAP = "billlistap";
    private static final String toolBar = "toolbarap";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{toolBar});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String entityNumber;
        Map customParams = e.getFormShowParameter().getCustomParams();
        if (!customParams.isEmpty() && Objects.isNull(entityNumber = (String)customParams.get("entityNumber"))) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u4ece\u5df2\u5f52\u6863\u5355\u636e\u83dc\u5355\u5165\u53e3\u8fdb\u5165\u3002", (String)"ArchiveReverseFormPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void initialize() {
        IPageCache pageCache = this.getPageCache();
        String isInit = pageCache.get("isInit");
        if (!Boolean.parseBoolean(isInit)) {
            String entityNumber;
            IFormView view = this.getView();
            BillList antiArchiveList = (BillList)view.getControl(billListAP);
            Map customParams = view.getFormShowParameter().getCustomParams();
            if (!customParams.isEmpty() && Objects.nonNull(entityNumber = (String)customParams.get("entityNumber"))) {
                String route = (String)customParams.get("route");
                String archiveRoute = (String)customParams.get("archiveRoute");
                antiArchiveList.setBillFormId(entityNumber);
                antiArchiveList.getListModel().setRouteKey(route);
                antiArchiveList.getListModel().setAchiveKey(archiveRoute);
                antiArchiveList.addHyperClickListener((HyperLinkClickListener)this);
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String isInitBarItem = pageCache.get("isInitBarItem");
        if (!Boolean.parseBoolean(isInitBarItem)) {
            if (ArchiveControlConfig.isAllAntiArchiveEnable()) {
                Container tb = (Container)view.getControl(toolBar);
                BarItemAp allAntiArchive = new BarItemAp();
                ArrayList<Map> items = new ArrayList<Map>();
                allAntiArchive.setId("all_anti_archiving");
                allAntiArchive.setKey("all_anti_archiving");
                allAntiArchive.setName(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u53cd\u5f52\u6863", (String)"ArchiveReverseFormPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                allAntiArchive.setBusyTip(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u53cd\u5f52\u6863\u4e2d\uff0c\u8bf7\u7b49\u5019\u3002", (String)"ArchiveReverseFormPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                items.add(allAntiArchive.createControl());
                tb.addControls(items);
            }
            pageCache.put("isInitBarItem", "true");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        BillList billList = (BillList)this.getControl(billListAP);
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if ("billno".equals(fieldName) || "number".equals(fieldName)) {
            IFormView view = this.getView();
            FormShowParameter showParameter = view.getFormShowParameter();
            String entityNumber = (String)showParameter.getCustomParam("entityNumber");
            String route = (String)showParameter.getCustomParam("route");
            String archiveRoute = (String)showParameter.getCustomParam("archiveRoute");
            if (Objects.nonNull(currentSelectedRowInfo)) {
                Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
                BillShowParameter bsp = new BillShowParameter();
                bsp.setFormId(entityNumber);
                bsp.setRouteKey(route);
                bsp.setArchiveKey(archiveRoute);
                bsp.setPkId(primaryKeyValue);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)bsp);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("all_anti_archiving".equals(itemKey)) {
            this.getView().invokeOperation("all_anti_archiving");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate form = (FormOperate)args.getSource();
        String itemKey = form.getOperateKey();
        if ("anti_archiving".equals(itemKey)) {
            BillList billList = (BillList)this.getControl(billListAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AntiArchivingTemplateListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String confirmTip = ResManager.loadKDString((String)"\u5c06\u5bf9\u6240\u9009\u6570\u636e\u8fdb\u884c\u53cd\u5f52\u6863\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"AntiArchivingTemplateListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("antiArchive");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        } else if ("all_anti_archiving".equals(itemKey)) {
            String confirmTip = ResManager.loadKDString((String)"\u5c06\u5bf9\u6240\u6709\u6570\u636e\u8fdb\u884c\u53cd\u5f52\u6863\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"AntiArchivingTemplateListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("all_antiArchive");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        } else if ("bar_refresh".equals(itemKey)) {
            BillList billList = (BillList)this.getControl(billListAP);
            billList.clearSelection();
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (messageBoxClosedEvent.getCallBackId().equals("antiArchive")) {
                BillList billList = (BillList)this.getControl(billListAP);
                Object id = this.getView().getFormShowParameter().getCustomParam("id");
                long entityRecordId = id instanceof Integer ? ((Integer)id).longValue() : ((Long)id).longValue();
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                ArrayList<Object> pkIds = new ArrayList<Object>(selectedRows.size());
                for (ListSelectedRow selectedRow : selectedRows) {
                    Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                    pkIds.add(primaryKeyValue);
                }
                ArchiveManager.get().addArchiveReverseTask(entityRecordId, pkIds);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u6dfb\u52a0\u53cd\u5f52\u6863\u4efb\u52a1\u3002", (String)"AntiArchivingTemplateListPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            } else if (messageBoxClosedEvent.getCallBackId().equals("all_antiArchive")) {
                Object id = this.getView().getFormShowParameter().getCustomParam("id");
                long entityRecordId = id instanceof Integer ? ((Integer)id).longValue() : ((Long)id).longValue();
                try {
                    ArchiveManager.get().addArchiveReverseTask(entityRecordId);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u6dfb\u52a0\u53cd\u5f52\u6863\u4efb\u52a1\u3002", (String)"AntiArchivingTemplateListPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    log.error("All Anti-Archive failed:" + e.getMessage(), (Throwable)e);
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

