/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import com.alibaba.fastjson.JSON;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.parser.CronParser;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.xdb.exception.ExceptionUtil;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class ArchiveSchEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    private static final Log logger = LogFactory.getLog(ArchiveSchEditPlugin.class);
    private static final String FROM_BIZ = "frombiz";
    private static final String COMBDORW = "combdorw";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TASKCLASSNAME = "taskclassname";
    private static final String ENTRYENTITY = "entryentity";
    private static final String MSG_NOTIFY_ENTITY = "msgnotifyentity";
    private static final String LOAD_DATA = "loadData";
    private static final String COMNO = "comno";
    private static final String REPEAT_MODE = "repeatmode";
    private static final String COM_WEEK = "comweek";
    private static final String COMNOBY_MONTH = "comnobymonth";
    private static final String COM_WEEKBY_MONTH = "comweekbymonth";
    private static final String TXTDESC = "txtdesc";
    private static final String SKDP = "_SKDP";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final String CYCLE_NUM = "cyclenum";
    private static final String SAVE_PLUGIN_13 = "SavePlugin_13";
    private static final String SAVE_PLUGIN_19 = "SavePlugin_19";
    private static final String CKHOUR = "ckhour_";
    private static final String CKHOUR_0 = "ckhour_0";
    private static final String SAVE_PLUGIN_22 = "SavePlugin_22";
    private static final String CKBY_WEEK = "ckbyweek";
    private static final String FLEXPBY_WEEK = "flexpbyweek";
    private static final String FLEXP_HOUR = "flexphour";
    private static final String JOBNUMBER = "jobnumber";
    private static final String FLEXPDAYS = "flexpdays";
    private static final Log log = LogFactory.getLog((String)"kd.bos.schedule.formplugin.SavePlugin");
    private static final CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};
    private static final String[] CKWEEK = new String[]{"cksun", "ckmon", "cktues", "ckwed", "ckthur", "ckfri", "cksat"};
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String BTNEXECUTE = "btnexecute";
    private static final String BTN_DETECT_TASK = "btndetecttask";
    private static final String DEFINE = "def";
    private static final String NOREPEAT = "n";
    private static final String YEAR = "y";
    private static final String MONTH = "m";
    private static final String WEEK = "w";
    private static final String DAY = "d";
    private static final String HOUR = "h";
    private static final String MINUTE = "mi";
    private static final String STATUS_ENABLE = "1";
    private static final int GEN_DESC_TIME_NUM = 10;
    private boolean callWithComboEdit = true;

    public void initialize() {
        super.initialize();
        Toolbar tb = (Toolbar)this.getView().getControl("toolbarap");
        tb.addItemClickListener((ItemClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabselectevent -> {
            String key = tabselectevent.getTabKey();
            if ("tabweekpage".equals(key)) {
                this.getModel().setValue(COMBDORW, (Object)WEEK);
            } else {
                this.getModel().setValue(COMBDORW, (Object)DAY);
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String scheduleId = (String)this.getView().getFormShowParameter().getCustomParam("schplanid");
        if (!StringUtils.isEmpty((CharSequence)scheduleId)) {
            QFilter filter = new QFilter("id", "=", (Object)scheduleId);
            String selectFields = "id,number,name,job,starttime,endtime,plan,repeatmode,cyclenum,txthost,txtdesc,status,creator,createtime,modifier,modifytime";
            DynamicObject scheScheduleInfo = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (String)selectFields, (QFilter[])new QFilter[]{filter});
            this.getModel().setValue("id", scheScheduleInfo.get("id"));
            this.getModel().setValue("schplanid", scheScheduleInfo.get("id"));
            this.getModel().setValue(NUMBER, scheScheduleInfo.get(NUMBER));
            this.getModel().setValue(NAME, (Object)scheScheduleInfo.get(NAME).toString());
            this.getModel().setValue("job", scheScheduleInfo.get("job"));
            this.getModel().setValue(STARTTIME, scheScheduleInfo.get(STARTTIME));
            this.getModel().setValue(ENDTIME, scheScheduleInfo.get(ENDTIME));
            this.callWithComboEdit = false;
            this.getModel().setValue(REPEAT_MODE, scheScheduleInfo.get(REPEAT_MODE));
            this.getModel().setValue(CYCLE_NUM, scheScheduleInfo.get(CYCLE_NUM));
            this.getModel().setValue("txthost", scheScheduleInfo.get("txthost"));
            this.getModel().setValue(TXTDESC, scheScheduleInfo.get(TXTDESC));
            this.getModel().setValue("status", scheScheduleInfo.get("status"));
            this.getModel().setValue("creator", scheScheduleInfo.get("creator"));
            this.getModel().setValue("createtime", scheScheduleInfo.get("createtime"));
            this.getModel().setValue("modifier", scheScheduleInfo.get("modifier"));
            this.getModel().setValue("modifytime", scheScheduleInfo.get("modifytime"));
            this.getModel().setValue("plan", scheScheduleInfo.get("plan"));
        }
    }

    public void afterBindData(EventObject e) {
        String fromBiz;
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTNEXECUTE});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DETECT_TASK});
        if (status != OperationStatus.ADDNEW) {
            String hourTemp;
            this.getView().setVisible(Boolean.FALSE, new String[]{"job"});
            this.callWithComboEdit = false;
            this.adjustByRepeatMode();
            fromBiz = (String)this.getView().getFormShowParameter().getCustomParam(FROM_BIZ);
            if (fromBiz != null && fromBiz.equals("true")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnconfirm"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap10"});
            }
            DynamicObjectCollection docs = this.getModel().getEntryEntity(ENTRYENTITY);
            if (this.getModel().getValue("job") != null) {
                if (docs.isEmpty()) {
                    this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
                }
                if (StringUtils.isBlank((Object)((DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(0)).get(JOBNUMBER))) {
                    this.getModel().beginInit();
                    this.getModel().setValue(JOBNUMBER, this.getModel().getValue("job"), 0);
                    this.getModel().endInit();
                    this.getView().updateView(ENTRYENTITY, 0);
                }
            }
            this.getPageCache().put(LOAD_DATA, "true");
            Tab tab = (Tab)this.getControl("tabap");
            Object combdorw = this.getModel().getValue(COMBDORW);
            if (combdorw != null && WEEK.equals(combdorw.toString())) {
                tab.activeTab("tabweekpage");
            }
            Object repeatmode = this.getModel().getValue(REPEAT_MODE);
            String cron = (String)this.getModel().getValue("plan");
            String[] cronTemp = cron.split(" ");
            if (cronTemp.length > 2 && (hourTemp = cronTemp[2]).contains("/") && !HOUR.equals(repeatmode)) {
                this.getModel().beginInit();
                this.getModel().setValue(REPEAT_MODE, (Object)DEFINE);
                this.getModel().endInit();
                this.getView().updateView(REPEAT_MODE);
            }
            if (DEFINE.equals(repeatmode.toString())) {
                this.getPageCache().remove(LOAD_DATA);
                this.getModel().setValue(TXTDESC, (Object)this.genDefDesc(repeatmode.toString()));
                this.getView().setVisible(Boolean.TRUE, new String[]{BTNEXECUTE});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_DETECT_TASK});
                return;
            }
            this.getPageCache().remove(LOAD_DATA);
            this.adjustByCron();
            String cronFromDB = (String)this.getModel().getValue("plan");
            String txtDesc = this.genDesc(false, 10);
            this.getModel().beginInit();
            this.getModel().setValue(TXTDESC, (Object)txtDesc);
            this.getModel().endInit();
            this.getView().updateView(TXTDESC);
            String cronFromConfiguration = (String)this.getModel().getValue("plan");
            if (!StringUtils.equals((CharSequence)cronFromDB, (CharSequence)cronFromConfiguration)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u4e0e\u8ba1\u5212\u65f6\u95f4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fdd\u5b58\u66f4\u65b0\u6570\u636e\u3002", (String)"SavePlugin_123", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{BTNEXECUTE});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_DETECT_TASK});
        }
        if (StringUtils.equals((CharSequence)(fromBiz = (String)this.getView().getFormShowParameter().getCustomParam(FROM_BIZ)), (CharSequence)"true")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTNEXECUTE, BTN_DETECT_TASK});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate oper = (AbstractOperate)args.getSource();
            if (oper.getOperateKey().equals("btnsave2")) {
                DynamicObjectCollection msgNotifyEntity;
                String desc;
                Object descObj;
                Object number;
                QFilter q1;
                QFilter[] filters;
                boolean exists;
                String scheduleStatus;
                String fromBiz = (String)this.getView().getFormShowParameter().getCustomParam(FROM_BIZ);
                boolean isfromBiz = "true".equals(fromBiz);
                if (!isfromBiz && StringUtils.equals((CharSequence)(scheduleStatus = (String)this.getModel().getValue("status")), (CharSequence)STATUS_ENABLE)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u8ba1\u5212\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u7981\u7528\u540e\u518d\u4fee\u6539\u3002", (String)"SavePlugin_132", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.cancel = true;
                    return;
                }
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (this.checkData(isfromBiz)) {
                    if (isfromBiz && status == OperationStatus.ADDNEW) {
                        DynamicObject jobInfo = this.saveJobInfo();
                        String planId = this.savePlanInfo(jobInfo);
                        this.getModel().setValue("job", jobInfo.getPkValue());
                        this.getModel().setValue("schplanid", (Object)planId);
                        if (this.getModel().getEntryRowCount(ENTRYENTITY) == 1 && StringUtils.isBlank((Object)((DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(0)).get(JOBNUMBER))) {
                            this.getModel().setValue(JOBNUMBER, jobInfo.getPkValue(), 0);
                        }
                        DynamicObject schInfo = this.getModel().getDataEntity();
                        schInfo.set("id", (Object)Uuid16.create().toString());
                        this.getModel().updateCache();
                    } else if (isfromBiz && status == OperationStatus.EDIT) {
                        this.updatePlanInfo();
                    }
                } else {
                    args.cancel = true;
                    return;
                }
                Object id = this.getModel().getValue("id");
                if (StringUtils.isBlank((Object)id) && (exists = QueryServiceHelper.exists((String)"sch_schedule", (QFilter[])(filters = new QFilter[]{q1 = new QFilter(NUMBER, "=", number = this.getModel().getValue(NUMBER))})))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\"\u7f16\u7801\"\u5df2\u7ecf\u5b58\u5728\u3002", (String)"SavePlugin_107", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    args.cancel = true;
                    return;
                }
                if (this.getModel().getEntryEntity(ENTRYENTITY).size() > 0) {
                    String number2;
                    DynamicObject jobnumber = (DynamicObject)((DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(0)).get(JOBNUMBER);
                    if (jobnumber == null) {
                        DynamicObject jobDynamicObject = (DynamicObject)this.getModel().getValue("job");
                        number2 = String.valueOf(jobDynamicObject.get(NUMBER));
                    } else {
                        number2 = String.valueOf(((DynamicObject)((DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(0)).get(JOBNUMBER)).get(NUMBER));
                    }
                    QFilter numberQ = new QFilter(NUMBER, "=", (Object)number2);
                    Map jobTemp = BusinessDataServiceHelper.loadFromCache((String)"sch_job", (QFilter[])new QFilter[]{numberQ});
                    DynamicObject dynamicObjectTemp = new DynamicObject();
                    Iterator iterator = jobTemp.values().iterator();
                    while (iterator.hasNext()) {
                        DynamicObject dynamicObject;
                        dynamicObjectTemp = dynamicObject = (DynamicObject)iterator.next();
                    }
                    DynamicObject billObj = this.getModel().getDataEntity();
                    MainEntityType mainType = this.getModel().getDataEntityType();
                    BasedataProp basedataProp = (BasedataProp)mainType.findProperty("job");
                    basedataProp.setValue((Object)billObj, (Object)dynamicObjectTemp);
                    basedataProp.getRefIdProp().setValue((Object)billObj, dynamicObjectTemp.getPkValue());
                }
                if (!"0".equals(this.getModel().getValue("status"))) {
                    this.getModel().setValue("status", (Object)1);
                }
                if ((descObj = this.getModel().getValue(TXTDESC)) != null && (desc = (String)descObj).length() > 300) {
                    desc = desc.substring(0, 300);
                    this.getModel().setValue(TXTDESC, (Object)desc);
                }
                if (CollectionUtils.isEmpty((Collection)(msgNotifyEntity = this.getModel().getEntryEntity(MSG_NOTIFY_ENTITY)))) {
                    this.getModel().setValue("sfailnotify", (Object)false);
                    this.getModel().setValue("ssuccessnotify", (Object)false);
                    this.getModel().setValue("stimeout", (Object)false);
                    this.getModel().setValue("saborted", (Object)false);
                    this.getModel().setValue("snotifytype", (Object)"");
                    this.getModel().setValue("smsgcontent", (Object)"");
                    this.getModel().setValue("msgreceiver", null);
                }
            } else if (oper.getOperateKey().equals("deleteentryjob")) {
                this.getModel().setValue("job", null);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            this.getModel().setValue("txthost", (Object)ArchiveSchEditPlugin.getHostIpAddress());
            this.getModel().setValue(STARTTIME, (Object)new Date());
            String fromBiz = (String)this.getView().getFormShowParameter().getCustomParam(FROM_BIZ);
            if (fromBiz != null && fromBiz.equals("true")) {
                String parmasStr;
                String scheduleName = (String)this.getView().getFormShowParameter().getCustomParam("schedulename");
                scheduleName = StringUtils.isNotBlank((CharSequence)scheduleName) ? scheduleName : ResManager.loadKDString((String)"\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u8ba1\u5212", (String)"SavePlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                String number = (String)this.getView().getFormShowParameter().getCustomParam("tasknumber");
                number = StringUtils.isNotBlank((CharSequence)number) ? number : "SP" + new SecureRandom().nextDouble() * 10000.0;
                this.getModel().setValue(NAME, (Object)scheduleName);
                this.getModel().setValue(NUMBER, (Object)number);
                String className = (String)this.getView().getFormShowParameter().getCustomParam(TASKCLASSNAME);
                Object taskInstance = TypesContainer.createInstance((String)className);
                if (!(taskInstance instanceof Task)) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7c7b\u540d%s\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3kd.bos.schedule.api.Task\u3002", (String)"SavePlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), className));
                }
                if ((parmasStr = (String)this.getView().getFormShowParameter().getCustomParam("paramjsonstr")) != null) {
                    try {
                        JSON.parseObject((String)parmasStr, Map.class);
                    }
                    catch (Throwable t) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u4f5c\u4e1a\u53c2\u6570\u9519\u8bef\u3002", (String)"SavePlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        log.error("Schedule***save schedule error", t);
                    }
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"job"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnconfirm"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap10"});
            } else {
                String appId = (String)this.getView().getFormShowParameter().getCustomParam("appId");
                if (StringUtils.isNotBlank((CharSequence)appId)) {
                    this.getModel().setItemValueByNumber("app", appId, 0);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess() && afterDoOperationEventArgs.getObjectId().equals("btnsave2")) {
            String repeatMode;
            DynamicObject dynObject = this.getView().getModel().getDataEntity();
            String fromBiz = (String)this.getView().getFormShowParameter().getCustomParam(FROM_BIZ);
            if ("true".equals(fromBiz)) {
                this.getView().returnDataToParent((Object)dynObject);
                this.getView().close();
            }
            if (dynObject.getPkValue() != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTNEXECUTE});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_DETECT_TASK});
            }
            if (DEFINE.equals(repeatMode = (String)this.getModel().getValue(REPEAT_MODE))) {
                this.setModelValue(TXTDESC, this.genDefDesc(repeatMode));
            } else {
                this.setModelValue(TXTDESC, this.genDesc(false, 10));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if ((name.startsWith("comnoby") || name.startsWith("comweekby")) && this.getPageCache().get(LOAD_DATA) == null) {
            String no;
            String week;
            if (name.startsWith("comweekby")) {
                week = this.getComnoOrWeekValue(name);
                no = this.getComnoOrWeekValue(COMNO);
                if (StringUtils.equals((CharSequence)no, (CharSequence)"L") && StringUtils.equals((CharSequence)week, (CharSequence)"8")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u540e\u4e00\u4e2a\u81ea\u7136\u65e5\u3002", (String)"SavePlugin_131", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    this.setModelValue(name, "");
                    return;
                }
            }
            if (name.startsWith("comnoby")) {
                week = this.getComnoOrWeekValue(COM_WEEK);
                no = this.getComnoOrWeekValue(name);
                if (StringUtils.equals((CharSequence)no, (CharSequence)"L") && StringUtils.equals((CharSequence)week, (CharSequence)"8")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u540e\u4e00\u4e2a\u81ea\u7136\u65e5\u3002", (String)"SavePlugin_131", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    this.setModelValue(name, "");
                    return;
                }
            }
            this.getModel().beginInit();
            this.getModel().setValue(COMNO, this.getModel().getValue(name.replace(COM_WEEK, COMNO)));
            this.getModel().setValue(COM_WEEK, this.getModel().getValue(name.replace(COMNO, COM_WEEK)));
            this.getModel().endInit();
            Object commo = this.getModel().getValue(COMNO);
            Object comweek = this.getModel().getValue(COM_WEEK);
            if (name.endsWith("bymonth")) {
                if (commo != null && comweek != null && StringUtils.isNotBlank((CharSequence)commo.toString()) && StringUtils.isNotBlank((CharSequence)comweek.toString())) {
                    this.setModelValue(CKBY_WEEK, Boolean.TRUE);
                } else {
                    this.setModelValue(CKBY_WEEK, Boolean.FALSE);
                }
            }
        }
        if (name.equals("plan")) {
            String repeatmode = (String)this.getView().getModel().getValue(REPEAT_MODE);
            if (DEFINE.equalsIgnoreCase(repeatmode)) {
                this.setModelValue(TXTDESC, this.genDefDesc(name));
            } else {
                this.setModelValue(TXTDESC, this.genDefDesc(DEFINE));
            }
            return;
        }
        if (property.getName().equals(TXTDESC)) {
            return;
        }
        String repeatMode = "";
        if (name.equals(REPEAT_MODE)) {
            this.adjustByRepeatMode();
            repeatMode = (String)this.getModel().getValue(name);
        } else if (name.equals(COMBDORW)) {
            this.adjustByDayOrWeek();
        }
        boolean isMonth = false;
        for (String propMonth : CKMONTH) {
            if (!name.equals(propMonth)) continue;
            isMonth = true;
            break;
        }
        if (isMonth) {
            boolean changeMonth = false;
            for (String month : CKMONTH) {
                boolean b = Boolean.parseBoolean(this.getModel().getValue(month).toString());
                if (!b) continue;
                changeMonth = true;
                break;
            }
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{COMNOBY_MONTH});
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{COM_WEEKBY_MONTH});
        }
        if (repeatMode.equals(DEFINE)) {
            this.setModelValue(TXTDESC, this.genDefDesc(repeatMode));
        } else {
            this.setModelValue(TXTDESC, this.genDesc(true, 10));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        String fromBiz = (String)this.getView().getFormShowParameter().getCustomParam(FROM_BIZ);
        if (fromBiz != null && fromBiz.equals("true")) {
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("isNeedRefresh", "false");
        this.getView().returnDataToParent(returnData);
    }

    private void updatePlanInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String name = dataEntity.get(NAME).toString();
        Date startTime = (Date)dataEntity.get(STARTTIME);
        Date endtime = (Date)dataEntity.get(ENDTIME);
        Date modifytime = new Date();
        String plan = (String)dataEntity.get("plan");
        String repeatmode = (String)dataEntity.get(REPEAT_MODE);
        Integer cyclenum = (Integer)dataEntity.get(CYCLE_NUM);
        String schId = (String)this.getView().getFormShowParameter().getCustomParam("schplanid");
        String eventNoRepetition = ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"ArchiveSchEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        String eventCustom = ResManager.loadKDString((String)"\u4e8b\u4ef6\u81ea\u5b9a\u4e49", (String)"ArchiveSchEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        String desc = StringUtils.isEmpty((CharSequence)plan) ? eventNoRepetition : eventCustom;
        String sql = "update t_sch_schedule set fstarttime=?, fendtime=?, fplan=?, fcyclenum=?, fmodifytime=?, fdesc=?, frepeatmode=? where fid =?";
        Object[] fields = new Object[]{startTime, endtime, plan, cyclenum, modifytime, desc, repeatmode, schId};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])fields);
        String lansql = "update t_sch_schedule_l set fname=? where fid =?";
        Object[] lanfields = new Object[]{name, schId};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)lansql, (Object[])lanfields);
    }

    private String savePlanInfo(DynamicObject jobInfo) {
        String jobNumber = (String)jobInfo.get(NUMBER);
        String jobId = (String)jobInfo.get("id");
        PlanInfo planInfo = new PlanInfo();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        planInfo.setName(ResManager.loadKDString((String)"\u5f52\u6863\u8c03\u5ea6\u521b\u5efa\u8ba1\u5212", (String)"ArchiveScheduleUtils_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        planInfo.setNumber(jobNumber);
        planInfo.setJobId(jobId);
        planInfo.setEnable(true);
        planInfo.setRepeatMode(ArchiveSchEditPlugin.getRepeatMode((String)this.getModel().getValue(REPEAT_MODE)));
        planInfo.setPeriod(((Integer)dataEntity.get(CYCLE_NUM)).intValue());
        Calendar starttime = Calendar.getInstance();
        starttime.setTime((Date)dataEntity.get(STARTTIME));
        Calendar endtime = Calendar.getInstance();
        endtime.setTime((Date)dataEntity.get(ENDTIME));
        planInfo.setStartTime(starttime);
        planInfo.setEndTime(endtime);
        planInfo.setCronExpression((String)dataEntity.get("plan"));
        String[] fields = ((String)dataEntity.get("plan")).split("\\s+");
        if (fields.length == 6) {
            String dayExp = fields[3];
            String monthExp = fields[4];
            String weekExp = fields[5];
            if (StringUtils.isNotEmpty((CharSequence)dayExp) && !"?".equals(dayExp)) {
                planInfo.setDaysExp(dayExp);
            }
            if (StringUtils.isNotEmpty((CharSequence)monthExp) && !"?".equals(monthExp)) {
                planInfo.setMonthsExp(monthExp);
            }
            if (StringUtils.isNotEmpty((CharSequence)weekExp) && !"?".equals(weekExp)) {
                planInfo.setWeekdaysExp(weekExp);
            }
        } else {
            logger.info("fields size: " + fields.length);
        }
        return ScheduleServiceHelper.createPlan((PlanInfo)planInfo);
    }

    private DynamicObject saveJobInfo() {
        ORM orm = ORM.create();
        MainEntityType dotJob = EntityMetadataCache.getDataEntityType((String)"sch_job");
        DynamicObject jobInfo = new DynamicObject((DynamicObjectType)dotJob);
        jobInfo.set("id", (Object)Uuid16.create().toString());
        String jobName = (String)this.getView().getFormShowParameter().getCustomParam("jobname");
        if (StringUtils.isBlank((CharSequence)jobName)) {
            jobName = (String)this.getView().getFormShowParameter().getCustomParam("taskname");
        }
        jobName = StringUtils.isNotBlank((CharSequence)jobName) ? jobName : ResManager.loadKDString((String)"\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u4f5c\u4e1a", (String)"SavePlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
        jobInfo.set(NAME, (Object)jobName);
        String number = (String)this.getView().getModel().getDataEntity().get(NUMBER);
        jobInfo.set(NUMBER, (Object)(StringUtils.isNotBlank((CharSequence)number) ? number : "JOB" + new SecureRandom().nextDouble() * 10000.0));
        jobInfo.set("jobtype", (Object)"BIZ");
        jobInfo.set("classname", this.getView().getFormShowParameter().getCustomParam(TASKCLASSNAME));
        jobInfo.set(TASKCLASSNAME, this.getView().getFormShowParameter().getCustomParam("taskdefineid"));
        String parmasStr = (String)this.getView().getFormShowParameter().getCustomParam("paramjsonstr");
        jobInfo.set("params", (Object)parmasStr);
        if (parmasStr != null) {
            try {
                DynamicObjectCollection entrys = jobInfo.getDynamicObjectCollection(ENTRYENTITY);
                Map paramMap = (Map)JSON.parseObject((String)parmasStr, Map.class);
                int seq = 0;
                for (Map.Entry param : paramMap.entrySet()) {
                    DynamicObject row = (DynamicObject)entrys.getDynamicObjectType().createInstance();
                    row.set("paramname", param.getKey());
                    row.set("paramvalue", (Object)param.getValue().toString());
                    row.set("seq", (Object)seq++);
                    entrys.add((Object)row);
                }
            }
            catch (Exception exp) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4f5c\u4e1a\u53c2\u6570\u9519\u8bef\u3002", (String)"SavePlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        Object user = this.getView().getFormShowParameter().getCustomParam("executor");
        String parmasUserId = null;
        if (user != null) {
            parmasUserId = String.valueOf(user);
        }
        if (StringUtils.isBlank(parmasUserId)) {
            parmasUserId = RequestContext.get().getUserId();
        }
        MainEntityType userType = EntityMetadataCache.getDataEntityType((String)"bos_user");
        DynamicObject userInfo = new DynamicObject((DynamicObjectType)userType);
        userInfo.set("id", (Object)parmasUserId);
        jobInfo.set("status", (Object)1);
        jobInfo.set("runbyuser", (Object)userInfo);
        orm.insert(jobInfo);
        return jobInfo;
    }

    public static RepeatModeEnum getRepeatMode(String repeatMode) {
        RepeatModeEnum repeatModeEnum;
        if (NOREPEAT.equalsIgnoreCase(repeatMode) || DEFINE.equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.NONE;
        } else if (MINUTE.equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByMinutes;
        } else if (HOUR.equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByHours;
        } else if (DAY.equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByDays;
        } else if (WEEK.equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByWeeks;
        } else if (MONTH.equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByMonths;
        } else if (YEAR.equalsIgnoreCase(repeatMode)) {
            repeatModeEnum = RepeatModeEnum.ByYears;
        } else {
            throw ExceptionUtil.wrap((String)ResManager.loadKDString((String)"RepeatModeEnum\u4e0d\u5b58\u5728\u8be5\u679a\u4e3e\u503c\uff1a%s", (String)"ArchiveScheduleUtils_1", (String)"bos-cbs-plugin", (Object[])new Object[]{repeatMode}));
        }
        return repeatModeEnum;
    }

    private String addNumberSuffix(String number, boolean isKingdee) {
        if (isKingdee) {
            if (!number.endsWith("_SKDP_S")) {
                number = number.endsWith(SKDP) ? number + "_S" : number + "_SKDP_S";
            }
        } else if (number.endsWith(SKDP)) {
            number = number + SKDP;
        }
        return number;
    }

    private String generateNumber(boolean isfromBiz) {
        String errMsg = "";
        try {
            boolean isKingdee = AppMetaServiceHelper.getDeveloperInfo() != null && AppMetaServiceHelper.getDeveloperInfo().equals("kingdee");
            DynamicObject obj = this.getView().getModel().getDataEntity();
            String number = obj.getString(NUMBER);
            if (isKingdee && !isfromBiz) {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("job");
                if (dynamicObject == null) {
                    if (!CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
                        dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(0);
                    } else {
                        return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8c03\u5ea6\u4f5c\u4e1a\u201d\u3002", (String)"SavePlugin_133", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
                    }
                }
                ORM orm = ORM.create();
                QFilter[] filters = new QFilter[1];
                String selectField = "id,appid";
                filters[0] = new QFilter("id", "=", dynamicObject.get("taskclassname.id"));
                DynamicObject taskDefine = orm.queryOne("sch_taskdefine", selectField, filters);
                String appId = null;
                if (taskDefine != null) {
                    appId = taskDefine.getString("appid");
                }
                if (StringUtils.isNotBlank(appId) && !number.startsWith(appId + "_")) {
                    number = appId + "_" + number;
                }
            }
            if ((number = this.addNumberSuffix(number, isKingdee)).length() > 50) {
                errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7\u51cf\u5c11%s\u5b57\u7b26\u3002", (String)"SavePlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), number.length() - 50);
                return errMsg;
            }
            obj.set(NUMBER, (Object)number);
        }
        catch (Exception e) {
            log.error("schedule_generatenumber_error:{}", (Object)e.getMessage());
        }
        return errMsg;
    }

    private boolean checkData(boolean isfromBiz) {
        String blankField = this.checkBlank(isfromBiz);
        if (StringUtils.isNotEmpty((CharSequence)blankField)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"SavePlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), blankField));
            return false;
        }
        String errMsg = this.generateNumber(isfromBiz);
        if (StringUtils.isNotBlank((CharSequence)errMsg) && !isfromBiz) {
            this.getView().showErrorNotification(errMsg);
            return false;
        }
        Date startTime = (Date)this.getView().getModel().getValue(STARTTIME);
        Date endTime = (Date)this.getView().getModel().getValue(ENDTIME);
        String repeatmode = (String)this.getView().getModel().getValue(REPEAT_MODE);
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"SavePlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        String plan = this.getModel().getValue("plan").toString();
        try {
            if (DEFINE.equalsIgnoreCase(repeatmode)) {
                return this.checkCron(plan, true);
            }
            if (!StringUtils.equals((CharSequence)NOREPEAT, (CharSequence)repeatmode) && StringUtils.isNotBlank((CharSequence)plan)) {
                parser.parse(plan);
            }
        }
        catch (Throwable t) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"SavePlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            log.error("Schedule***save schedule error", t);
            return false;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<String> jobnumberList = new ArrayList<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String jobNumber = dynamicObject.getString(JOBNUMBER);
                if (jobnumberList.contains(jobNumber)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u91cd\u590d\u3002", (String)"SavePlugin_102", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return false;
                }
                jobnumberList.add(jobNumber);
            }
        }
        return true;
    }

    private String checkBlank(boolean isfromBiz) {
        DynamicObject obj = this.getView().getModel().getDataEntity();
        BasedataEntityType dataEntityType = (BasedataEntityType)this.getModel().getDataEntityType();
        if (!isfromBiz) {
            if (StringUtils.isBlank((CharSequence)obj.getString(NUMBER))) {
                return this.appendBlankField(dataEntityType, NUMBER);
            }
            if (StringUtils.isBlank((CharSequence)obj.getString(NAME))) {
                return this.appendBlankField(dataEntityType, NAME);
            }
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
            if (StringUtils.isBlank((CharSequence)obj.getString("job"))) {
                if (dynamicObjects.size() == 0) {
                    return this.appendBlankField(dataEntityType, ENTRYENTITY);
                }
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Object jobnumber = dynamicObject.get(JOBNUMBER);
                    if (jobnumber != null) continue;
                    return this.appendBlankField(dataEntityType, JOBNUMBER);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(STARTTIME))) {
            return this.appendBlankField(dataEntityType, STARTTIME);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(ENDTIME))) {
            return this.appendBlankField(dataEntityType, ENDTIME);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(CYCLE_NUM)) || 0 == obj.getInt(CYCLE_NUM)) {
            return this.appendBlankField(dataEntityType, CYCLE_NUM);
        }
        return "";
    }

    private String appendBlankField(BasedataEntityType entityType, String fieldKey) {
        IDataEntityProperty property = entityType.findProperty(fieldKey);
        if (property != null) {
            return property.getDisplayName() != null ? property.getDisplayName().getLocaleValue() : fieldKey;
        }
        return fieldKey;
    }

    private Calendar getStartTime() {
        Date startTime = (Date)this.getView().getModel().getValue(STARTTIME);
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        } else {
            this.getView().getModel().setValue(STARTTIME, (Object)crStartTime.getTime());
        }
        return crStartTime;
    }

    private String genDefDesc(String repeatMode) {
        String cron = (String)this.getModel().getValue("plan");
        Calendar crStartTime = this.getStartTime();
        StringBuilder descBuilder = new StringBuilder();
        String startTime = new SimpleDateFormat(DATE_TIME_FORMAT).format(crStartTime.getTime());
        String beginStr = String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e%s\u8d77", (String)"SavePlugin_82", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), startTime, "");
        descBuilder.append(beginStr).append("\uff0c");
        if (StringUtils.isBlank((CharSequence)cron) && DEFINE.equals(repeatMode)) {
            return descBuilder.toString();
        }
        if ("plan".equals(repeatMode) && !this.checkCron(cron, false)) {
            return "";
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Date endTime = dynamicObject.getDate(ENDTIME);
        try {
            descBuilder.append(ScheduleServiceHelper.genPlanDesc((String)cron, (Date)crStartTime.getTime(), (Date)endTime, (int)10));
        }
        catch (KDException e) {
            this.getView().showErrorNotification(e.getErrorCode().getMessage());
        }
        return descBuilder.toString();
    }

    private boolean checkCron(String cron, boolean showTip) {
        try {
            long leadTime;
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)2);
            if (dates.size() > 1 && (leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime())) < 60000L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\"cron\u8868\u8fbe\u5f0f\"\u7684\u5468\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u53ea\u652f\u6301\u5206\u949f\u7ea7\u522b\u7684\u5468\u671f\u3002", (String)"SavePlugin_94", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        catch (Exception e) {
            if (showTip) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\"cron\u8868\u8fbe\u5f0f\"\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SavePlugin_93", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private String genDesc(boolean isCallByPropertyChanged, int genDescTimeNum) {
        Object cyclenumObj = this.getView().getModel().getValue(CYCLE_NUM);
        if (StringUtils.isBlank((Object)cyclenumObj) || Long.parseLong(cyclenumObj.toString()) == 0L) {
            return "";
        }
        CronStruct cron = new CronStruct();
        Calendar crStartTime = this.getStartTime();
        cron.setSeconds("0");
        cron.setMinutes(String.valueOf(crStartTime.get(12)));
        cron.setHours(String.valueOf(crStartTime.get(11)));
        cron.setDayOfMonth(String.valueOf(crStartTime.get(5)));
        cron.setMonth(String.valueOf(crStartTime.get(2) + 1));
        cron.setDayOfWeek("?");
        cron.setYear(String.valueOf(crStartTime.get(1)));
        String repeatMode = (String)this.getView().getModel().getValue(REPEAT_MODE);
        int cyclenum = (Integer)this.getView().getModel().getValue(CYCLE_NUM);
        String startTime = new SimpleDateFormat(DATE_TIME_FORMAT).format(crStartTime.getTime());
        String beginStr = String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e%s\u8d77", (String)"SavePlugin_82", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), startTime);
        cron.getDescBuf().append(beginStr).append("\uff0c");
        switch (repeatMode) {
            case "n": {
                cron.getDescBuf().setLength(0);
                crStartTime.set(13, 0);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e8e", (String)"SavePlugin_125", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(new SimpleDateFormat(DATE_TIME_FORMAT).format(crStartTime.getTime())).append(ResManager.loadKDString((String)"\u6267\u884c\u4e00\u6b21\u3002", (String)"SavePlugin_126", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "mi": {
                cron = this.repeatByHour(cron, repeatMode);
                if (cyclenum > 1) {
                    if (cyclenum > 59) {
                        cyclenum = 59;
                        this.setModelValue(CYCLE_NUM, 59);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5206\u949f\uff0c\u6700\u591a\u53ea\u80fd\u6bcf59\u5206\u949f\u91cd\u590d\u3002", (String)"SavePlugin_134", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMinutes("0/" + cyclenum);
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SavePlugin_135", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMinutes("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d\u3002", (String)"SavePlugin_14", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "h": {
                if (cyclenum > 1) {
                    if (cyclenum > 23) {
                        cyclenum = 23;
                        this.getModel().setValue(CYCLE_NUM, (Object)23);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5c0f\u65f6\uff0c\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u65f6\u91cd\u590d\u3002", (String)"SavePlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setHours("0/" + cyclenum);
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SavePlugin_135", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setHours("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d\u3002", (String)"SavePlugin_15", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "d": {
                if (cyclenum > 1) {
                    if (cyclenum > 31) {
                        cyclenum = 31;
                        this.getModel().setValue(CYCLE_NUM, (Object)31);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5929\uff0c\u6700\u591a\u53ea\u80fd\u6bcf31\u5929\u91cd\u590d\u3002", (String)"SavePlugin_99", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setDayOfMonth("*/" + cyclenum);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf\u67081\u65e5\u5f00\u59cb", (String)"SavePlugin_88", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SavePlugin_135", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setDayOfMonth("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5929", (String)"SavePlugin_115", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                cron = this.repeatByHour(cron, repeatMode);
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "w": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5468", (String)"SavePlugin_18", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setYear(null);
                cron = this.repeatByWeek(cron);
                cron = this.repeatByHour(cron, repeatMode);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "m": {
                if (cyclenum > 1) {
                    if (cyclenum > 12) {
                        cyclenum = 12;
                        this.getModel().setValue(CYCLE_NUM, (Object)12);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u6708\uff0c\u6700\u591a\u53ea\u80fd\u6bcf12\u6708\u91cd\u590d\u3002", (String)"SavePlugin_100", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMonth("*/" + cyclenum);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u4ece\u6bcf\u5e741\u6708\u5f00\u59cb", (String)"SavePlugin_91", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SavePlugin_135", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMonth("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u6708", (String)"SavePlugin_20", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                cron.setYear(null);
                cron = this.repeatByMonthDay(cron);
                cron = this.repeatByHour(cron, repeatMode);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "y": {
                if (cyclenum > 1 || cyclenum < 0) {
                    cyclenum = 1;
                    this.setModelValue(CYCLE_NUM, 1);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u5468\u671f\u4e3a\u6bcf\u5e74", (String)"SavePlugin_87", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5e74", (String)"SavePlugin_21", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                cron.setYear(null);
                cron = this.repeatByMonthly(cron, isCallByPropertyChanged);
                cron = this.repeatByMonthDay(cron);
                cron = this.repeatByHour(cron, repeatMode);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        String cronStr = "";
        if (DEFINE.equals(repeatMode)) {
            cronStr = (String)this.getModel().getValue("plan");
            this.checkCron(cronStr, true);
        } else {
            cronStr = cron.toString();
            try {
                parser.parse(cronStr);
            }
            catch (Throwable t) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"SavePlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                log.error("Schedule***save schedule error", t);
            }
        }
        if (isCallByPropertyChanged) {
            this.setModelValue("plan", cronStr);
        }
        if (!NOREPEAT.equals(repeatMode)) {
            if (!isCallByPropertyChanged) {
                cronStr = String.valueOf(this.getModel().getValue("plan"));
            }
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            Date endTime = dynamicObject.getDate(ENDTIME);
            try {
                cron.getDescBuf().append(ScheduleServiceHelper.genPlanDesc((String)cronStr, (Date)crStartTime.getTime(), (Date)endTime, (int)genDescTimeNum));
            }
            catch (KDException e) {
                this.getView().showErrorNotification(e.getErrorCode().getMessage());
            }
        }
        return cron.getDescBuf().toString();
    }

    private String getNextExeTime(String cronExp, Date date) {
        String nextExeTime = "";
        try {
            ZonedDateTime zonedDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronExp));
            Optional opt = executionTime.nextExecution(zonedDate);
            if (opt.isPresent()) {
                nextExeTime = ((ZonedDateTime)opt.get()).format(DateTimeFormatter.ofPattern(DATE_TIME_FORMAT));
            }
        }
        catch (Throwable t) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"SavePlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            log.error("Schedule***save schedule error", t);
        }
        return nextExeTime;
    }

    private CronStruct repeatByHour(CronStruct cron, String repeatMode) {
        String hourCron;
        String[] crons;
        String plan;
        IDataModel dataModel = this.getView().getModel();
        StringBuilder cronExp = new StringBuilder();
        StringBuilder cronDesc = new StringBuilder();
        Stream.iterate(0, x -> {
            x = x + 1;
            return x;
        }).limit(24L).forEachOrdered(h -> {
            String hour = h < 10 ? CKHOUR_0 + h : CKHOUR + h;
            boolean checked = (Boolean)dataModel.getValue(hour);
            if (checked) {
                cronExp.append(h).append(',');
                cronDesc.append(h).append(ResManager.loadKDString((String)"\u65f6", (String)"SavePlugin_92", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(",");
            }
        });
        if (this.getPageCache().get(LOAD_DATA) != null && StringUtils.isNotBlank((CharSequence)(plan = (String)this.getModel().getValue("plan"))) && (crons = plan.trim().split(" +")).length >= 6 && StringUtils.isNotEmpty((CharSequence)(hourCron = crons[2])) && !HOUR.equalsIgnoreCase(repeatMode) && !"*".equals(hourCron)) {
            String[] hours = hourCron.split(",");
            Arrays.stream(hours).forEach(x -> {
                this.getModel().beginInit();
                String hour = Integer.parseInt(x) < 10 ? CKHOUR_0 + x : CKHOUR + x;
                this.getModel().setValue(hour, (Object)STATUS_ENABLE);
                this.getModel().endInit();
                this.getView().updateView(hour);
            });
        }
        String cronExpStr = cronExp.toString();
        String cronDescStr = cronDesc.toString();
        if (cronExpStr.length() > 0) {
            cronExpStr = cronExpStr.substring(0, cronExpStr.length() - 1);
        } else {
            String string = cronExpStr = MINUTE.equals(repeatMode) ? "*" : cron.getHours();
        }
        if (cronDescStr.length() > 0) {
            cron.getDescBuf().append(cronDescStr.substring(0, cronDescStr.length() - 1));
        } else if (!StringUtils.equals((CharSequence)"*", (CharSequence)cronExpStr)) {
            cron = this.repeatByStartTimeHours(cron, cronExpStr);
        }
        cron.setHours(cronExpStr);
        return cron;
    }

    private CronStruct repeatByStartTimeHours(CronStruct cron, String hoursStr) {
        String[] hours = hoursStr.split(",");
        cron.getDescBuf().append(hours[0]).append(ResManager.loadKDString((String)"\u65f6", (String)"SavePlugin_92", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        return cron;
    }

    private CronStruct repeatByWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
        String weekDays = "";
        if (((Boolean)dataModel.getValue("cksun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"SavePlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = "1,";
        }
        if (((Boolean)dataModel.getValue("ckmon")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"SavePlugin_24", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "2,";
        }
        if (((Boolean)dataModel.getValue("cktues")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"SavePlugin_25", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "3,";
        }
        if (((Boolean)dataModel.getValue("ckwed")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"SavePlugin_26", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "4,";
        }
        if (((Boolean)dataModel.getValue("ckthur")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"SavePlugin_27", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "5,";
        }
        if (((Boolean)dataModel.getValue("ckfri")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"SavePlugin_28", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "6,";
        }
        if (((Boolean)dataModel.getValue("cksat")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"SavePlugin_29", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            weekDays = weekDays + "7,";
        }
        if (weekDays.length() == 0) {
            weekDays = StringUtils.isEmpty((CharSequence)cron.getDayOfWeek()) ? String.valueOf(this.getStartTime().get(7)) : cron.getDayOfWeek();
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u6bcf\u4e00\u5929", (String)"SavePlugin_124", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            weekDays = weekDays.substring(0, weekDays.length() - 1);
        }
        if (!"?".equals(weekDays)) {
            cron.setDayOfMonth("?");
        }
        cron.setDayOfWeek(weekDays);
        return cron;
    }

    private CronStruct repeatByMonthDay(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String byDayOrWeek = (String)dataModel.getValue(COMBDORW);
        if (WEEK.equals(byDayOrWeek)) {
            cron = this.repeatByNoWeek(cron);
        } else {
            String conStr = ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
            String days = "";
            if (((Boolean)dataModel.getValue("cklastday")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"SavePlugin_81", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                days = "L,";
            } else {
                if (((Boolean)dataModel.getValue("ckone")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"1\u65e5", (String)"SavePlugin_30", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "1,";
                }
                if (((Boolean)dataModel.getValue("cktwo")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"2\u65e5", (String)"SavePlugin_31", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "2,";
                }
                if (((Boolean)dataModel.getValue("ckthree")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"3\u65e5", (String)"SavePlugin_32", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "3,";
                }
                if (((Boolean)dataModel.getValue("ckfour")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"4\u65e5", (String)"SavePlugin_33", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "4,";
                }
                if (((Boolean)dataModel.getValue("ckfive")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"5\u65e5", (String)"SavePlugin_34", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "5,";
                }
                if (((Boolean)dataModel.getValue("cksix")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"6\u65e5", (String)"SavePlugin_35", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "6,";
                }
                if (((Boolean)dataModel.getValue("ckseven")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"7\u65e5", (String)"SavePlugin_36", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "7,";
                }
                if (((Boolean)dataModel.getValue("ckeight")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"8\u65e5", (String)"SavePlugin_37", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "8,";
                }
                if (((Boolean)dataModel.getValue("cknine")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"9\u65e5", (String)"SavePlugin_38", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "9,";
                }
                if (((Boolean)dataModel.getValue("ckten")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"10\u65e5", (String)"SavePlugin_39", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "10,";
                }
                if (((Boolean)dataModel.getValue("ckeleven")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"11\u65e5", (String)"SavePlugin_40", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "11,";
                }
                if (((Boolean)dataModel.getValue("cktwelve")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"12\u65e5", (String)"SavePlugin_41", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "12,";
                }
                if (((Boolean)dataModel.getValue("ckthirteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"13\u65e5", (String)"SavePlugin_42", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "13,";
                }
                if (((Boolean)dataModel.getValue("ckfourteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"14\u65e5", (String)"SavePlugin_43", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "14,";
                }
                if (((Boolean)dataModel.getValue("ckfifteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"15\u65e5", (String)"SavePlugin_44", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "15,";
                }
                if (((Boolean)dataModel.getValue("cksixteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"16\u65e5", (String)"SavePlugin_45", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "16,";
                }
                if (((Boolean)dataModel.getValue("ckseventeen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"17\u65e5", (String)"SavePlugin_46", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "17,";
                }
                if (((Boolean)dataModel.getValue("ckeighteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"18\u65e5", (String)"SavePlugin_47", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "18,";
                }
                if (((Boolean)dataModel.getValue("cknineteen")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"19\u65e5", (String)"SavePlugin_48", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "19,";
                }
                if (((Boolean)dataModel.getValue("cktwenty")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"20\u65e5", (String)"SavePlugin_49", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "20,";
                }
                if (((Boolean)dataModel.getValue("cktwentyone")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"21\u65e5", (String)"SavePlugin_50", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "21,";
                }
                if (((Boolean)dataModel.getValue("cktwentytwo")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"22\u65e5", (String)"SavePlugin_51", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "22,";
                }
                if (((Boolean)dataModel.getValue("cktwentythree")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"23\u65e5", (String)"SavePlugin_52", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "23,";
                }
                if (((Boolean)dataModel.getValue("cktwentyfour")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"24\u65e5", (String)"SavePlugin_53", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "24,";
                }
                if (((Boolean)dataModel.getValue("cktwentyfive")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"25\u65e5", (String)"SavePlugin_54", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "25,";
                }
                if (((Boolean)dataModel.getValue("cktwentysix")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"26\u65e5", (String)"SavePlugin_55", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "26,";
                }
                if (((Boolean)dataModel.getValue("cktwentyseven")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"27\u65e5", (String)"SavePlugin_56", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "27,";
                }
                if (((Boolean)dataModel.getValue("cktwentyeight")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"28\u65e5", (String)"SavePlugin_57", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "28,";
                }
                if (((Boolean)dataModel.getValue("cktwentynine")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"29\u65e5", (String)"SavePlugin_58", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "29,";
                }
                if (((Boolean)dataModel.getValue("ckthirty")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"30\u65e5", (String)"SavePlugin_59", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "30,";
                }
                if (((Boolean)dataModel.getValue("ckthirtyone")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"31\u65e5", (String)"SavePlugin_60", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    conStr = ",";
                    days = days + "31,";
                }
            }
            if (days.length() == 0) {
                days = StringUtils.isEmpty((CharSequence)cron.getDayOfMonth()) ? String.valueOf(this.getStartTime().get(5)) : cron.getDayOfMonth();
                cron = this.repeatByStartTimeDayOfMonth(cron, days);
            } else {
                days = days.substring(0, days.length() - 1);
            }
            cron.setDayOfMonth(days);
            if (!"?".equals(days)) {
                cron.setDayOfWeek("?");
            }
        }
        return cron;
    }

    private CronStruct repeatByNoWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String no = (String)dataModel.getValue(COMNO);
        String noWeek = (String)dataModel.getValue(COM_WEEK);
        if (StringUtils.isNotBlank((CharSequence)no) && StringUtils.isNotBlank((CharSequence)noWeek)) {
            switch (no) {
                case "1": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"SavePlugin_61", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"SavePlugin_62", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"SavePlugin_63", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "4": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"SavePlugin_64", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "5": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"SavePlugin_65", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "L": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"SavePlugin_66", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            switch (noWeek) {
                case "1": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"SavePlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"SavePlugin_24", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"SavePlugin_25", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "4": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"SavePlugin_26", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "5": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"SavePlugin_27", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "6": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"SavePlugin_28", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "7": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"SavePlugin_29", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "8": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"SavePlugin_67", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "9": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"SavePlugin_68", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            if (noWeek.compareTo(STATUS_ENABLE) >= 0 && noWeek.compareTo("8") < 0) {
                if (no.compareTo(STATUS_ENABLE) >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfWeek(noWeek + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek(noWeek + "L");
                }
                cron.setDayOfMonth("?");
            } else if (noWeek.equals("8")) {
                if (no.compareTo(STATUS_ENABLE) >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfMonth(no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfMonth("1L");
                }
                cron.setDayOfWeek("?");
            } else if (noWeek.equals("9")) {
                if (no.compareTo(STATUS_ENABLE) >= 0 && no.compareTo("5") <= 0) {
                    String workday = String.valueOf(Integer.parseInt(no) + 1);
                    cron.setDayOfWeek(workday + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek("6L");
                }
                cron.setDayOfMonth("?");
            }
        } else {
            String days = "";
            days = StringUtils.isEmpty((CharSequence)cron.getDayOfMonth()) ? String.valueOf(this.getStartTime().get(5)) : cron.getDayOfMonth();
            cron = this.repeatByStartTimeDayOfMonth(cron, days);
        }
        return cron;
    }

    private CronStruct repeatByMonthly(CronStruct cron, boolean isCallByProperyChanged) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]);
        String months = "";
        if (((Boolean)dataModel.getValue("ckjan")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e00\u6708", (String)"SavePlugin_69", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "1,";
        }
        if (((Boolean)dataModel.getValue("ckfeb")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e8c\u6708", (String)"SavePlugin_70", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "2,";
        }
        if (((Boolean)dataModel.getValue("ckmar")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e09\u6708", (String)"SavePlugin_71", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "3,";
        }
        if (((Boolean)dataModel.getValue("ckapr")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u56db\u6708", (String)"SavePlugin_72", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "4,";
        }
        if (((Boolean)dataModel.getValue("ckmay")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e94\u6708", (String)"SavePlugin_73", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "5,";
        }
        if (((Boolean)dataModel.getValue("ckjun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516d\u6708", (String)"SavePlugin_74", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "6,";
        }
        if (((Boolean)dataModel.getValue("ckjul")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e03\u6708", (String)"SavePlugin_75", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "7,";
        }
        if (((Boolean)dataModel.getValue("ckaug")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516b\u6708", (String)"SavePlugin_76", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "8,";
        }
        if (((Boolean)dataModel.getValue("cksep")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e5d\u6708", (String)"SavePlugin_77", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "9,";
        }
        if (((Boolean)dataModel.getValue("ckoct")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u6708", (String)"SavePlugin_78", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "10,";
        }
        if (((Boolean)dataModel.getValue("cknov")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e00\u6708", (String)"SavePlugin_79", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "11,";
        }
        if (((Boolean)dataModel.getValue("ckdec")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e8c\u6708", (String)"SavePlugin_80", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "12,";
        }
        if (months.length() == 0) {
            months = StringUtils.isEmpty((CharSequence)cron.getMonth()) ? String.valueOf(this.getStartTime().get(2) + 1) : cron.getMonth();
            cron = this.repeatByStartTimeMonth(cron, months);
        } else {
            months = months.substring(0, months.length() - 1);
        }
        cron.setMonth(months);
        if (((Boolean)dataModel.getValue(CKBY_WEEK)).booleanValue()) {
            cron = this.repeatByNoWeek(cron);
        } else if (isCallByProperyChanged) {
            String days = "";
            days = StringUtils.isEmpty((CharSequence)cron.getDayOfMonth()) ? String.valueOf(this.getStartTime().get(5)) : cron.getDayOfMonth();
            cron = this.repeatByStartTimeDayOfMonth(cron, days);
        }
        return cron;
    }

    private CronStruct repeatByStartTimeMonth(CronStruct cron, String monthsStr) {
        String[] months = monthsStr.split(",");
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(months[0]).append(ResManager.loadKDString((String)"\u6708", (String)"SavePlugin_20", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        return cron;
    }

    private CronStruct repeatByStartTimeDayOfMonth(CronStruct cron, String daysStr) {
        String[] days = daysStr.split(",");
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append(days[0]).append(ResManager.loadKDString((String)"\u65e5", (String)"SavePlugin_90", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        return cron;
    }

    private String getComnoOrWeekValue(String key) {
        String value = "";
        Object valueObj = this.getModel().getValue(key);
        if (valueObj != null) {
            value = String.valueOf(valueObj);
        }
        return value;
    }

    private void adjustByDayOrWeek() {
        String byDayOrWeek = (String)this.getModel().getValue(COMBDORW);
        DynamicObject planObj = this.getModel().getDataEntity();
        if (WEEK.equals(byDayOrWeek)) {
            for (String ckDay : CKDATE) {
                this.setModelValue(ckDay, "0");
            }
        } else {
            this.setModelValue("comnobyweek", "");
            this.setModelValue("comweekbyweek", "");
            planObj.set(COMNO, (Object)"");
            planObj.set(COM_WEEK, (Object)"");
        }
    }

    private void adjustByRepeatMode() {
        String repeatMode = (String)this.getModel().getValue(REPEAT_MODE);
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", FLEXPDAYS, FLEXPBY_WEEK, FLEXP_HOUR, CYCLE_NUM});
        formView.setVisible(Boolean.TRUE, new String[]{"plan"});
        formView.setEnable(Boolean.valueOf(false), new String[]{"plan"});
        FieldEdit txtCycleNum = (FieldEdit)formView.getControl(CYCLE_NUM);
        txtCycleNum.setEnable("", true, -1);
        if ("".equals(repeatMode)) {
            this.getModel().beginInit();
            this.getModel().setValue(REPEAT_MODE, (Object)DEFINE);
            this.getModel().endInit();
            this.getView().updateView(REPEAT_MODE);
        }
        Calendar startTime = this.getStartTime();
        DynamicObject planObj = this.getModel().getDataEntity();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        switch (repeatMode) {
            case "mi": {
                formView.setVisible(Boolean.TRUE, new String[]{FLEXP_HOUR, CYCLE_NUM});
                this.initHourValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(59);
                break;
            }
            case "h": {
                formView.setVisible(Boolean.FALSE, new String[]{FLEXP_HOUR});
                formView.setVisible(Boolean.TRUE, new String[]{CYCLE_NUM});
                this.updateCycleNumRangeByRepeatMode(23);
                break;
            }
            case "d": {
                formView.setVisible(Boolean.TRUE, new String[]{FLEXP_HOUR, CYCLE_NUM});
                this.initHourValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(31);
                break;
            }
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek", FLEXP_HOUR, CYCLE_NUM});
                this.getModel().setValue(CYCLE_NUM, (Object)1);
                txtCycleNum.setEnable("", false, -1);
                this.initHourValue(planObj, startTime, status);
                this.initWeekValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(3);
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday", FLEXPDAYS, FLEXP_HOUR, CYCLE_NUM});
                this.adjustByDayOrWeek();
                this.initHourValue(planObj, startTime, status);
                this.initDayValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(12);
                break;
            }
            case "y": {
                this.getModel().setValue(CYCLE_NUM, (Object)1);
                txtCycleNum.setEnable("", true, -1);
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths", FLEXP_HOUR, CYCLE_NUM, COMNOBY_MONTH, COM_WEEKBY_MONTH});
                this.initMonthValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(59);
                break;
            }
            case "n": {
                txtCycleNum.setEnable("", false, -1);
                formView.setVisible(Boolean.valueOf(false), new String[]{"plan"});
                break;
            }
            case "def": {
                if (this.callWithComboEdit) {
                    this.setModelValue("plan", "");
                }
                this.callWithComboEdit = true;
                formView.setVisible(Boolean.TRUE, new String[]{"plan"});
                formView.setEnable(Boolean.TRUE, new String[]{"plan"});
                txtCycleNum.setEnable("", false, -1);
                break;
            }
        }
    }

    private void updateCycleNumRangeByRepeatMode(int max) {
        HashMap<String, Integer> itemStyle = new HashMap<String, Integer>();
        itemStyle.put("max", max);
        itemStyle.put("min", 0);
        HashMap<String, HashMap<String, Integer>> cycleNumStyle = new HashMap<String, HashMap<String, Integer>>();
        cycleNumStyle.put("item", itemStyle);
        this.getView().updateControlMetadata(CYCLE_NUM, cycleNumStyle);
    }

    private void adjustByCron() {
        String[] crons;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String repeatMode = (String)this.getModel().getValue(REPEAT_MODE);
        String cron = (String)this.getModel().getValue("plan");
        if (status != OperationStatus.ADDNEW && StringUtils.isNotEmpty((CharSequence)cron) && (crons = cron.split(" ")).length >= 6) {
            String hourCron = crons[2];
            if (StringUtils.isNotEmpty((CharSequence)hourCron) && !HOUR.equalsIgnoreCase(repeatMode)) {
                List<String> hoursList = null;
                if (!StringUtils.equals((CharSequence)"*", (CharSequence)hourCron)) {
                    hoursList = Arrays.asList(hourCron.split(","));
                }
                for (int h = 0; h < 24; ++h) {
                    String hour = h < 10 ? CKHOUR_0 + h : CKHOUR + h;
                    this.getModel().beginInit();
                    if (hoursList != null && hoursList.contains(String.valueOf(h))) {
                        this.getModel().setValue(hour, (Object)STATUS_ENABLE);
                    } else {
                        this.getModel().setValue(hour, (Object)"0");
                    }
                    this.getModel().endInit();
                    this.getView().updateView(hour);
                }
            }
            this.adjustByCron(repeatMode, cron);
        }
    }

    private void adjustByCron(String repeatMode, String cron) {
        boolean parseResult = true;
        Map<CronFieldName, Object> cronFieldValues = Collections.emptyMap();
        try {
            cronFieldValues = this.parseCron(cron);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            parseResult = false;
        }
        if (parseResult) {
            switch (repeatMode) {
                case "m": {
                    this.adjustByMonthMode(cronFieldValues);
                    break;
                }
                case "w": {
                    this.adjustByWeekMode(cronFieldValues);
                    break;
                }
                case "y": {
                    this.adjustByYearMode(cronFieldValues);
                    break;
                }
            }
        } else {
            log.info("cron\u89e3\u6790\u5931\u8d25");
        }
    }

    private void adjustByWeekMode(Map<CronFieldName, Object> cronFieldValues) {
        for (Map.Entry<CronFieldName, Object> it : cronFieldValues.entrySet()) {
            if (it.getValue() == null || it.getKey() != CronFieldName.DAY_OF_WEEK) continue;
            Object[] filedValue = (Object[])it.getValue();
            List weeks = (List)filedValue[0];
            for (int week = 1; week <= 7; ++week) {
                if (weeks.contains(week)) {
                    this.setModelValue(CKWEEK[week - 1], 1);
                    continue;
                }
                this.setModelValue(CKWEEK[week - 1], 0);
            }
        }
    }

    private void adjustByYearMode(Map<CronFieldName, Object> cronFieldValues) {
        for (Map.Entry<CronFieldName, Object> it : cronFieldValues.entrySet()) {
            List days;
            if (it.getValue() == null) continue;
            if (it.getKey() == CronFieldName.DAY_OF_WEEK) {
                Object[] filedValue = (Object[])it.getValue();
                List weeks = (List)filedValue[0];
                for (Integer week : weeks) {
                    this.setModelValue(COM_WEEKBY_MONTH, week);
                    this.setModelValue(COM_WEEK, week);
                }
                if (!CollectionUtils.isEmpty((Collection)weeks) && filedValue[1] != null) {
                    this.setModelValue(CKBY_WEEK, Boolean.TRUE);
                }
                if (filedValue[1] == null) continue;
                int nth = (Integer)filedValue[1];
                if (nth == -1) {
                    this.setModelValue(COMNOBY_MONTH, "L");
                    this.setModelValue(COMNO, "L");
                    continue;
                }
                this.setModelValue(COMNOBY_MONTH, nth);
                this.setModelValue(COMNO, nth);
                continue;
            }
            if (it.getKey() == CronFieldName.MONTH) {
                List months = (List)it.getValue();
                if (!CollectionUtils.isEmpty((Collection)months)) {
                    this.setModelValue(CKBY_WEEK, Boolean.FALSE);
                }
                for (int month = 1; month <= 12; ++month) {
                    if (months.contains(month)) {
                        this.setModelValue(CKMONTH[month - 1], 1);
                        continue;
                    }
                    this.setModelValue(CKMONTH[month - 1], 0);
                }
                continue;
            }
            if (it.getKey() != CronFieldName.DAY_OF_MONTH || CollectionUtils.isEmpty((Collection)(days = (List)it.getValue()))) continue;
            for (int day = 1; day <= 31; ++day) {
                if (days.contains(day)) {
                    this.setModelValue(CKDATE[day - 1], 1);
                    continue;
                }
                this.setModelValue(CKDATE[day - 1], 0);
            }
        }
    }

    private void adjustByMonthMode(Map<CronFieldName, Object> cronFieldValues) {
        for (Map.Entry<CronFieldName, Object> it : cronFieldValues.entrySet()) {
            if (it.getValue() == null) continue;
            if (it.getKey() == CronFieldName.DAY_OF_MONTH) {
                List days = (List)it.getValue();
                if (!CollectionUtils.isEmpty((Collection)days) && days.size() == 1 && (Integer)days.get(0) == -1) {
                    this.setModelValue("cklastday", 1);
                    this.setModelValue(COMBDORW, DAY);
                    for (int day = 1; day <= 31; ++day) {
                        this.setModelValue(CKDATE[day - 1], 0);
                    }
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)days)) continue;
                this.setModelValue("cklastday", 0);
                this.setModelValue(COMBDORW, DAY);
                for (int day = 1; day <= 31; ++day) {
                    if (days.contains(day)) {
                        this.setModelValue(CKDATE[day - 1], 1);
                        continue;
                    }
                    this.setModelValue(CKDATE[day - 1], 0);
                }
                continue;
            }
            if (it.getKey() != CronFieldName.DAY_OF_WEEK) continue;
            Object[] filedValue = (Object[])it.getValue();
            List weeks = (List)filedValue[0];
            for (Integer week : weeks) {
                this.setModelValue("comweekbyweek", week);
                this.setModelValue(COM_WEEK, week);
            }
            if (!CollectionUtils.isEmpty((Collection)weeks) && filedValue[1] != null) {
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("tabweekpage");
            }
            if (filedValue[1] == null) continue;
            int nth = (Integer)filedValue[1];
            if (nth == -1) {
                this.setModelValue("comnobyweek", "L");
                this.setModelValue(COMNO, "L");
                continue;
            }
            this.setModelValue("comnobyweek", nth);
            this.setModelValue(COMNO, nth);
        }
    }

    private Map<CronFieldName, Object> parseCron(String cronexpress) {
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        Cron cron = cronParser.parse(cronexpress);
        log.info("cron\u53cd\u89e3\u6790 cronexpress={}", (Object)cronexpress);
        Map items = cron.retrieveFieldsAsMap();
        EnumMap<CronFieldName, Object> cronFieldValues = new EnumMap<CronFieldName, Object>(CronFieldName.class);
        for (Map.Entry it : items.entrySet()) {
            CronFieldName fieldName = (CronFieldName)it.getKey();
            CronField cronField = (CronField)it.getValue();
            if (fieldName == CronFieldName.MONTH) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(1, 12));
                continue;
            }
            if (fieldName == CronFieldName.MINUTE) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 59));
                continue;
            }
            if (fieldName == CronFieldName.HOUR) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 23));
                continue;
            }
            if (fieldName == CronFieldName.SECOND) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 59));
                continue;
            }
            if (fieldName == CronFieldName.DAY_OF_MONTH) {
                try {
                    cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 31));
                }
                catch (IllegalArgumentException e) {
                    if (!(cronField.getExpression() instanceof On) || ((On)cronField.getExpression()).getSpecialChar().getValue() != SpecialChar.L) continue;
                    ArrayList<Integer> lastday = new ArrayList<Integer>();
                    lastday.add(-1);
                    cronFieldValues.put(fieldName, (Object)lastday);
                }
                continue;
            }
            if (fieldName == CronFieldName.DAY_OF_WEEK) {
                Object[] value = new Object[2];
                try {
                    value[0] = FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(1, 7);
                    value[1] = null;
                    cronFieldValues.put(fieldName, (Object)value);
                    continue;
                }
                catch (Exception e) {
                    if (!(cronField.getExpression() instanceof On)) {
                        throw e;
                    }
                    On dayofweekExpression = (On)cronField.getExpression();
                    SpecialChar weekSpecialChar = dayofweekExpression.getSpecialChar().getValue();
                    value = new Object[2];
                    if (weekSpecialChar == SpecialChar.L) {
                        On withoutL = new On(dayofweekExpression.getTime(), new SpecialCharFieldValue(SpecialChar.NONE), dayofweekExpression.getNth());
                        value[1] = -1;
                        value[0] = FieldValueGeneratorFactory.forCronField((CronField)new CronField(cronField.getField(), (FieldExpression)withoutL, cronField.getConstraints())).generateCandidates(1, 7);
                        cronFieldValues.put(fieldName, (Object)value);
                        continue;
                    }
                    if (weekSpecialChar == SpecialChar.HASH) {
                        On withoutSeq = new On(((On)cronField.getExpression()).getTime(), new SpecialCharFieldValue(SpecialChar.NONE), dayofweekExpression.getNth());
                        value[1] = dayofweekExpression.getNth().getValue();
                        value[0] = FieldValueGeneratorFactory.forCronField((CronField)new CronField(cronField.getField(), (FieldExpression)withoutSeq, cronField.getConstraints())).generateCandidates(1, 7);
                        cronFieldValues.put(fieldName, (Object)value);
                        continue;
                    }
                    throw e;
                }
            }
            if (fieldName != CronFieldName.DAY_OF_YEAR && fieldName != CronFieldName.YEAR) continue;
        }
        return cronFieldValues;
    }

    public static String getHostIpAddress() {
        Enumeration<NetworkInterface> allNetInterfaces;
        try {
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error((Throwable)e);
            return "127.0.0.1";
        }
        boolean hasGet = false;
        String ipStr = null;
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (!(ip instanceof Inet4Address) || "127.0.0.1".equals(ipStr = ZkConfig.getHostIpAddress())) continue;
                hasGet = true;
                break;
            }
            if (!hasGet) continue;
            break;
        }
        return ipStr;
    }

    private void initHourValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int h = startTime.get(11);
            String currentHour = h < 10 ? CKHOUR_0 + h : CKHOUR + h;
            planObj.set(currentHour, (Object)STATUS_ENABLE);
            this.getView().updateView(currentHour);
        }
    }

    private void initDayValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int currentDay = startTime.get(5);
            planObj.set(CKDATE[currentDay - 1], (Object)STATUS_ENABLE);
            this.getView().updateView(CKDATE[currentDay - 1]);
        }
    }

    private void initMonthValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int currentMonth = startTime.get(2);
            planObj.set(CKMONTH[currentMonth], (Object)STATUS_ENABLE);
            this.getView().updateView(CKMONTH[currentMonth]);
        }
    }

    private void initWeekValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int currentWeek = startTime.get(7);
            planObj.set(CKWEEK[currentWeek - 1], (Object)STATUS_ENABLE);
            this.getView().updateView(CKWEEK[currentWeek - 1]);
        }
    }

    private void setModelValue(String key, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(key, value);
        this.getModel().endInit();
        this.getView().updateView(key);
    }
}

