/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.edit;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.service.ArchiveService;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveScheduleUtils;
import kd.bos.cbs.plugin.archive.edit.ArchiveSchemaCleanEditPlugin;
import kd.bos.cbs.plugin.archive.edit.ArchiveSchemaEditPlugin;
import kd.bos.cbs.plugin.archive.edit.ArchiveSchemaSyncEditPlugin;
import kd.bos.cbs.plugin.tools.OperateLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class ArchiveSchemaBaseEditPlugin
extends AbstractFormPlugin
implements ArchiveConstant {
    protected final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
    private static final String EXIST_SAME_CONFIG = "existSameConfig";
    private static final String ROW_COUNT = "rowCount";
    private static final String MIN_ROW_INDEX = "minRowIndex";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"execplan"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        IBillModel billModel = (IBillModel)this.getModel();
        billModel.setValue("executor", (Object)RequestContext.get().getUserId());
    }

    public void afterBindData(EventObject e) {
        long id = (Long)this.getModel().getDataEntity().getPkValue();
        if (id != 0L && !ArchiveManager.get().checkScheduleEnd(id)) {
            DynamicObjectCollection entryList = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            for (int i = 0; i < entryList.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"config"});
            }
        }
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("execplan".equals(key)) {
            IBillModel billModel = (IBillModel)this.getModel();
            long id = (Long)billModel.getValue("id");
            if (StringUtils.isBlank((Object)id) || id == 0L) {
                id = DB.genGlobalLongId();
                billModel.getDataEntity().set("id", (Object)id);
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bos_cbs_archi_sch");
            String scheduleId = (String)billModel.getValue("scheduleplanid");
            if (StringUtils.isNotEmpty((CharSequence)scheduleId)) {
                parameter.setCustomParam("schplanid", (Object)scheduleId);
                parameter.setStatus(OperationStatus.EDIT);
            } else {
                parameter.setStatus(OperationStatus.ADDNEW);
                HashMap<String, Long> map = new HashMap<String, Long>(1);
                map.put("ArchiveSchemaId", id);
                String idJson = new JSONObject(map).toJSONString();
                parameter.setCustomParam("paramjsonstr", (Object)idJson);
                parameter.setCustomParam("taskclassname", (Object)"kd.bos.cbs.plugin.archive.task.ArchiveTask");
                parameter.setCustomParam("taskdefineid", (Object)"2145XJVI2N49");
                parameter.setCustomParam("schedulename", (Object)ResManager.loadKDString((String)"\u5f52\u6863\u8c03\u5ea6\u521b\u5efa\u8ba1\u5212", (String)"ArchiveSchemaEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"\u5f52\u6863\u8c03\u5ea6\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u4f5c\u4e1a", (String)"ArchiveSchemaEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                parameter.setCustomParam("tasknumber", (Object)(this.getPrefix() + this.SDF.format(ID.getCreateTime((long)id))));
                parameter.setCustomParam("taskappnumber", (Object)"bos");
                DynamicObject executor = (DynamicObject)billModel.getValue("executor");
                if (executor != null) {
                    parameter.setCustomParam("executor", executor.get("id"));
                }
            }
            parameter.setHasRight(true);
            parameter.setCustomParam("frombiz", (Object)"true");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scheduleReturn"));
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("800");
            styleCss.setHeight("700");
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IDataModel model;
        int rowCount;
        super.itemClick((ItemClickEvent)evt);
        String key = evt.getItemKey();
        if ("advconbar_add".equals(key)) {
            IDataModel model2 = this.getModel();
            int rowCount2 = model2.getEntryRowCount("entryentity");
            for (int i = 0; i < rowCount2; ++i) {
                DynamicObject configBefore = (DynamicObject)model2.getValue("config", i);
                if (configBefore != null && configBefore.get("masterid") != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5f53\u524d\u884c\u6570\u636e\u518d\u65b0\u589e\u884c\u3002", (String)"ArchiveSchemaBaseEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("advconbar_delete".equals(key) && (rowCount = (model = this.getModel()).getEntryRowCount("entryentity")) <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArchiveSchemaBaseEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    private String getPrefix() {
        if (this instanceof ArchiveSchemaEditPlugin) {
            return "ARCHIVE_SCH_";
        }
        if (this instanceof ArchiveSchemaCleanEditPlugin) {
            return "ARCHIVE_CLN_";
        }
        if (this instanceof ArchiveSchemaSyncEditPlugin) {
            return "ARCHIVE_SYN_";
        }
        return "ARCHIVE_SCH_";
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isExist;
        IDataModel model = this.getModel();
        model.setDataChanged(false);
        Object id = model.getValue("id");
        Object scheduleId = model.getValue("scheduleplanid");
        if (StringUtils.isNotBlank((Object)scheduleId) && !(isExist = QueryServiceHelper.exists((String)"bos_cbs_archi_schema", (Object)id))) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"sch_schedule", (String)"job", (QFilter[])new QFilter("id", "=", scheduleId).toArray());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sch_schedule"), (Object[])new Object[]{scheduleId});
            if (Objects.nonNull(dynamicObject)) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sch_job"), (Object[])new Object[]{dynamicObject.get("job")});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData != null && "scheduleReturn".equals(actionId)) {
            DynamicObject scheduleInfo;
            IDataModel model = this.getModel();
            if (retData != null && (scheduleInfo = (DynamicObject)retData) != null) {
                Date endTime = scheduleInfo.getDate("endtime");
                String schNumber = scheduleInfo.getString("number");
                String scheduleId = (String)scheduleInfo.get("schplanid");
                model.setValue("scheduleplanid", (Object)scheduleId);
                String txtDesc = (String)scheduleInfo.get("txtdesc");
                if (StringUtils.isNotEmpty((CharSequence)txtDesc) && txtDesc.length() > 153) {
                    txtDesc = txtDesc.substring(0, 150) + "...";
                }
                this.getModel().setValue("execplan", (Object)txtDesc);
                this.getModel().setValue("endtime", (Object)endTime);
                this.getModel().setValue("number", (Object)schNumber);
                Object id = model.getValue("id");
                boolean isExist = QueryServiceHelper.exists((String)"bos_cbs_archi_schema", (Object)id);
                if (isExist) {
                    String updateSql = "update t_cbs_archi_schema set fexecplan = ?, fendtime = ? where fid = ?";
                    Object[] params = new Object[]{txtDesc, endTime, id};
                    DB.execute((DBRoute)DBRoute.base, (String)updateSql, (Object[])params);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("config".equals(propertyName)) {
            int fromRowCountCache;
            DynamicObject dataEntity;
            DynamicObject archiveConfig;
            IPageCache pageCache = this.getPageCache();
            IDataModel model = this.getModel();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String minRowIndexCache = pageCache.get(MIN_ROW_INDEX);
            if (StringUtils.isEmpty((CharSequence)minRowIndexCache)) {
                String rowIndexStr = String.valueOf(rowIndex);
                pageCache.put(MIN_ROW_INDEX, rowIndexStr);
                minRowIndexCache = rowIndexStr;
            }
            int rowCount = model.getEntryRowCount("entryentity");
            String rowCountCache = pageCache.get(ROW_COUNT);
            if (StringUtils.isEmpty((CharSequence)rowCountCache)) {
                String rowCountStr = String.valueOf(rowCount);
                pageCache.put(ROW_COUNT, rowCountStr);
                rowCountCache = rowCountStr;
            }
            if ((archiveConfig = (DynamicObject)(dataEntity = e.getChangeSet()[0].getDataEntity()).get(propertyName)) != null && this.hasSameConfig(rowIndex)) {
                pageCache.put(EXIST_SAME_CONFIG, "true");
            }
            if (rowIndex == (fromRowCountCache = Integer.parseInt(rowCountCache)) - 1) {
                String existConfig = pageCache.get(EXIST_SAME_CONFIG);
                if (existConfig != null && Boolean.parseBoolean(existConfig)) {
                    int fromMinRowIndexCache = Integer.parseInt(minRowIndexCache);
                    for (int i = rowIndex; i >= fromMinRowIndexCache; --i) {
                        model.deleteEntryRow("entryentity", i);
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u914d\u7f6e,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ArchiveDispatcherEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
                pageCache.put(EXIST_SAME_CONFIG, "false");
                pageCache.put(ROW_COUNT, "");
                pageCache.put(MIN_ROW_INDEX, "");
            }
        }
    }

    private boolean hasSameConfig(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject dyObj = (DynamicObject)model.getValue("config", rowIndex);
        Long configId = (Long)dyObj.get("masterid");
        for (int i = 0; i < rowIndex; ++i) {
            DynamicObject configBefore = (DynamicObject)model.getValue("config", i);
            Long configBeforeId = (Long)configBefore.get("masterid");
            if (configBeforeId.compareTo(configId) != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean validateArchiveEnable(BeforeDoOperationEventArgs e) {
        if (!AccountEnable.isAccountEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6570\u636e\u5f52\u6863\u914d\u7f6e\u3002", (String)"ArchiveDispatcherEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        long id = (Long)model.getDataEntity().getPkValue();
        if ("enable".equals(operateKey) || "disable".equals(operateKey)) {
            if (!this.validateArchiveEnable(e)) {
                return;
            }
            if (!ORM.create().exists("bos_cbs_archi_schema", model.getDataEntity().getPkValue())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"ArchiveDispatcherEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        } else if ("newentry".equalsIgnoreCase(operateKey) || "deleteentry".equalsIgnoreCase(operateKey)) {
            if (!ArchiveManager.get().checkScheduleEnd(id)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ArchiveDispatcherEditPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("execute".equalsIgnoreCase(operateKey)) {
            ArchiveService.get().submitChangeTask(operateKey);
            String enable = (String)model.getValue("enable");
            if (Objects.equals("0", enable)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u8be5\u8c03\u5ea6\u8ba1\u5212\u3002", (String)"ArchiveDispatcherEditPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            ArchiveScheduleUtils.execute(model.getDataEntity().getPkValue());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u5df2\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u8fd0\u884c\u65e5\u5fd7\u5217\u8868\u3002", (String)"ArchiveDispatcherEditPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            String entityDisplayName = (String)((BaseModel)this.getModel()).getMainEntityType().getDisplayName().get((Object)"zh_CN");
            String number = (String)model.getDataEntity().get("number");
            String opName = ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"ArchiveSchemaBaseEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            String opDesc = ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s\uff0c%2$s\u624b\u5de5\u6267\u884c\u6210\u529f\u3002", (String)"ArchiveSchemaBaseEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u7801\uff1a%1$s\uff0c%2$s\u624b\u5de5\u6267\u884c\u6210\u529f\u3002", "ArchiveSchemaBaseEditPlugin_3", "bos-cbs-plugin");
            OperateLogUtil.insertSimpleOperateLog(this.getView(), this.getModel().getDataEntityType().getName(), operateKey, String.format(opDesc, number, entityDisplayName), RequestContext.get().getOrgId(), number, langEnumBridge, number, entityDisplayName);
        }
        if ("enable".equals(operateKey)) {
            String value = (String)model.getValue("scheduleplanid");
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (StringUtils.isEmpty((CharSequence)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArchiveDispatcherEditPlugin_12", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArchiveDispatcherEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void recordLog(String opName, String opDesc, String formNumber) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        String operateKey = args.getOperateKey();
        PlanInfo planInfo = ArchiveScheduleUtils.getPlanInfo((String)model.getValue("scheduleplanid"));
        if ("enable".equals(operateKey) && Objects.nonNull(planInfo) && planInfo.getRepeatMode() == RepeatModeEnum.NONE) {
            ArchiveScheduleUtils.execute(model.getDataEntity().getPkValue());
        }
    }
}

