/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.config.AccountEnable;
import kd.bos.cbs.plugin.archive.common.config.ArchiveControlConfig;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ControlContext;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.form.control.BarItemAp;

public class AntiArchivingTemplateListPlugin
extends AbstractListPlugin
implements ArchiveConstant,
ArchiveLogable {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String isInitBarItem = pageCache.get("isInitBarItem");
        if (!Boolean.parseBoolean(isInitBarItem)) {
            Container tb = (Container)view.getControl("toolbarap");
            BarItemAp barItemAp = new BarItemAp();
            barItemAp.setId("anti_archiving");
            barItemAp.setKey("anti_archiving");
            barItemAp.setName(new LocaleString(ResManager.loadKDString((String)"\u53cd\u5f52\u6863", (String)"AntiArchivingTemplateListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0])));
            barItemAp.setBusyTip(new LocaleString(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u4e2d\uff0c\u8bf7\u7b49\u5019\u3002", (String)"AntiArchivingTemplateListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0])));
            Map control = barItemAp.createControl();
            ArrayList<Map> items = new ArrayList<Map>();
            items.add(control);
            if (ArchiveControlConfig.isAllAntiArchiveEnable()) {
                BarItemAp allAntiArchive = new BarItemAp();
                allAntiArchive.setId("all_anti_archiving");
                allAntiArchive.setKey("all_anti_archiving");
                allAntiArchive.setName(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u53cd\u5f52\u6863", (String)"AntiArchivingTemplateListPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                allAntiArchive.setBusyTip(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u53cd\u5f52\u6863\u4e2d\uff0c\u8bf7\u7b49\u5019\u3002", (String)"AntiArchivingTemplateListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                items.add(allAntiArchive.createControl());
            }
            tb.addControls(items);
            pageCache.put("isInitBarItem", "true");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (("anti_archiving".equals(itemKey) || "all_anti_archiving".equals(itemKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        if ("anti_archiving".equals(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AntiArchivingTemplateListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String confirmTip = ResManager.loadKDString((String)"\u5c06\u5bf9\u6240\u9009\u6570\u636e\u8fdb\u884c\u53cd\u5f52\u6863\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"AntiArchivingTemplateListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("antiArchive");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        } else if ("all_anti_archiving".equals(itemKey)) {
            String confirmTip = ResManager.loadKDString((String)"\u5c06\u5bf9\u6240\u6709\u6570\u636e\u8fdb\u884c\u53cd\u5f52\u6863\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"AntiArchivingTemplateListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("all_antiArchive");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (messageBoxClosedEvent.getCallBackId().equals("antiArchive")) {
                BillList billList = (BillList)this.getControl("billlistap");
                Object id = this.getView().getFormShowParameter().getCustomParam("id");
                long entityRecordId = id instanceof Integer ? ((Integer)id).longValue() : ((Long)id).longValue();
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                ArrayList<Object> pkIds = new ArrayList<Object>(selectedRows.size());
                for (ListSelectedRow selectedRow : selectedRows) {
                    Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                    pkIds.add(primaryKeyValue);
                }
                ArchiveManager.get().addArchiveReverseTask(entityRecordId, pkIds);
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException e) {
                    log.error("TimeUnit sleep failed:" + e.getMessage(), (Throwable)e);
                }
                this.getView().invokeOperation("refresh");
            } else if (messageBoxClosedEvent.getCallBackId().equals("all_antiArchive")) {
                Object id = this.getView().getFormShowParameter().getCustomParam("id");
                long entityRecordId = id instanceof Integer ? ((Integer)id).longValue() : ((Long)id).longValue();
                try {
                    ArchiveManager.get().addArchiveReverseTask(entityRecordId);
                }
                catch (Exception e) {
                    log.error("All Anti-Archive failed:" + e.getMessage(), (Throwable)e);
                }
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException e) {
                    log.error("TimeUnit sleep failed:" + e.getMessage(), (Throwable)e);
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs filterContainerInitArgs) {
        IPageCache pageCache = this.getPageCache();
        String firstInitContainer = pageCache.get("firstInitContainer");
        if (!Boolean.parseBoolean(firstInitContainer)) {
            List commonFilterColumns = filterContainerInitArgs.getCommonFilterColumns();
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                commonFilterColumn.setDefaultValue(null);
            }
            FilterContainerInitEvent filterContainerInitEvent = filterContainerInitArgs.getFilterContainerInitEvent();
            FilterContainer filterContainer = (FilterContainer)filterContainerInitEvent.getSource();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
            String archiveKey = (String)formShowParameter.getCustomParam("archiveRoute");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String dbRouteKey = dataEntityType.getDBRouteKey();
            ControlContext context = filterContainer.getContext();
            context.setRouteKey(dbRouteKey);
            context.setArchiveKey(archiveKey);
            pageCache.put("firstInitContainer", "true");
        }
    }

    public void setFilter(SetFilterEvent e) {
        IPageCache pageCache = this.getPageCache();
        String firstInitFilter = pageCache.get("firstInitFilter");
        if (!Boolean.parseBoolean(firstInitFilter)) {
            e.getCustomQFilters().clear();
            pageCache.put("firstInitFilter", "true");
        }
    }
}

