/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.thread.ArchiveDropBakTableCallable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ArchiveBakTableListPlugin
extends AbstractListPlugin
implements ArchiveConstant {
    private static Log logger = LogFactory.getLog((String)"ArchiveBakTableListPlugin");
    private static final String queryMapNameSql = "select fmap_name from %s where fid = ?";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if ("bar_delete".equals(operateKey) || "do_drop".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4e2d\u95f4\u8868\u3002", (String)"ArchiveBakTableListPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String confirmTip = ResManager.loadKDString((String)"\u5220\u9664\u6240\u9009\u4e2d\u95f4\u8868\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ArchiveBakTableListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("deleteBakTable");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && messageBoxClosedEvent.getCallBackId().equals("deleteBakTable")) {
            this.deleteBakTable();
        }
    }

    private void deleteBakTable() {
        try (DLock dLock = DLock.create((String)"archive-drop-bak-table");){
            IFormView view = this.getView();
            if (dLock.tryLock()) {
                ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"archive-drop-bak-table");
                IPageCache pageCache = this.getPageCache();
                String routeKey = pageCache.get("routeKey");
                String queryTable = pageCache.get("queryTable");
                DBRoute dbRoute = DBRoute.of((String)routeKey);
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                ArrayList results = new ArrayList(selectedRows.size());
                ArrayList ids = new ArrayList(selectedRows.size());
                selectedRows.forEach(row -> ids.add((Long)row.getPrimaryKeyValue()));
                ids.forEach(id -> {
                    String mapTableName = (String)DB.query((DBRoute)dbRoute, (String)String.format(queryMapNameSql, queryTable), (Object[])new Object[]{id}, rs -> {
                        if (rs.next()) {
                            return rs.getString(1);
                        }
                        return null;
                    });
                    if (mapTableName != null) {
                        results.add(threadPool.submit(ThreadLifeCycleManager.wrapCallable((Callable)new ArchiveDropBakTableCallable(dbRoute, queryTable, (long)id, mapTableName))));
                    }
                });
                boolean flag = true;
                for (Future result : results) {
                    try {
                        flag &= ((Boolean)result.get()).booleanValue();
                    }
                    catch (Exception e) {
                        logger.error("Archive drop table fail:" + e.getMessage(), (Throwable)e);
                        view.showMessage(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25, \u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ArchiveBakTableListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), e.getMessage()));
                    }
                }
                if (flag) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ArchiveBakTableListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    view.invokeOperation("refresh");
                } else {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"ArchiveBakTableListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
                if (threadPool != null) {
                    threadPool.close();
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5220\u9664\u4e2d\u95f4\u8868\u64cd\u4f5c\uff0c\u8bf7\u7b49\u5f85\u540e\u5237\u65b0\u3002", (String)"ArchiveBakTableListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        Object taskId = this.getView().getFormShowParameter().getCustomParam("taskid");
        DynamicObject crossInfoDyo = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_archi_cross_info", (String)"taskid,entitynumber,archiveroute,tasktype", (QFilter[])new QFilter("taskid", "=", taskId).and("cleanstatus", "=", (Object)"0").toArray());
        if (crossInfoDyo != null) {
            DBRoute dbRoute;
            String entityNumber = crossInfoDyo.getString("entitynumber");
            IDataEntityType dataEntityType = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null);
            if (ArchiveTaskTypeEnum.ARCHIVE.getKey().equals(crossInfoDyo.getString("tasktype"))) {
                String dbRouteKey = dataEntityType.getDBRouteKey();
                dbRoute = DBRoute.of((String)dbRouteKey);
            } else {
                LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of((String)crossInfoDyo.getString("archiveroute"));
                String realArchiveKey = logicArchiveRoute.getRealArchiveKey();
                dbRoute = logicArchiveRoute.isCurrentArchive() ? DBRoute.of((String)dataEntityType.getDBRouteKey()) : DBRoute.of((String)realArchiveKey);
            }
            String table = dataEntityType.getAlias();
            String queryTable = ArchiveName.of((String)table).getArchiveMapTable();
            this.getPageCache().put("routeKey", dbRoute.getRouteKey());
            this.getPageCache().put("queryTable", queryTable);
            beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ShowBakTableListProvider(dbRoute, queryTable, (Long)taskId));
        }
    }

    static class ShowBakTableListProvider
    extends ListDataProvider {
        private DBRoute dbRoute;
        private String queryTable;
        private long taskId;

        public ShowBakTableListProvider(DBRoute dbRoute, String queryTable, long taskId) {
            this.dbRoute = dbRoute;
            this.queryTable = queryTable;
            this.taskId = taskId;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObject temp = ORM.create().newDynamicObject("bos_cbs_archi_tbbak");
            DynamicObjectCollection collection = new DynamicObjectCollection(temp.getDynamicObjectType(), null);
            DB.query((DBRoute)this.dbRoute, (String)("select top " + limit + ',' + start + " fid, ftaskid, ftable_name, fmap_name, fcleanstatus from " + this.queryTable + " where ftaskid = ? and fcleanstatus = '0'"), (Object[])new Object[]{this.taskId}, rs -> {
                while (rs.next()) {
                    DynamicObject dynamicObject = collection.addNew();
                    dynamicObject.set("id", rs.getObject(1));
                    dynamicObject.set("taskid", rs.getObject(2));
                    dynamicObject.set("table_name", rs.getObject(3));
                    dynamicObject.set("map_name", rs.getObject(4));
                    dynamicObject.set("cleanstatus", rs.getObject(5));
                }
                return null;
            });
            return collection;
        }

        public int getRealCount() {
            return (Integer)DB.query((DBRoute)this.dbRoute, (String)("select count(1) from " + this.queryTable + " where ftaskid = ? and fcleanstatus = '0'"), (Object[])new Object[]{this.taskId}, rs -> {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            });
        }
    }
}

