/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.archive.config.AccountEnable;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveBillConfigUtils;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ArchiveCascadeListPlugin
extends TemplateTreePlugin
implements ArchiveConstant {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String currentNodeId;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        IFormView view = this.getView();
        String operateKey = formOperate.getOperateKey();
        if (("modify".equals(operateKey) || "new".equals(operateKey) || "disable".equals(operateKey) || "enable".equals(operateKey) || "execute".equals(operateKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (Objects.equals("delete", formOperate.getOperateKey())) {
            ListSelectedRowCollection selectedRowList = args.getListSelectedData();
            for (ListSelectedRow selectedRow : selectedRowList) {
                DynamicObject curBill = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"bos_cbs_archi_cascade");
                String entityNumber = curBill.getString("entitynumber");
                if (ArchiveBillConfigUtils.existsArchiveConfig(entityNumber)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u914d\u7f6e\u5f52\u6863\u89c4\u5219\uff0c\u8bf7\u5148\u5220\u9664\u8be5\u5355\u636e\u7684\u5f52\u6863\u89c4\u5219\u3002", (String)"ArchiveCascadeListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                    args.setCancel(true);
                } else {
                    DynamicObject rootBill;
                    String rootEntityNumber;
                    DynamicObject parentBill = curBill.getDynamicObject("parent");
                    if (!Objects.nonNull(parentBill) || !ArchiveBillConfigUtils.existsAndEnableArchiveConfig(rootEntityNumber = (rootBill = ArchiveBillConfigUtils.getCascadeRootBill((Long)parentBill.getPkValue())).getString("entitynumber"))) continue;
                    view.showTipNotification(ResManager.loadKDString((String)"\u6839\u5355\u636e[%s]\u5df2\u914d\u7f6e\u542f\u7528\u5f52\u6863\u89c4\u5219\uff0c\u8bf7\u5148\u7981\u7528\u6839\u5355\u636e\u7684\u5f52\u6863\u89c4\u5219\u3002", (String)"ArchiveCascadeListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{rootEntityNumber}));
                    args.setCancel(true);
                }
                break;
            }
        } else if (Objects.equals("new", formOperate.getOperateKey()) && !StringUtils.isEmpty((CharSequence)(currentNodeId = this.getPageCache().get("currentNodeId")))) {
            DynamicObject currentBill = BusinessDataServiceHelper.loadSingle((Object)currentNodeId, (String)"bos_cbs_archi_cascade");
            if (currentBill.getInt("level") == 3) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5f52\u6863\u7ea7\u8054\u914d\u7f6e\u6700\u591a\u4e09\u7ea7\u3002", (String)"ArchiveCascadeListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject rootBill = ArchiveBillConfigUtils.getCascadeRootBill(Long.parseLong(currentNodeId));
            String rootEntityNumber = rootBill.getString("entitynumber");
            if (ArchiveBillConfigUtils.existsAndEnableArchiveConfig(rootEntityNumber)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6839\u5355\u636e\u5df2\u914d\u7f6e\u542f\u7528\u5f52\u6863\u89c4\u5219\uff0c\u8bf7\u5148\u7981\u7528\u6839\u5355\u636e\u7684\u5f52\u6863\u89c4\u5219\u518d\u6dfb\u52a0\u5b50\u5355\u636e\u3002", (String)"ArchiveCascadeListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        String rootId = treeModel.getRoot().getId();
        if (StringUtils.isNotEmpty((CharSequence)currentNodeId) && !Objects.equals(rootId, currentNodeId)) {
            this.getPageCache().put("currentNodeId", currentNodeId);
        } else {
            this.getPageCache().put("currentNodeId", null);
        }
        super.beforeItemClick(evt);
    }
}

