/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.archive.config.AccountEnable;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveDatabaseUtils;
import kd.bos.cbs.plugin.archive.common.util.BasedataRefValidator;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.TemplateGroupBaseDataPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ArchiveDataBaseTreeListPlugin
extends TemplateGroupBaseDataPlugin
implements ArchiveConstant {
    private static final String TBL_NEW = "tblnew";
    private static final String BTN_NEW = "btnnew";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    public void initialize() {
        super.initialize();
        Map focusNode = this.treeListView.getTreeView().getTreeState().getFocusNode();
        TreeNode root = this.getTreeModel().getRoot();
        String rootId = root.getId();
        if (focusNode == null || Boolean.parseBoolean(String.valueOf(focusNode.get("isParent"))) || rootId != null && rootId.equals(focusNode.get("id"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TBL_NEW});
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        Object source = e.getSource();
        Map focusNode = source instanceof TreeView ? ((TreeView)e.getSource()).getTreeState().getFocusNode() : ((TreeListView)e.getSource()).getTreeView().getTreeState().getFocusNode();
        boolean isParent = Boolean.parseBoolean(String.valueOf(focusNode.get("isParent"))) || focusNode.get("children") != null;
        TreeNode root = this.getTreeModel().getRoot();
        String rootId = root.getId();
        if (isParent || rootId != null && rootId.equals(focusNode.get("id"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TBL_NEW});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{TBL_NEW});
        }
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        TreeNode root = this.getTreeModel().getRoot();
        root.setText(ResManager.loadKDString((String)"\u5f52\u6863\u5e93\u5206\u7ec4", (String)"ArchiveDataBaseTreeListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
    }

    public void treeToolbarClick(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        Control ctl = (Control)e.getSource();
        if (ctl.getKey().equals(BTN_NEW)) {
            DynamicObject queryObj;
            String currentNodeId;
            if (!AccountEnable.isEnable()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            TreeNode root = treeModel.getRoot();
            List childPath = root.getChildPath(currentNodeId = (String)treeModel.getCurrentNodeId());
            if (childPath.size() > 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u5e93\u5206\u7ec4\u4e0d\u80fd\u8d85\u8fc7\u4e09\u7ea7\u3002", (String)"ArchiveDataBaseTreeListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (!Objects.equals(root.getId(), currentNodeId) && (queryObj = BusinessDataServiceHelper.loadSingle((Object)currentNodeId, (String)"bos_cbs_archi_group_rule")).getBoolean("preset")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5206\u7ec4\u4e0d\u80fd\u6dfb\u52a0\u5b50\u7ea7\u5206\u7ec4\u3002", (String)"ArchiveDataBaseTreeListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
        } else if (ctl.getKey().equals("btndel")) {
            DynamicObject queryObj;
            TreeNode root = treeModel.getRoot();
            String currentNodeId = (String)treeModel.getCurrentNodeId();
            if (!Objects.equals(root.getId(), currentNodeId) && (queryObj = BusinessDataServiceHelper.loadSingle((Object)currentNodeId, (String)"bos_cbs_archi_group_rule")).getBoolean("preset")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5206\u7ec4\u4e0d\u80fd\u5220\u9664\u3002", (String)"ArchiveDataBaseTreeListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
        } else if (ctl.getKey().equals("btnedit") && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        super.treeToolbarClick(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("modify".equals(formOperate.getOperateKey()) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("delete".equalsIgnoreCase(formOperate.getOperateKey())) {
            ListSelectedRowCollection selectedRowList = args.getListSelectedData();
            for (ListSelectedRow selectedRow : selectedRowList) {
                Object pkValue = selectedRow.getPrimaryKeyValue();
                DynamicObject curBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bos_cbs_archi_database");
                String archiveRoute = curBill.getString("archiveroute");
                String number = curBill.getString("number");
                if (ArchiveDatabaseUtils.hasArchiveData(archiveRoute)) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\u5f52\u6863\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ArchiveDataBaseTreeListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), number));
                    args.setCancel(true);
                    return;
                }
                List<String> errMsgList = BasedataRefValidator.validate("bos_cbs_archi_database", new Object[]{pkValue}, Collections.singletonList("bos_cbs_archi_clean"), null);
                if (CollectionUtils.isEmpty(errMsgList)) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u51fa\u9519\u3002", (String)"ArchiveDataBaseTreeListPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), String.join((CharSequence)"\n", errMsgList), MessageTypes.Default);
                args.setCancel(true);
                return;
            }
        } else if ("new".equalsIgnoreCase(formOperate.getOperateKey()) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterBindData(EventObject e) {
        BillList billList;
        ListSelectedRowCollection rows;
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_NEW});
        if (e.getSource() instanceof BillList && (rows = (billList = (BillList)e.getSource()).getCurrentListAllRowCollection()) != null && !rows.isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_NEW});
        }
        super.afterBindData(e);
    }
}

