/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.archive.config.AccountEnable;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.common.util.ArchiveBillConfigUtils;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ArchiveIndexListPlugin
extends AbstractListPlugin
implements ArchiveConstant {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        IFormView view = this.getView();
        String operateKey = formOperate.getOperateKey();
        if (("modify".equals(operateKey) || "new".equals(operateKey) || "disable".equals(operateKey) || "enable".equals(operateKey) || "execute".equals(operateKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (Objects.equals("delete", formOperate.getOperateKey())) {
            ListSelectedRowCollection selectedRowList = args.getListSelectedData();
            for (ListSelectedRow selectedRow : selectedRowList) {
                DynamicObject curBill = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"bos_cbs_archi_index");
                String entityNumber = curBill.getString("entitynumber");
                if (!ArchiveBillConfigUtils.existsApkTable(entityNumber)) continue;
                view.showMessage(ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u5b58\u5728\u5f52\u6863\u7d22\u5f15\u8868\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ArchiveIndexListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                args.setCancel(true);
                break;
            }
        }
    }
}

