/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.archive.list;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.archive.config.AccountEnable;
import kd.bos.cbs.plugin.archive.common.constant.ArchiveConstant;
import kd.bos.cbs.plugin.archive.list.ArchiveSchemaBaseListPlugin;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ArchiveSchemaListPlugin
extends ArchiveSchemaBaseListPlugin
implements ArchiveConstant {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("movingtype", "=", (Object)"0"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        if (("modify".equals(operateKey) || "new".equals(operateKey) || "disable".equals(operateKey) || "enable".equals(operateKey) || "execute".equals(operateKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("enable".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = e.getListSelectedData();
            for (ListSelectedRow selectedRow : listSelectedData) {
                Long id = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject queryObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_cbs_archi_schema");
                String number = queryObj.getString("number");
                String planId = queryObj.getString("scheduleplanid");
                DynamicObjectCollection entryEntity = queryObj.getDynamicObjectCollection("entryentity");
                if (StringUtils.isEmpty((String)planId)) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6267\u884c\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArchiveSchemaListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), number));
                    e.setCancel(true);
                    return;
                }
                if (!CollectionUtils.isEmpty((Collection)entryEntity)) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5f52\u6863\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArchiveSchemaListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), number));
                e.setCancel(true);
                return;
            }
        }
        if (("enable".equals(operateKey) || "execute".equals(operateKey) || "disable".equals(operateKey) || "new".equals(operateKey)) && !AccountEnable.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u529f\u80fd\u672a\u542f\u7528\u3002", (String)"ArchiveDataBaseTreeListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        super.beforeDoOperation(e);
    }
}

