/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.bdsync;

import java.util.HashMap;
import java.util.List;
import kd.bos.bdsync.BDSyncCheckMsg;
import kd.bos.bdsync.BDSyncImpl;
import kd.bos.bdsync.BDSyncStatusType;
import kd.bos.bdsync.DBSyncStatusMsg;
import kd.bos.bdsync.ErrorRowInfo;
import kd.bos.cbs.plugin.bdsync.DTSConfigOperate;
import kd.bos.cbs.plugin.bdsync.StatusListDataProvider;
import kd.bos.cbs.plugin.dts.common.DtsConstants;
import kd.bos.cbs.plugin.tools.OperateLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BdsyncConfigListPlugin
extends AbstractListPlugin
implements DtsConstants {
    private static final String ENTITY = "cbs_bdsync_config";
    private static final String CHECK_FORM = "cbs_bdsync_check";
    private static final String DELETE_BTN = "delete";
    private static final String RESYNC_BTN = "resync";
    private static final String CHECK_BTN = "check";
    private static final String ENABLE_BTN = "enable";
    private static final String DISABLE_BTN = "disable";
    private static final String CHECK_ERROR = "CHECK_ERROR";
    private static final String SYNC_STATUS_ERROR = "SYNC_STATUS_ERROR";

    public void preOpenForm(PreOpenFormEventArgs e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new StatusListDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Object fid = selectedRows.get(0).getPrimaryKeyValue();
        String entityNumber = this.getEntityNumber(fid);
        DBRoute targetRoute = this.getTargetRoute(fid);
        BDSyncImpl bdSync = new BDSyncImpl();
        DBSyncStatusMsg bdSyncStatusMsg = bdSync.getBDSyncStatusMsg(entityNumber, targetRoute);
        BDSyncStatusType bdSyncStatusType = bdSyncStatusMsg.getBdSyncStatusType();
        if (this.isEnable(fid)) {
            FormShowParameter showParameter = new FormShowParameter();
            String DTS_STATUS_DETAIL = "dts_status_detail";
            if (bdSyncStatusType.equals((Object)BDSyncStatusType.RUNNING)) {
                HashMap<String, String> mp = new HashMap<String, String>(6);
                mp.put("entity_number", entityNumber);
                mp.put("destination_type", "businessdb");
                mp.put("region", targetRoute.getRouteKey());
                mp.put("business_type", "basetablebroadcast");
                showParameter.setCustomParams(mp);
                showParameter.setFormId("dts_status_detail");
                showParameter.setFormId(DTS_STATUS_DETAIL);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                listView.showForm(showParameter);
            } else if (bdSyncStatusType.equals((Object)BDSyncStatusType.FAILED)) {
                listView.showForm(this.openResultForm(SYNC_STATUS_ERROR, bdSyncStatusMsg.getDescription()));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u540c\u6b65\u3002", (String)"BdsyncConfigListPlugin_22", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u3002", (String)"BdsyncConfigListPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
        args.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if (operateKey.equals(DELETE_BTN) && selectedRows.size() == 1) {
            HashMap<String, String> rowData = this.getSelectedRowData(selectedRows);
            DTSConfigOperate.deleteDtsConfig(rowData.get("entityNumber"), rowData.get("targetRoute"));
        }
        switch (operateKey) {
            case "resync": {
                this.operateResync(selectedRows);
                break;
            }
            case "check": {
                this.operateCheck(selectedRows);
                break;
            }
            case "enable": {
                this.operateEnable(selectedRows);
                break;
            }
            case "disable": {
                this.operateDisable(selectedRows);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        String operateKey = e.getOperateKey();
        if (RESYNC_BTN.equals(operateKey)) {
            for (ListSelectedRow selectedRow : selectedRows) {
                String entityNumber = this.getEntityNumber(selectedRow.getPrimaryKeyValue());
                String opName = ResManager.loadKDString((String)"\u91cd\u65b0\u540c\u6b65", (String)"BdsyncConfigListPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                String opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u91cd\u65b0\u540c\u6b65\u6210\u529f\u3002", (String)"BdsyncConfigListPlugin_20", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber);
                MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u91cd\u65b0\u540c\u6b65\u6210\u529f\u3002", "BdsyncConfigListPlugin_20", "bos-cbs-plugin");
                OperateLogUtil.insertSimpleOperateLog(this.getView(), ((ListView)this.getView()).getBillFormId(), operateKey, opDesc, RequestContext.get().getOrgId(), entityNumber, langEnumBridge, entityNumber);
            }
        }
    }

    private void operateResync(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() == 1) {
            BDSyncImpl bdSync = new BDSyncImpl();
            Object fid = selectedRows.get(0).getPrimaryKeyValue();
            if (!this.isEnable(fid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u91cd\u65b0\u540c\u6b65\u3002", (String)"BdsyncConfigListPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = this.getEntityNumber(fid);
            DBRoute targetRoute = this.getTargetRoute(fid);
            bdSync.reSync(entityNumber, targetRoute);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u540c\u6b65\u6210\u529f\u3002", (String)"BdsyncConfigListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BdsyncConfigListPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
    }

    private void operateCheck(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() == 1) {
            BDSyncImpl bdSync = new BDSyncImpl();
            Object fid = selectedRows.get(0).getPrimaryKeyValue();
            String entityNumber = this.getEntityNumber(fid);
            DBRoute targetRoute = this.getTargetRoute(fid);
            DBSyncStatusMsg bdSyncStatusMsg = bdSync.getBDSyncStatusMsg(entityNumber, targetRoute);
            if (!this.isEnable(fid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u6821\u9a8c\u3002", (String)"BdsyncConfigListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (bdSyncStatusMsg.getBdSyncStatusType().equals((Object)BDSyncStatusType.RUNNING)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u6b63\u5728\u540c\u6b65\uff0c\u65e0\u6cd5\u6821\u9a8c\u3002", (String)"BdsyncConfigListPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (bdSyncStatusMsg.getBdSyncStatusType().equals((Object)BDSyncStatusType.FAILED)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u540c\u6b65\u5931\u8d25\uff0c\u65e0\u6cd5\u6821\u9a8c\u3002", (String)"BdsyncConfigListPlugin_11", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            BDSyncCheckMsg bdSyncCheckMsg = bdSync.check(entityNumber, targetRoute);
            if (bdSyncCheckMsg.isConsistent()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f\u3002", (String)"BdsyncConfigListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            } else {
                this.getView().showForm(this.openResultForm(CHECK_ERROR, this.checkMessageToString(bdSyncCheckMsg)));
            }
        } else if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BdsyncConfigListPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
    }

    private void operateEnable(ListSelectedRowCollection selectedRows) {
        this.setEnable(selectedRows, true);
        this.getView().updateView();
    }

    private void operateDisable(ListSelectedRowCollection selectedRows) {
        this.setEnable(selectedRows, false);
        this.getView().updateView();
    }

    private boolean setEnable(ListSelectedRowCollection selectedRows, boolean enable) {
        IFormView formView = this.getView();
        boolean flag = true;
        if (selectedRows.size() == 1) {
            Object fid = selectedRows.get(0).getPrimaryKeyValue();
            if (this.isEnable(fid) && enable) {
                flag = false;
            }
            if (!this.isEnable(fid) && !enable) {
                flag = false;
            }
            if (flag) {
                this.updateBdsyncConfig(fid, enable);
                DTSConfigOperate.saveToDtsConfig(this.getEntityNumber(fid), this.getTargetRouteField(fid), null, enable);
                this.getView().updateView();
            }
        } else if (selectedRows.size() == 0) {
            flag = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BdsyncConfigListPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
        return flag;
    }

    private void updateBdsyncConfig(Object fid, boolean enable) {
        String fenable = enable ? "1" : "0";
        String updateSql = "UPDATE T_CBS_BDSYNCCONFIG SET FENABLE=? WHERE FID=?";
        Object[] fields = new Object[]{fenable, fid};
        DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])fields);
    }

    private HashMap<String, String> getSelectedRowData(ListSelectedRowCollection selectedRows) {
        Object fid = selectedRows.get(0).getPrimaryKeyValue();
        HashMap<String, String> result = new HashMap<String, String>(2);
        String number = "entitynumber";
        String route = "targetroute";
        QFilter filter = new QFilter("id", "=", fid);
        String entityNumber = (String)QueryServiceHelper.queryOne((String)ENTITY, (String)number, (QFilter[])new QFilter[]{filter}).get(number);
        String targetRoute = (String)QueryServiceHelper.queryOne((String)ENTITY, (String)route, (QFilter[])new QFilter[]{filter}).get(route);
        result.put("entityNumber", entityNumber);
        result.put("targetRoute", targetRoute);
        return result;
    }

    private String getEntityNumber(Object fid) {
        QFilter filter = new QFilter("id", "=", fid);
        return (String)QueryServiceHelper.queryOne((String)ENTITY, (String)"entitynumber", (QFilter[])new QFilter[]{filter}).get("entitynumber");
    }

    private DBRoute getTargetRoute(Object fid) {
        return DBRoute.of((String)this.getTargetRouteField(fid));
    }

    private String getTargetRouteField(Object fid) {
        QFilter filter = new QFilter("id", "=", fid);
        return (String)QueryServiceHelper.queryOne((String)ENTITY, (String)"targetroute", (QFilter[])new QFilter[]{filter}).get("targetroute");
    }

    private boolean isEnable(Object fid) {
        QFilter filter = new QFilter("id", "=", fid);
        return (Boolean)QueryServiceHelper.queryOne((String)ENTITY, (String)ENABLE_BTN, (QFilter[])new QFilter[]{filter}).get(ENABLE_BTN);
    }

    private FormShowParameter openResultForm(String openType, String value) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam(openType, (Object)value);
        if (openType.equals(SYNC_STATUS_ERROR)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u9519\u8bef\u4fe1\u606f\u3002", (String)"BdsyncConfigListPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
        formShowParameter.setFormId(CHECK_FORM);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        return formShowParameter;
    }

    private String checkMessageToString(BDSyncCheckMsg bdSyncCheckMsg) {
        List errorRowInfos = bdSyncCheckMsg.getErrorInfos();
        StringBuilder errorInfos = new StringBuilder();
        int count = 1;
        if (errorRowInfos.isEmpty()) {
            errorInfos.append(ResManager.loadKDString((String)"\u65e0", (String)"BdsyncConfigListPlugin_12", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
        for (ErrorRowInfo errorRowInfo : errorRowInfos) {
            errorInfos.append(ResManager.loadKDString((String)"\u5e8f\u53f7\uff1a", (String)"BdsyncConfigListPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0])).append(count++).append("\n");
            errorInfos.append(ResManager.loadKDString((String)"\u8868\u540d\uff1a", (String)"BdsyncConfigListPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0])).append(errorRowInfo.getTableName()).append("\n");
            errorInfos.append(ResManager.loadKDString((String)"\u5173\u8054\u5b57\u6bb5\u540d\uff1a", (String)"BdsyncConfigListPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0])).append(errorRowInfo.getRelationFieldName()).append("\n");
            errorInfos.append(ResManager.loadKDString((String)"\u5173\u8054\u5b57\u6bb5\u503c\uff1a", (String)"BdsyncConfigListPlugin_16", (String)"bos-cbs-plugin", (Object[])new Object[0])).append(errorRowInfo.getRelationFieldValue()).append("\n");
            errorInfos.append(ResManager.loadKDString((String)"\u540c\u6b65\u6e90\u8be6\u60c5\uff1a", (String)"BdsyncConfigListPlugin_17", (String)"bos-cbs-plugin", (Object[])new Object[0])).append(errorRowInfo.getSourceDetails()).append("\n");
            errorInfos.append(ResManager.loadKDString((String)"\u76ee\u6807\u6e90\u8be6\u60c5\uff1a", (String)"BdsyncConfigListPlugin_18", (String)"bos-cbs-plugin", (Object[])new Object[0])).append(errorRowInfo.getTargetDetails()).append("\n\n");
        }
        return errorInfos.toString();
    }
}

