/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.bdsync;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.query.QFilter;

public class DTSConfigOperate {
    private static final String ENABLE_FIELD = "ENABLE";
    private static final String TIMINGSEQUENCE_FIELD = "TIMINGSEQUENCE";
    private static final String REGION_FIELD = "REGION";
    private static final String DESTINATIONTYPE_FIELD = "DESTINATIONTYPE";
    private static final String BUSINESSTYPE_FIELD = "BUSINESSTYPE";
    private static final String ENTITYNUMBER_FIELD = "ENTITYNUMBER";
    private static final String destinationType = "businessdb";
    private static final String businessType = "basetablebroadcast";

    public static void reSyncDtsConfig(String entityNumber, String targetRoute) {
        ORM orm = ORM.create();
        IDataEntityType dataSyncConfigType = orm.getDataEntityType("data_sync_config");
        QFilter q = new QFilter(ENTITYNUMBER_FIELD, "=", (Object)entityNumber).and(new QFilter(BUSINESSTYPE_FIELD, "=", (Object)businessType)).and(new QFilter(DESTINATIONTYPE_FIELD, "=", (Object)destinationType)).and(new QFilter(REGION_FIELD, "=", (Object)targetRoute)).and(new QFilter(ENTITYNUMBER_FIELD, "=", (Object)entityNumber));
        DynamicObject dataSyncConfigObject = orm.queryOne("data_sync_config", new QFilter[]{q});
        if (dataSyncConfigObject != null) {
            Object pkId = dataSyncConfigObject.get("id");
            try (TXHandle tx = TX.requiresNew();){
                BusinessDataWriter.delete((IDataEntityType)dataSyncConfigType, (Object[])new Object[]{pkId});
                DTSConfigOperate.deleteSnapshot(pkId);
            }
            DynamicObject newDynamicObject = orm.newDynamicObject("data_sync_config");
            newDynamicObject.set(BUSINESSTYPE_FIELD, (Object)businessType);
            newDynamicObject.set(ENTITYNUMBER_FIELD, (Object)entityNumber);
            newDynamicObject.set(DESTINATIONTYPE_FIELD, (Object)destinationType);
            newDynamicObject.set(REGION_FIELD, (Object)targetRoute);
            newDynamicObject.set(TIMINGSEQUENCE_FIELD, dataSyncConfigObject.get(TIMINGSEQUENCE_FIELD));
            newDynamicObject.set(ENABLE_FIELD, dataSyncConfigObject.get(ENABLE_FIELD));
            try (TXHandle tx = TX.requiresNew();){
                BusinessDataWriter.save((IDataEntityType)dataSyncConfigType, (Object[])new Object[]{newDynamicObject});
            }
            DataSyncConfigCache.get().removeCache();
        }
    }

    public static void saveToDtsConfig(String entityNumber, String targetRoute, String timingSequence, boolean enable) {
        boolean isInsert;
        ORM orm = ORM.create();
        IDataEntityType dataSyncConfigType = orm.getDataEntityType("data_sync_config");
        QFilter q = new QFilter(ENTITYNUMBER_FIELD, "=", (Object)entityNumber).and(new QFilter(BUSINESSTYPE_FIELD, "=", (Object)businessType)).and(new QFilter(DESTINATIONTYPE_FIELD, "=", (Object)destinationType)).and(new QFilter(REGION_FIELD, "=", (Object)targetRoute)).and(new QFilter(ENTITYNUMBER_FIELD, "=", (Object)entityNumber));
        DynamicObject dataSyncConfigObject = orm.queryOne("data_sync_config", new QFilter[]{q});
        boolean bl = isInsert = dataSyncConfigObject == null;
        if (isInsert) {
            dataSyncConfigObject = orm.newDynamicObject("data_sync_config");
        }
        dataSyncConfigObject.set(BUSINESSTYPE_FIELD, (Object)businessType);
        dataSyncConfigObject.set(ENTITYNUMBER_FIELD, (Object)entityNumber);
        dataSyncConfigObject.set(DESTINATIONTYPE_FIELD, (Object)destinationType);
        dataSyncConfigObject.set(REGION_FIELD, (Object)targetRoute);
        if (timingSequence != null) {
            dataSyncConfigObject.set(TIMINGSEQUENCE_FIELD, (Object)timingSequence);
        }
        dataSyncConfigObject.set(ENABLE_FIELD, (Object)enable);
        try (TXHandle tx = TX.requiresNew();){
            if (isInsert) {
                BusinessDataWriter.save((IDataEntityType)dataSyncConfigType, (Object[])new Object[]{dataSyncConfigObject});
            } else {
                BusinessDataWriter.update((IDataEntityType)dataSyncConfigType, (Object[])new Object[]{dataSyncConfigObject});
            }
        }
        DataSyncConfigCache.get().removeCache();
    }

    public static void deleteDtsConfig(String entityNumber, String targetRoute) {
        List<Object> pkList = DTSConfigOperate.queryDtsPKS(entityNumber, targetRoute);
        if (!pkList.isEmpty()) {
            ORM orm = ORM.create();
            IDataEntityType dataSyncConfigType = orm.getDataEntityType("data_sync_config");
            BusinessDataWriter.delete((IDataEntityType)dataSyncConfigType, (Object[])pkList.toArray(new Object[pkList.size()]));
        }
        DataSyncConfigCache.get().removeCache();
    }

    private static List<Object> queryDtsPKS(String entityNumber, String targetRoute) {
        String querySearchDtsSql = "SELECT FID FROM T_DTS_DATASYNCCONFIG WHERE FENTITYNUMBER=? AND FDESTINATIONTYPE=? AND FREGION=? AND FBUSINESSTYPE=?";
        ArrayList<Object> pkList = new ArrayList<Object>(1);
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.basedata, (String)querySearchDtsSql, (Object[])new Object[]{entityNumber, destinationType, targetRoute, businessType});){
            for (Row row : ds) {
                pkList.add(row.get(0));
            }
        }
        return pkList;
    }

    private static void deleteSnapshot(Object fid) {
        String sql = "delete from  t_dts_syncconfigsnapshot where fid = ?";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{fid});
    }
}

