/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.dts;

import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DtsTablesConfigListPlugin
extends AbstractListPlugin {
    private static final String RELOAD_BTN = "reload";
    private static final String MODIFY_BTN = "modify";
    private static final String VIEW_BTN = "view";
    private static final String ENTITY = "dts_tables_config";
    private static final String ENTITYNUMBER_FIELD = "entitynumber";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if (MODIFY_BTN.equals(operateKey) || VIEW_BTN.equals(operateKey) || RELOAD_BTN.equals(operateKey)) {
            HashSet<Object> primaryKeyValueSet = new HashSet<Object>(1);
            for (ListSelectedRow listSelectedRow : selectedRows) {
                primaryKeyValueSet.add(listSelectedRow.getPrimaryKeyValue());
            }
            int size = primaryKeyValueSet.size();
            if (size <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DtsTablesConfigListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (size > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DtsTablesConfigListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (RELOAD_BTN.equals(operateKey)) {
            this.operateReload(selectedRows);
            args.setCancel(true);
        }
    }

    private void operateReload(ListSelectedRowCollection selectedRows) {
        Object fid = selectedRows.get(0).getPrimaryKeyValue();
        String entityNumber = this.getEntityNumber(fid);
        RelationTablesCache.get().flushRelationTables(entityNumber);
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u52a0\u8f7d\u5173\u8054\u8868\u6210\u529f\u3002", (String)"DtsTablesConfigListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
    }

    private String getEntityNumber(Object fid) {
        QFilter filter = new QFilter("id", "=", fid);
        return (String)QueryServiceHelper.queryOne((String)ENTITY, (String)ENTITYNUMBER_FIELD, (QFilter[])new QFilter[]{filter}).get(ENTITYNUMBER_FIELD);
    }
}

