/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.dts;

import java.util.List;
import java.util.Map;
import kd.bos.cbs.plugin.dts.common.DtsConstants;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.log.DtsStatusQuery;
import kd.bos.dts.log.StoreageHelper;
import kd.bos.dts.log.query.SyncStatistics;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DtsTpsDetailPlugin
extends AbstractFormPlugin
implements DtsConstants {
    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = this.createList();
        e.setDataEntity((Object)dataEntity);
    }

    private DynamicObject createList() {
        String timeStr = System.getProperty("dts.query.tps.minutes", "1,5,15,60,1440");
        Map mp = this.getView().getFormShowParameter().getCustomParams();
        DestinationRuleConfig destinationConfig = StoreageHelper.getDestinationConfig((String)String.valueOf(mp.get("business_type")), (String)String.valueOf(mp.get("region")), (String)String.valueOf(mp.get("destination_type")), (String)String.valueOf(mp.get("entity_number")));
        int[] ints = this.getQueryTime(timeStr);
        if (ints == null) {
            return new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        }
        List syncStatistics = DtsStatusQuery.get().queryCounts(ints, destinationConfig);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entity_tps_detail");
        for (int i = 0; i < ints.length; ++i) {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            newRow.set("tps_name", (Object)(ints[i] / 60));
            newRow.set("tps_sended_total", (Object)((SyncStatistics)syncStatistics.get(i)).getSendedTotal());
            newRow.set("tps_synced_total", (Object)((SyncStatistics)syncStatistics.get(i)).getSyncedTotal());
            newRow.set("insert_count", (Object)((SyncStatistics)syncStatistics.get(i)).getInsert());
            newRow.set("update_count", (Object)((SyncStatistics)syncStatistics.get(i)).getUpdate());
            newRow.set("delete_count", (Object)((SyncStatistics)syncStatistics.get(i)).getDelete());
            newRow.set("dts_tps_delay", (Object)((SyncStatistics)syncStatistics.get(i)).getAvgDelay());
            rows.add((Object)newRow);
        }
        return dataEntity;
    }

    private int[] getQueryTime(String timeStr) {
        if (StringUtils.isBlank((CharSequence)timeStr)) {
            return null;
        }
        String[] timeStrs = timeStr.split(",");
        int length = timeStrs.length;
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = Integer.parseInt(timeStrs[i]) * 60;
        }
        return ints;
    }
}

