/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.fulltext.list;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.util.StringUtils;

public class AbstractEntityTreePlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ClickListener {
    protected static final String BILLISTAP = "billlistap";
    protected static final String BTNOK = "btnok";

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
    }

    public void initializeTree(EventObject e) {
        this.intiTree();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getControl(BTNOK);
        if (btn != null) {
            btn.addClickListener((ClickListener)this);
        }
    }

    private String booleanConvert(Boolean temp) {
        return temp != false ? "1" : "0";
    }

    protected List<QFilter> addModelFilter(Boolean isTemplate, Map<String, Boolean> businessControlConfig) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (isTemplate.booleanValue()) {
            list.add(new QFilter("istemplate", "=", (Object)"1"));
        }
        if (businessControlConfig != null && businessControlConfig.size() > 0) {
            Boolean voucher;
            Boolean botp;
            Boolean workflow;
            Boolean billType;
            Boolean codeNumber = businessControlConfig.get("codenumber");
            if (codeNumber != null) {
                list.add(new QFilter("codenumber", "=", (Object)this.booleanConvert(codeNumber)));
            }
            if ((billType = businessControlConfig.get("billtype")) != null) {
                list.add(new QFilter("billtype", "=", (Object)this.booleanConvert(billType)));
            }
            if ((workflow = businessControlConfig.get("workflow")) != null) {
                list.add(new QFilter("workflow", "=", (Object)this.booleanConvert(workflow)));
            }
            if ((botp = businessControlConfig.get("botp")) != null) {
                list.add(new QFilter("botp", "=", (Object)this.booleanConvert(botp)));
            }
            if ((voucher = businessControlConfig.get("voucher")) != null) {
                list.add(new QFilter("voucher", "=", (Object)this.booleanConvert(voucher)));
            }
        }
        return list;
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            String type = (String)this.getView().getFormShowParameter().getCustomParam("selectaction");
            if (type != null) {
                if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals("FieldEdit")) {
                    this.returnData();
                } else if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals("doOpenParent")) {
                    this.getView().returnDataToParent(this.getCurrentSelector());
                    this.getView().close();
                }
            } else {
                BillList billList = (BillList)this.getView().getControl(BILLISTAP);
                this.getView().returnDataToParent((Object)billList.getSelectedRows());
                this.getView().close();
            }
            evt.setCancel(true);
        } else {
            super.beforeClick(evt);
        }
    }

    protected void returnData() {
        Object oldId;
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null && !ObjectUtils.nullSafeEquals(oldId = this.getView().getFormShowParameter().getCustomParams().get("value"), (Object)row.get("number"))) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", row.get("id"));
            para.put("alias", row.get("name").toString());
            paras.add(para);
            para = new HashMap();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", "BizBasedata");
            para.put("value", this.isBizBasedata((String)row.get("id")));
            paras.add(para);
            para = new HashMap();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", "RefProps");
            para.put("value", new ArrayList());
            paras.add(para);
            para = new HashMap();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", "DefValue");
            para.put("value", "");
            paras.add(para);
            para = new HashMap();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", "RefLayout");
            para.put("value", "");
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private boolean isBizBasedata(String baseEntityId) {
        if (StringUtils.isBlank((String)baseEntityId)) {
            return false;
        }
        String entityNumber = MetadataDao.getNumberById((String)baseEntityId);
        if (StringUtils.isBlank((String)entityNumber)) {
            return false;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (!(mainType instanceof BasedataEntityType)) {
            return false;
        }
        return ((BasedataEntityType)mainType).getMasteridType() == 2;
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew", "btnedit", "btndel"});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew"});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{"btnedit", "btndel"});
        }
    }

    public Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ListSelectedRow lsr = ((ListView)this.getView()).getCurrentSelectedRowInfo();
        if (lsr == null) {
            return null;
        }
        ORM orm = ORM.create();
        QFilter filter = new QFilter("number", "=", lsr.getPrimaryKeyValue());
        DynamicObject doj = orm.queryOne("bos_entityobject", new QFilter[]{filter});
        ret.put("id", doj.get("dentityid"));
        ret.put("number", doj.get("number"));
        OrmLocaleValue localeValue = (OrmLocaleValue)doj.get("name");
        if (localeValue.getLocaleValue_zh_CN() == null) {
            ret.put("name", localeValue.getLocaleValue_en());
        } else {
            ret.put("name", localeValue.getLocaleValue_zh_CN());
        }
        return ret;
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid", "in", (Object)units);
        } else {
            qFilter = new QFilter("bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        QFilter modelFilter = this.filter();
        modelFilter.and(this.getModelFilter(nodeId));
        nodeEvent.addQFilter(modelFilter);
        nodeEvent.setCancel(true);
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractEntityTreePlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getAllCloudNodes();
        for (TreeNode treeNode : cloudNodes) {
            List<TreeNode> groupNodes = this.getAppNodesByCloudId(treeNode.getId());
            this.addChildNode(treeNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    protected List<TreeNode> getAllCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            TreeNode node = new TreeNode("-1", cloudObject.getString("id"), cloudObject.getLocaleString("name").getLocaleValue());
            cloudNode.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                node.setId(dynamicObject.getString("id"));
                node.setText(dynamicObject.getString("name"));
                node.setParentid("-1");
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    protected List<TreeNode> getAppNodesByCloudId(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
            appNodes.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                String nodeId = dynamicObject.getString("id");
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(cloudId);
                appNodes.add(node);
            }
        }
        return appNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId());
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getAllCloudNodes();
            for (TreeNode treeNode : cloudNodes) {
                List<TreeNode> groupNodes = this.getAppNodesByCloudId(treeNode.getId());
                this.addChildNode(treeNode, groupNodes);
            }
        } else {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode((String)parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    protected JSONArray getModelFilterContent() {
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        JSONArray modelFilterContent = new JSONArray();
        if (!StringUtils.isEmpty((String)modeltype)) {
            String[] modelTypes;
            for (String modelType : modelTypes = modeltype.split(",")) {
                modelFilterContent.add((Object)modelType);
            }
        } else {
            modelFilterContent.add((Object)"BaseFormModel");
            modelFilterContent.add((Object)"BillFormModel");
            modelFilterContent.add((Object)"ReportFormModel");
            modelFilterContent.add((Object)"DynamicFormModel");
            modelFilterContent.add((Object)"QueryListModel");
            modelFilterContent.add((Object)"MobileFormModel");
        }
        modelFilterContent.add((Object)"PCLayoutModel");
        return modelFilterContent;
    }

    protected QFilter filter() {
        return new QFilter("modeltype", "in", (Object)this.getModelFilterContent());
    }

    protected JSONArray getUnitIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection query = orm.query("bos_devportal_bizapp", selectFields, filters, "sequence asc");
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String bizAppId = dynamicObject.getString("id");
            unitIds.add((Object)bizAppId);
        }
        return unitIds;
    }

    public void setFilter(SetFilterEvent e) {
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
    }
}

