/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.fulltext.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.cbs.plugin.fulltext.common.FullTextIndexCustomSyncCommon;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;

public class FullTextIndexCustomSyncOperationServicePlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        if (operationKey.equals("save")) {
            ArrayList<ExtendedDataEntity> toSaveEntities = new ArrayList<ExtendedDataEntity>(16);
            for (ExtendedDataEntity validExtDataEntity : e.getValidExtDataEntities()) {
                DynamicObjectCollection entryEntities = (DynamicObjectCollection)validExtDataEntity.getDataEntity().get("entryentity");
                DynamicObjectCollection toSaveEntryEntities = this.filterEntryEntities(entryEntities);
                entryEntities.clear();
                entryEntities.addAll((Collection)toSaveEntryEntities);
                toSaveEntities.add(validExtDataEntity);
            }
            e.getValidExtDataEntities().clear();
            e.getValidExtDataEntities().addAll(toSaveEntities);
        } else if (operationKey.equals("enable") || operationKey.equals("disable")) {
            int enable = operationKey.equals("enable") ? 1 : 0;
            List rows = e.getValidExtDataEntities();
            for (ExtendedDataEntity row : rows) {
                this.updateEnable(enable, row);
            }
        }
    }

    private void updateEnable(int enable, ExtendedDataEntity row) {
        Object pkId = row.getBillPkId();
        String sql = "UPDATE T_FULLTEXT_CUSTSYNC SET FISENABLE=? WHERE FID = ?;";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{enable, pkId});
        FullTextIndexCustomSyncCommon.removeCacheByEntityName(pkId);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (operationKey.equals("delete")) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                FullTextIndexCustomSyncCommon.removeCacheByEntityName(dataEntity.getPkValue());
            }
        }
    }

    private DynamicObjectCollection filterEntryEntities(DynamicObjectCollection entryEntities) {
        DynamicObjectCollection toSaveEntryEntities = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : entryEntities) {
            boolean isFieldEnable = (Boolean)dynamicObject.get("isfieldenable");
            if (!isFieldEnable) continue;
            toSaveEntryEntities.add((Object)dynamicObject);
        }
        return toSaveEntryEntities;
    }
}

