/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMetaFactory;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.AppInfo;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.TxListType;
import kd.bos.kdtx.common.entity.TxBranchSceneInfo;
import kd.bos.kdtx.common.entity.TxLogInfo;
import kd.bos.kdtx.common.entity.TxRetryInfo;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.param.ListTxInfoParam;
import kd.bos.kdtx.common.param.ListTxLogParam;
import kd.bos.kdtx.common.response.CompensateResponse;
import kd.bos.kdtx.common.service.DtxTxDispatchService;
import kd.bos.kdtx.sdk.compensate.Compensate;
import kd.bos.kdtx.sdk.entity.BaseTxBranchSceneInfo;
import kd.bos.kdtx.sdk.entity.BaseTxSceneInfo;
import kd.bos.kdtx.sdk.exception.DtxSdkException;
import kd.bos.kdtx.sdk.param.BaseListTxInfoParam;
import kd.bos.kdtx.sdk.param.BaseListTxLogParam;
import kd.bos.service.lookup.ServiceLookup;
import net.sf.cglib.beans.BeanCopier;

public class DtxCompensate
implements Compensate {
    private static String[] listTxFields = new String[]{"XID", "STATUS", "SECONDSTATUS", "TX_CREATED_TIME", "TX_SCENEID", "TASK_COMMIT_RETRY_COUNT", "TASK_ROLLBACK_RETRY_COUNT", "MAN_COMMIT_RETRY_COUNT", "MAN_ROLLBACK_RETRY_COUNT", "TX_DESC", "TX_TYPE", "MODE", "PARENT_XID", "BUSINESSIDS", "SECOND_BRANCH_SEQ", "COMPENSATE_STATUS"};
    private static String[] listlogFields = new String[]{"xid", "action_type", "branch_clazz", "branch_desc", "branch_xid", "remark", "trigger_type", "tx_desc", "start_time", "end_time", "result", "traceid"};
    private static BeanCopier baseTxSceneCopier = BeanCopier.create(BaseTxSceneInfo.class, TxSceneInfo.class, (boolean)false);
    private static BeanCopier txSceneCopier = BeanCopier.create(TxSceneInfo.class, BaseTxSceneInfo.class, (boolean)false);
    private static BeanCopier txBranchSceneCopier = BeanCopier.create(TxBranchSceneInfo.class, BaseTxBranchSceneInfo.class, (boolean)false);
    private static BeanCopier baseTxBranchSceneCopier = BeanCopier.create(BaseTxBranchSceneInfo.class, TxBranchSceneInfo.class, (boolean)false);
    private static BeanCopier baseTxInfoCopier = BeanCopier.create(BaseListTxInfoParam.class, ListTxInfoParam.class, (boolean)false);
    private static BeanCopier baseTxLogCopier = BeanCopier.create(BaseListTxLogParam.class, ListTxLogParam.class, (boolean)false);

    public CompensateResponse manuallyRetry(List<Map<String, String>> infos) {
        return DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).manuallyRetry(infos);
    }

    public CompensateResponse prepareTimeoutRollback(List<String> xids) {
        return DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).prepareTimeoutRollback(xids);
    }

    public Object listTxInfoDataSet(BaseListTxInfoParam baseListTxInfoParam) {
        ListTxInfoParam listTxInfoParam = new ListTxInfoParam();
        baseTxInfoCopier.copy((Object)baseListTxInfoParam, (Object)listTxInfoParam, null);
        switch (baseListTxInfoParam.getBaseTxListType()) {
            case TX_ALL: {
                listTxInfoParam.setTxListType(TxListType.TX_ALL);
                break;
            }
            case EXCEPTION_TX_ALL: {
                int compensateResultType = baseListTxInfoParam.getExceptionResultType();
                if (compensateResultType == 1) {
                    listTxInfoParam.setTxListType(TxListType.EXCEPTION_TX_ALL);
                    break;
                }
                if (compensateResultType == 2) {
                    listTxInfoParam.setTxListType(TxListType.EXCEPTION_TX_TO_HANDLE);
                    break;
                }
                if (compensateResultType == 3) {
                    listTxInfoParam.setTxListType(TxListType.EXCEPTION_TX_HANDEL_SUCCESS);
                    break;
                }
                if (compensateResultType == 4) {
                    listTxInfoParam.setTxListType(TxListType.EXCEPTION_TX_HANDEL_FAIL);
                    break;
                }
                throw new DtxSdkException("invalid result type");
            }
            default: {
                throw new DtxSdkException("invalid list type");
            }
        }
        List txRetryInfos = DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).listTxInfoDataSet(listTxInfoParam);
        DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.IntegerType, DataType.IntegerType, DataType.TimestampType, DataType.LongType, DataType.IntegerType, DataType.IntegerType, DataType.IntegerType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.IntegerType, DataType.IntegerType};
        DataSetBuilder builder = Algo.create((String)"tcc_tx_list").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])listTxFields, (DataType[])dataTypes));
        Map<String, List<String>> resultMap = this.getBusinessIds(txRetryInfos);
        for (TxRetryInfo info : txRetryInfos) {
            builder.append(new Object[]{info.getXid(), info.getStatus(), info.getSecondStatus(), info.getTxCreatedTime(), info.getTxSceneId(), info.getTaskCommitRetryCount(), info.getTaskRollbackRetryCount(), info.getManCommitRetryCount(), info.getManRollbackRetryCount(), info.getTxDesc(), info.getTxType(), info.getMode(), info.getParentXid(), this.getBusinessIdsString(resultMap, info.getXid()), info.getSecondBranchSeq(), info.getCompensateStatus()});
        }
        return builder.build();
    }

    public Object listTxLog(BaseListTxLogParam baseListTxLogParam) {
        ListTxLogParam listTxLogParam = new ListTxLogParam();
        baseTxLogCopier.copy((Object)baseListTxLogParam, (Object)listTxLogParam, null);
        List logInfos = DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).listTxLog(listTxLogParam);
        DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.TimestampType, DataType.TimestampType, DataType.IntegerType, DataType.StringType};
        DataSetBuilder builder = Algo.create((String)"tcc_tx_log").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])listlogFields, (DataType[])dataTypes));
        for (TxLogInfo info : logInfos) {
            if (DtxType.TCC.getCode() == info.getTxType() && ActionType.BRANCH_COMMIT.getCode() == info.getActionType()) {
                info.setActionType(ActionType.BRANCH_COMMIT_TCC.getCode());
            }
            if (DtxType.TCC.getCode() == info.getTxType() && ActionType.BRANCH_ROLLBACK.getCode() == info.getActionType()) {
                info.setActionType(ActionType.BRANCH_ROLLBACK_TCC.getCode());
            }
            builder.append(new Object[]{info.getXid(), info.getActionType(), info.getBranchClazz(), info.getBranchDesc(), info.getBranchXid(), info.getRemark(), info.getTriggerType(), info.getTxDesc(), info.getCreateTime(), info.getUpdatedTime(), info.getResult(), info.getTraceId()});
        }
        return builder.build();
    }

    public List<BaseTxSceneInfo> queryTxSceneInfo() {
        List txSceneInfoList = DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).queryTxSceneInfo();
        ArrayList<BaseTxSceneInfo> baseTxSceneInfoList = new ArrayList<BaseTxSceneInfo>(txSceneInfoList.size());
        for (TxSceneInfo txSceneInfo : txSceneInfoList) {
            BaseTxSceneInfo baseTxSceneInfo = new BaseTxSceneInfo();
            txSceneCopier.copy((Object)txSceneInfo, (Object)baseTxSceneInfo, null);
            baseTxSceneInfoList.add(baseTxSceneInfo);
        }
        return baseTxSceneInfoList;
    }

    public void insertOrUpdateTxSceneInfo(BaseTxSceneInfo baseTxSceneInfo) {
        TxSceneInfo txSceneInfo = new TxSceneInfo();
        baseTxSceneCopier.copy((Object)baseTxSceneInfo, (Object)txSceneInfo, null);
        List baseBranchSceneInfoList = baseTxSceneInfo.getBranchSceneInfoList();
        ArrayList<TxBranchSceneInfo> branchSceneInfoList = null;
        if (baseBranchSceneInfoList != null && !baseBranchSceneInfoList.isEmpty()) {
            branchSceneInfoList = new ArrayList<TxBranchSceneInfo>(baseBranchSceneInfoList.size());
            for (BaseTxBranchSceneInfo baseTxBranchSceneInfo : baseBranchSceneInfoList) {
                TxBranchSceneInfo txBranchSceneInfo = new TxBranchSceneInfo();
                baseTxBranchSceneCopier.copy((Object)baseTxBranchSceneInfo, (Object)txBranchSceneInfo, null);
                branchSceneInfoList.add(txBranchSceneInfo);
            }
        }
        txSceneInfo.setBranchSceneInfoList(branchSceneInfoList);
        DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).insertOrUpdateTxSceneInfo(txSceneInfo);
    }

    public BaseTxSceneInfo getTxSceneInfoById(String id) {
        TxSceneInfo txSceneInfo = DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).getTxSceneInfoById(id);
        BaseTxSceneInfo baseTxSceneInfo = new BaseTxSceneInfo();
        txSceneCopier.copy((Object)txSceneInfo, (Object)baseTxSceneInfo, null);
        List branchSceneInfoList = txSceneInfo.getBranchSceneInfoList();
        ArrayList<BaseTxBranchSceneInfo> baseTxBranchSceneInfoList = null;
        if (branchSceneInfoList != null && !branchSceneInfoList.isEmpty()) {
            baseTxBranchSceneInfoList = new ArrayList<BaseTxBranchSceneInfo>(branchSceneInfoList.size());
            for (TxBranchSceneInfo branchSceneInfo : branchSceneInfoList) {
                BaseTxBranchSceneInfo baseTxBranchSceneInfo = new BaseTxBranchSceneInfo();
                txBranchSceneCopier.copy((Object)branchSceneInfo, (Object)baseTxBranchSceneInfo, null);
                baseTxBranchSceneInfoList.add(baseTxBranchSceneInfo);
            }
        }
        baseTxSceneInfo.setBranchSceneInfoList(baseTxBranchSceneInfoList);
        return baseTxSceneInfo;
    }

    public void unlockBusinessOrder(String xid) {
        DtxCompensate.serviceLookup(AppInfo.APP_ID.getName()).unlockBusinessOrder(xid);
    }

    private Map<String, List<String>> getBusinessIds(List<TxRetryInfo> txRetryInfos) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        if (txRetryInfos == null || txRetryInfos.isEmpty()) {
            return resultMap;
        }
        String sql = "SELECT ctb.fxid as xid, ctb.fbusiness_id as businessId FROM t_cbs_dtx_business ctb WHERE ctb.fxid in (" + this.getParamString(txRetryInfos.size()) + ")  AND (ctb.fbranch_id = ' ' OR ctb .fbranch_id = '')";
        Object[] params = txRetryInfos.stream().map(TxRetryInfo::getXid).toArray();
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            int maxSize = 10;
            while (rs.next()) {
                String xid = rs.getString("xid");
                String businessId = rs.getString("businessId");
                if (resultMap.containsKey(xid)) {
                    if (((List)resultMap.get(xid)).size() >= maxSize) continue;
                    ((List)resultMap.get(xid)).add(businessId);
                    continue;
                }
                ArrayList<String> businessIds = new ArrayList<String>();
                businessIds.add(businessId);
                resultMap.put(xid, businessIds);
            }
            return resultMap;
        });
    }

    private String getParamString(int size) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            stringBuilder.append("?,");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private String getBusinessIdsString(Map<String, List<String>> resultMap, String xid) {
        List<String> businessIds = resultMap.get(xid);
        if (businessIds == null || businessIds.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String businessId : businessIds) {
            stringBuilder.append(businessId).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static DtxTxDispatchService serviceLookup(String appId) {
        DtxTxDispatchService service = null;
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        service = (DtxTxDispatchService)ServiceLookup.lookup(DtxTxDispatchService.class, (String)serviceAppId);
        return service;
    }
}

