/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.kdtx.DtxCompensate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.kdtx.sdk.compensate.Compensate;
import kd.bos.kdtx.sdk.entity.BaseTxBranchSceneInfo;
import kd.bos.kdtx.sdk.entity.BaseTxSceneInfo;

public class DtxSceneConfigFormPlugin
extends AbstractBillPlugIn {
    public static final String SAVE = "save";
    public static final String ENTRYENTITY = "entryentity";
    private static Compensate compensate = DtxSceneConfigFormPlugin.getCompensateImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (SAVE.equals(evt.getItemKey())) {
            IDataModel dataModel = this.getModel();
            String code = (String)dataModel.getValue("code");
            String txDesc = (String)dataModel.getValue("tx_desc");
            String app = (String)dataModel.getValue("app");
            String remark = (String)dataModel.getValue("remark");
            String sceneId = (String)dataModel.getValue("sceneid");
            BaseTxSceneInfo baseTxSceneInfo = new BaseTxSceneInfo();
            baseTxSceneInfo.setCode(code);
            baseTxSceneInfo.setName(txDesc);
            baseTxSceneInfo.setApp(app);
            baseTxSceneInfo.setRemark(remark);
            baseTxSceneInfo.setId(sceneId);
            DynamicObjectCollection items = dataModel.getEntryEntity(ENTRYENTITY);
            if (items != null) {
                ArrayList<BaseTxBranchSceneInfo> baseTxBranchSceneInfoList = new ArrayList<BaseTxBranchSceneInfo>(items.size());
                for (DynamicObject item : items) {
                    String branchCode = item.getString("b_code");
                    String branchDesc = item.getString("b_desc");
                    String branchRemark = item.getString("b_remark");
                    BaseTxBranchSceneInfo branchSceneInfo = new BaseTxBranchSceneInfo();
                    branchSceneInfo.setCode(branchCode);
                    branchSceneInfo.setName(branchDesc);
                    branchSceneInfo.setRemark(branchRemark);
                    baseTxBranchSceneInfoList.add(branchSceneInfo);
                }
                baseTxSceneInfo.setBranchSceneInfoList(baseTxBranchSceneInfoList);
            }
            compensate.insertOrUpdateTxSceneInfo(baseTxSceneInfo);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        if (OperationStatus.EDIT == view.getFormShowParameter().getStatus()) {
            this.loadFormEditData(view, dataModel);
        } else if (OperationStatus.VIEW == view.getFormShowParameter().getStatus()) {
            this.loadFormViewData(view, dataModel);
        }
    }

    private void loadFormViewData(IFormView view, IDataModel dataModel) {
        String itemId = (String)view.getFormShowParameter().getCustomParam("itemId");
        BaseTxSceneInfo txSceneInfo = compensate.getTxSceneInfoById(itemId);
        dataModel.setValue("code", (Object)txSceneInfo.getCode());
        dataModel.setValue("tx_desc", (Object)txSceneInfo.getName());
        dataModel.setValue("app", (Object)txSceneInfo.getApp());
        dataModel.setValue("remark", (Object)txSceneInfo.getRemark());
        dataModel.setValue("sceneid", (Object)itemId);
        List branchSceneInfoList = txSceneInfo.getBranchSceneInfoList();
        int rowCount = branchSceneInfoList.size();
        dataModel.batchCreateNewEntryRow(ENTRYENTITY, rowCount);
        for (int row = 0; row < rowCount; ++row) {
            BaseTxBranchSceneInfo txBranchSceneInfo = (BaseTxBranchSceneInfo)branchSceneInfoList.get(row);
            dataModel.setValue("b_code", (Object)txBranchSceneInfo.getCode(), row);
            TextEdit bCodeEdit = (TextEdit)this.getControl("b_code");
            dataModel.setValue("b_desc", (Object)txBranchSceneInfo.getName(), row);
            TextEdit bDescEdit = (TextEdit)this.getControl("b_desc");
            dataModel.setValue("b_remark", (Object)txBranchSceneInfo.getRemark(), row);
            TextEdit textEdit = (TextEdit)this.getControl("b_remark");
        }
    }

    private void loadFormEditData(IFormView view, IDataModel dataModel) {
        String itemId = (String)view.getFormShowParameter().getCustomParam("itemId");
        BaseTxSceneInfo txSceneInfo = compensate.getTxSceneInfoById(itemId);
        dataModel.setValue("code", (Object)txSceneInfo.getCode());
        TextEdit codeEdit = (TextEdit)this.getControl("code");
        dataModel.setValue("tx_desc", (Object)txSceneInfo.getName());
        dataModel.setValue("app", (Object)txSceneInfo.getApp());
        dataModel.setValue("remark", (Object)txSceneInfo.getRemark());
        dataModel.setValue("sceneid", (Object)itemId);
        List branchSceneInfoList = txSceneInfo.getBranchSceneInfoList();
        int rowCount = branchSceneInfoList.size();
        dataModel.batchCreateNewEntryRow(ENTRYENTITY, rowCount);
        for (int row = 0; row < rowCount; ++row) {
            BaseTxBranchSceneInfo txBranchSceneInfo = (BaseTxBranchSceneInfo)branchSceneInfoList.get(row);
            dataModel.setValue("b_code", (Object)txBranchSceneInfo.getCode(), row);
            dataModel.setValue("b_desc", (Object)txBranchSceneInfo.getName(), row);
            dataModel.setValue("b_remark", (Object)txBranchSceneInfo.getRemark(), row);
        }
    }

    private static Compensate getCompensateImpl() {
        return new DtxCompensate();
    }
}

