/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.reporter;

import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateRangeUtil {
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Log logger = LogFactory.getLog(DateRangeUtil.class);

    public static LocalDate getStartRealTimeDate() {
        Integer days = Integer.getInteger("kdtx.task.expireTime", 15);
        return LocalDate.now().minusDays(days.intValue());
    }

    public static LocalDate getStartArchiveDate() {
        String sql = "select min(farchive_date) as minArchiveDate from t_cbs_dtx_archive";
        LocalDate startDate = LocalDate.now();
        try {
            startDate = (LocalDate)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
                LocalDate localDate = LocalDate.now();
                while (rs.next()) {
                    Date date = rs.getDate("minArchiveDate");
                    if (date == null) continue;
                    localDate = date.toLocalDate();
                }
                return localDate;
            });
        }
        catch (Exception e) {
            logger.error("query min archive date of dtx-reporter is error. ", (Throwable)e);
        }
        return startDate;
    }
}

