/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.reporter;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.cbs.plugin.kdtx.DtxCompensate;
import kd.bos.cbs.plugin.kdtx.reporter.DateRangeUtil;
import kd.bos.cbs.plugin.kdtx.reporter.ReporterListDataPlugin;
import kd.bos.cbs.plugin.kdtx.reporter.entity.ReporterResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.kdtx.sdk.compensate.Compensate;
import kd.bos.kdtx.sdk.entity.BaseTxSceneInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class ReporterFormPlugin
extends AbstractReportFormPlugin {
    private static final Log logger = LogFactory.getLog(ReporterFormPlugin.class);
    private static final Compensate compensate = new DtxCompensate();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener(hyperLinkClickEvent -> {
            IReportView reportView = this.getView();
            Container reportFilter = (Container)this.getControl("reportcommfilterpanelap");
            String reporterType = (String)reportFilter.getModel().getValue("reporter_type");
            String txSceneId = (String)reportFilter.getModel().getValue("tx_scene");
            String txType = (String)reportFilter.getModel().getValue("tx_type");
            java.util.Date startDate = (java.util.Date)reportFilter.getModel().getValue("daterange_startdate");
            java.util.Date endDate = (java.util.Date)reportFilter.getModel().getValue("daterange_enddate");
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject dynamicObject = ((ReportView)reportView).getReportList().getReportModel().getRowData(rowIndex);
            if (txSceneId == null) {
                try {
                    txSceneId = (String)dynamicObject.get("scene_id");
                }
                catch (Exception exception) {
                    logger.error("getting sceneId is failed by hyper click. ERROR INFO: ", (Throwable)exception);
                }
            }
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setFormId("kdtx_detail_reporter");
            reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            reportShowParameter.getCustomParams().put("entityNumber", "kdtx_reporter");
            ReportQueryParam reportQueryParam = new ReportQueryParam();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.addFilterItem("reporter_type", (Object)reporterType);
            filterInfo.addFilterItem("tx_type", (Object)txType);
            filterInfo.addFilterItem("tx_scene", (Object)txSceneId);
            filterInfo.addFilterItem("daterange_startdate", (Object)startDate);
            filterInfo.addFilterItem("daterange_enddate", (Object)endDate);
            filterInfo.addFilterItem("tx_status_type", (Object)hyperLinkClickEvent.getFieldName());
            reportQueryParam.setFilter(filterInfo);
            reportShowParameter.setQueryParam(reportQueryParam);
            reportView.showForm((FormShowParameter)reportShowParameter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit txComboEdit = (ComboEdit)this.getControl("tx_scene");
        List txSceneInfoList = compensate.queryTxSceneInfo();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(txSceneInfoList.size());
        for (BaseTxSceneInfo txSceneInfo : txSceneInfoList) {
            ComboItem comboItem = new ComboItem(new LocaleString(txSceneInfo.getName()), txSceneInfo.getId());
            items.add(comboItem);
        }
        txComboEdit.setComboItems(items);
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("daterange");
        LocalDate localStartDate = DateRangeUtil.getStartRealTimeDate();
        dateRangeEdit.setMinDate((java.util.Date)Date.valueOf(localStartDate));
        dateRangeEdit.setMaxDate(new java.util.Date());
        String startDateString = localStartDate.format(DateRangeUtil.dateTimeFormatter);
        String endDateDateString = LocalDate.now().format(DateRangeUtil.dateTimeFormatter);
        Tips tips = new Tips();
        tips.setType("text");
        String content = String.format(ResManager.loadKDString((String)"\u5b9e\u65f6\u62a5\u8868\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4:%1$s-%2$s\u3002", (String)"ReporterFormPlugin_11", (String)"bos-cbs-plugin", (Object[])new Object[0]), startDateString, endDateDateString);
        tips.setContent(new LocaleString(content));
        dateRangeEdit.addTips(tips);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changedKey = e.getProperty().getName();
        if ("reporter_type".equals(changedKey)) {
            String repoterType = (String)this.getModel().getValue("reporter_type");
            DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("daterange");
            Tips tips = new Tips();
            tips.setType("text");
            if ("history".equals(repoterType)) {
                LocalDate localStartDate = DateRangeUtil.getStartArchiveDate();
                dateRangeEdit.setMinDate((java.util.Date)Date.valueOf(localStartDate));
                dateRangeEdit.setMaxDate((java.util.Date)Date.valueOf(LocalDate.now().minusDays(1L)));
                this.getModel().setValue("tx_type", (Object)"-1");
                String startDateString = localStartDate.format(DateRangeUtil.dateTimeFormatter);
                String endDateDateString = LocalDate.now().minusDays(1L).format(DateRangeUtil.dateTimeFormatter);
                String content = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u62a5\u8868\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4:%1$s-%2$s\u3002", (String)"ReporterFormPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]), startDateString, endDateDateString);
                tips.setContent(new LocaleString(content));
            } else {
                LocalDate localStartDate = DateRangeUtil.getStartRealTimeDate();
                dateRangeEdit.setMinDate((java.util.Date)Date.valueOf(localStartDate));
                dateRangeEdit.setMaxDate(new java.util.Date());
                String startDateString = localStartDate.format(DateRangeUtil.dateTimeFormatter);
                String endDateDateString = LocalDate.now().format(DateRangeUtil.dateTimeFormatter);
                String content = String.format(ResManager.loadKDString((String)"\u5b9e\u65f6\u62a5\u8868\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4:%1$s-%2$s\u3002", (String)"ReporterFormPlugin_11", (String)"bos-cbs-plugin", (Object[])new Object[0]), startDateString, endDateDateString);
                tips.setContent(new LocaleString(content));
            }
            dateRangeEdit.addTips(tips);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String reporterType = queryParam.getFilter().getString("reporter_type");
        String txType = queryParam.getFilter().getString("tx_type");
        if (reporterType.equals("history") && !txType.equals("-1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5386\u53f2\u62a5\u8868\u67e5\u8be2\u6682\u4e0d\u652f\u6301\u4e8b\u52a1\u7c7b\u578b\u8fc7\u6ee4\uff0c\u8bf7\u9009\u62e9\u5168\u90e8\u4e8b\u52a1\u7c7b\u578b\u3002", (String)"ReporterFormPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List reportColumnList = ((ReportList)this.getControl("reportlistap")).getColumns();
        String viewType = queryParam.getFilter().getString("reporter_view");
        String txType = queryParam.getFilter().getString("tx_type");
        String reporterType = queryParam.getFilter().getString("reporter_type");
        if ("sceneview".equals(viewType)) {
            reportColumnList.add(this.createReportColumn("scene_id", ResManager.loadKDString((String)"\u573a\u666fID", (String)"ReporterFormPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, true));
            reportColumnList.add(this.createReportColumn("scene_name", ResManager.loadKDString((String)"\u4e8b\u52a1\u573a\u666f", (String)"ReporterFormPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, false));
        }
        if ("1".equals(txType) || "2".equals(txType)) {
            this.setEcOrMqColumns(reportColumnList);
        }
        if ("0".equals(txType)) {
            this.setTCCColumns(reportColumnList);
        }
        if ("-1".equals(txType)) {
            this.setAllColumns(reportColumnList, reporterType);
        }
        super.beforeQuery(queryParam);
        queryParam.getFilter().addFilterItem("PAGE_ID", (Object)this.getView().getEntityId());
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ReporterResult reporterResult = ReporterListDataPlugin.threadLocal.get();
        String reporterView = queryParam.getFilter().getString("reporter_view");
        this.getView().setVisible(Boolean.valueOf(!"sceneview".equals(reporterView)), new String[]{"cardpanelap"});
        if (reporterResult != null) {
            this.setCardValue(Integer.toString(reporterResult.getTotal()), Integer.toString(reporterResult.getSuccess()), Integer.toString(reporterResult.getAutoRepair()), Integer.toString(reporterResult.getManualRepair()));
        } else {
            this.setCardValue("0", "0", "0", "0");
        }
    }

    private void setCardValue(String total, String success, String autoRepair, String manualRepair) {
        ((Label)this.getControl("total_tag")).setText(total);
        ((Label)this.getControl("success_tag")).setText(success);
        ((Label)this.getControl("auto_repair_tag")).setText(autoRepair);
        ((Label)this.getControl("manual_repair_tag")).setText(manualRepair);
    }

    private void setEcOrMqColumns(List<AbstractReportColumn> reportColumnList) {
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("total", ResManager.loadKDString((String)"\u603b\u4e8b\u52a1\u6570", (String)"ReporterFormPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("success", ResManager.loadKDString((String)"\u6210\u529f\u6570", (String)"ReporterFormPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, false));
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setFieldKey("exception");
        reportColumnGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f02\u5e38\u6570", (String)"ReporterFormPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0])));
        reportColumnGroup.getChildren().add(this.createReportColumn("auto_repair", ResManager.loadKDString((String)"\u81ea\u52a8\u4fee\u590d\u6570", (String)"ReporterFormPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
        reportColumnGroup.getChildren().add(this.createReportColumn("manual_repair", ResManager.loadKDString((String)"\u624b\u52a8\u4fee\u590d\u6570", (String)"ReporterFormPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
        reportColumnGroup.getChildren().add(this.createReportColumn("not_repair", ResManager.loadKDString((String)"\u672a\u4fee\u590d\u6570", (String)"ReporterFormPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
        reportColumnList.add((AbstractReportColumn)reportColumnGroup);
    }

    private void setTCCColumns(List<AbstractReportColumn> reportColumnList) {
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("total", ResManager.loadKDString((String)"\u603b\u4e8b\u52a1\u6570", (String)"ReporterFormPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("success", ResManager.loadKDString((String)"\u6210\u529f\u6570", (String)"ReporterFormPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, false));
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setFieldKey("exception");
        reportColumnGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f02\u5e38\u6570", (String)"ReporterFormPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0])));
        reportColumnGroup.getChildren().add(this.createReportColumn("rollback", ResManager.loadKDString((String)"\u56de\u6eda\u6570", (String)"ReporterFormPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
        reportColumnGroup.getChildren().add(this.createReportColumn("auto_repair", ResManager.loadKDString((String)"\u81ea\u52a8\u4fee\u590d\u6570", (String)"ReporterFormPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
        reportColumnGroup.getChildren().add(this.createReportColumn("manual_repair", ResManager.loadKDString((String)"\u624b\u52a8\u4fee\u590d\u6570", (String)"ReporterFormPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
        reportColumnGroup.getChildren().add(this.createReportColumn("not_repair", ResManager.loadKDString((String)"\u672a\u4fee\u590d\u6570", (String)"ReporterFormPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
        reportColumnList.add((AbstractReportColumn)reportColumnGroup);
    }

    private void setAllColumns(List<AbstractReportColumn> reportColumnList, String reporterType) {
        boolean isHyperlink = reporterType.equals("realtime");
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("total", ResManager.loadKDString((String)"\u603b\u4e8b\u52a1\u6570", (String)"ReporterFormPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("success", ResManager.loadKDString((String)"\u6210\u529f\u6570", (String)"ReporterFormPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), false, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("exception", ResManager.loadKDString((String)"\u5f02\u5e38\u6570", (String)"ReporterFormPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]), isHyperlink, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("rollback", ResManager.loadKDString((String)"\u56de\u6eda\u6570", (String)"ReporterFormPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), isHyperlink, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("auto_repair", ResManager.loadKDString((String)"\u81ea\u52a8\u4fee\u590d\u6570", (String)"ReporterFormPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]), isHyperlink, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("manual_repair", ResManager.loadKDString((String)"\u624b\u52a8\u4fee\u590d\u6570", (String)"ReporterFormPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]), isHyperlink, false));
        reportColumnList.add((AbstractReportColumn)this.createReportColumn("not_repair", ResManager.loadKDString((String)"\u672a\u4fee\u590d\u6570", (String)"ReporterFormPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]), true, false));
    }

    private ReportColumn createReportColumn(String fieldKey, String caption, boolean isHyperlink, boolean isHide) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setFieldType("text");
        reportColumn.setHyperlink(isHyperlink);
        reportColumn.setHide(isHide);
        return reportColumn;
    }
}

