/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.reporter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMetaFactory;
import kd.bos.cbs.plugin.kdtx.DtxCompensate;
import kd.bos.cbs.plugin.kdtx.common.ReporterConstant;
import kd.bos.cbs.plugin.kdtx.reporter.entity.KdtxReporterQueryParam;
import kd.bos.cbs.plugin.kdtx.reporter.entity.ReporterResult;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.eye.api.dtx.sql.CommonSQL;
import kd.bos.eye.api.dtx.sql.HistorySQL;
import kd.bos.eye.api.dtx.sql.SceneViewSQL;
import kd.bos.kdtx.sdk.entity.BaseTxSceneInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ReporterListDataPlugin
extends AbstractReportListDataPlugin {
    private static final String ALOG_KEY = "kdtx_reporter";
    private static final Log logger = LogFactory.getLog(ReporterListDataPlugin.class);
    public static ThreadLocal<ReporterResult> threadLocal = new ThreadLocal();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String viewType = reportQueryParam.getFilter().getString("reporter_view");
        String reporterType = reportQueryParam.getFilter().getString("reporter_type");
        long txSceneId = reportQueryParam.getFilter().getLong("tx_scene");
        int txType = reportQueryParam.getFilter().getInt("tx_type");
        Date startDate = reportQueryParam.getFilter().getDate("daterange_startdate");
        String startDateString = startDate == null ? null : ReporterConstant.DATE_TIME_FORMATTER.format(startDate.toInstant().atZone(ZoneId.systemDefault()));
        Date endDate = reportQueryParam.getFilter().getDate("daterange_enddate");
        String endDateString = endDate == null ? null : ReporterConstant.DATE_TIME_FORMATTER.format(endDate.toInstant().atZone(ZoneId.systemDefault()));
        KdtxReporterQueryParam kdtxReporterQueryParam = new KdtxReporterQueryParam(viewType, txSceneId, txType, reporterType, startDateString, endDateString);
        return this.query0(kdtxReporterQueryParam);
    }

    private DataSet query0(KdtxReporterQueryParam kdtxReporterQueryParam) {
        String viewType = kdtxReporterQueryParam.getViewType();
        int txType = kdtxReporterQueryParam.getTxType();
        String reporterType = kdtxReporterQueryParam.getReporterType();
        DataType[] dataTypes = null;
        DataSetBuilder builder = null;
        if ("overview".equals(viewType)) {
            ReporterResult reporterResult = null;
            reporterResult = "realtime".equals(reporterType) ? this.getReporterResult(kdtxReporterQueryParam) : this.getHistoryReporterResult(kdtxReporterQueryParam);
            if (Integer.toString(txType).equals("-1")) {
                dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
                builder = Algo.create((String)ALOG_KEY).createDataSetBuilder(RowMetaFactory.createRowMeta((String[])ReporterConstant.REPORTER_FIELDS, (DataType[])dataTypes));
                builder.append(new Object[]{reporterResult.getTotal(), reporterResult.getSuccess(), reporterResult.getException(), reporterResult.getRollback(), reporterResult.getAutoRepair(), reporterResult.getManualRepair(), reporterResult.getNotRepair()});
            } else {
                dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
                builder = Algo.create((String)ALOG_KEY).createDataSetBuilder(RowMetaFactory.createRowMeta((String[])ReporterConstant.REPORTER_FIELDS_WITHOUT_EXCEPTION, (DataType[])dataTypes));
                builder.append(new Object[]{reporterResult.getTotal(), reporterResult.getSuccess(), reporterResult.getRollback(), reporterResult.getAutoRepair(), reporterResult.getManualRepair(), reporterResult.getNotRepair()});
            }
            threadLocal.set(reporterResult);
        } else {
            Map<String, String> sceneIdAndCode = this.getSceneIdAndCode();
            Map<String, ReporterResult> sceneViewInfoMap = "realtime".equals(reporterType) ? this.getReporterResultBySceneId(kdtxReporterQueryParam) : this.getHistoryReporterResultBySceneId(kdtxReporterQueryParam);
            if (Integer.toString(txType).equals("-1")) {
                dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
                builder = Algo.create((String)ALOG_KEY).createDataSetBuilder(RowMetaFactory.createRowMeta((String[])ReporterConstant.SCENE_REPORTER_FIELDS, (DataType[])dataTypes));
                for (Map.Entry<String, ReporterResult> entry : sceneViewInfoMap.entrySet()) {
                    String sceneId = entry.getKey();
                    ReporterResult reporterResult = entry.getValue();
                    builder.append(new Object[]{sceneId, sceneIdAndCode.get(sceneId), reporterResult.getTotal(), reporterResult.getSuccess(), reporterResult.getException(), reporterResult.getRollback(), reporterResult.getAutoRepair(), reporterResult.getManualRepair(), reporterResult.getNotRepair()});
                }
            } else {
                dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
                builder = Algo.create((String)ALOG_KEY).createDataSetBuilder(RowMetaFactory.createRowMeta((String[])ReporterConstant.SCENE_REPORTER_FIELDS_WITHOUT_EXCEPTION, (DataType[])dataTypes));
                for (Map.Entry<String, ReporterResult> entry : sceneViewInfoMap.entrySet()) {
                    String sceneId = entry.getKey();
                    ReporterResult reporterResult = entry.getValue();
                    builder.append(new Object[]{sceneId, sceneIdAndCode.get(sceneId), reporterResult.getTotal(), reporterResult.getSuccess(), reporterResult.getRollback(), reporterResult.getAutoRepair(), reporterResult.getManualRepair(), reporterResult.getNotRepair()});
                }
            }
        }
        return builder.build();
    }

    public ReporterResult getReporterResult(KdtxReporterQueryParam kdtxReporterQueryParam) {
        ReporterResult reporterResult = new ReporterResult();
        try {
            Map<String, Object> totalSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_TOTAL_SQL, kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)totalSqlAndParams.get("sql")), (Object[])((Object[])totalSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setTotal(rs.getInt("totals"));
                }
                return null;
            });
            Map<String, Object> successSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_SUCCESS_SQL, kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)successSqlAndParams.get("sql")), (Object[])((Object[])successSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setSuccess(rs.getInt("successes"));
                }
                return null;
            });
            Map<String, Object> rollbackSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_ROLLBACK_SQL, kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)rollbackSqlAndParams.get("sql")), (Object[])((Object[])rollbackSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setRollback(rs.getInt("rollbacks"));
                }
                return null;
            });
            Map<String, Object> exceptionSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_EXCEPTION_SQL, kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)exceptionSqlAndParams.get("sql")), (Object[])((Object[])exceptionSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setException(rs.getInt("exceptions"));
                }
                return null;
            });
            Map<String, Object> autoRepairSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_AUTO_REPAIR_SQL, kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)autoRepairSqlAndParams.get("sql")), (Object[])((Object[])autoRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setAutoRepair(rs.getInt("autoRepairs"));
                }
                return null;
            });
            Map<String, Object> manualRepairSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_MANUAL_REPAIR_SQL, kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)manualRepairSqlAndParams.get("sql")), (Object[])((Object[])manualRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setManualRepair(rs.getInt("manualRepairs"));
                }
                return null;
            });
            Map<String, Object> notRepairSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_NOT_REPAIR_SQL, kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)notRepairSqlAndParams.get("sql")), (Object[])((Object[])notRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setNotRepair(rs.getInt("notRepairs"));
                }
                return null;
            });
            int type = kdtxReporterQueryParam.getTxType();
            if (Integer.parseInt("-1") == type) {
                KdtxReporterQueryParam newParam = KdtxReporterQueryParam.copyFromKdtxReporterQueryParam(kdtxReporterQueryParam);
                newParam.setTxType(0);
                Map<String, Object> ecRollbackSqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_ROLLBACK_SQL, newParam);
                int rollback = (Integer)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)ecRollbackSqlAndParams.get("sql")), (Object[])((Object[])ecRollbackSqlAndParams.get("params")), rs -> {
                    if (rs.next()) {
                        return rs.getInt("rollbacks");
                    }
                    return 0;
                });
                reporterResult.setTotal(reporterResult.getTotal() - (reporterResult.getRollback() - rollback));
                reporterResult.setRollback(rollback);
                return reporterResult;
            }
            if (Integer.parseInt("1") == type || Integer.parseInt("2") == type) {
                reporterResult.setTotal(reporterResult.getTotal() - reporterResult.getRollback());
                reporterResult.setRollback(0);
                return reporterResult;
            }
            return reporterResult;
        }
        catch (Exception e) {
            logger.error("Getting dtx reporter infos. Error: ", (Throwable)e);
            return reporterResult;
        }
    }

    public ReporterResult getHistoryReporterResult(KdtxReporterQueryParam kdtxReporterQueryParam) {
        ReporterResult reporterResult = new ReporterResult();
        try {
            Map<String, Object> tenantViewSqlAndParams = this.getHistoryCompleteSql(HistorySQL.TENANT_VIEW_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)tenantViewSqlAndParams.get("sql")), (Object[])((Object[])tenantViewSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    reporterResult.setTotal(rs.getInt("totals"));
                    reporterResult.setSuccess(rs.getInt("successes"));
                    reporterResult.setException(rs.getInt("exceptions"));
                    reporterResult.setRollback(rs.getInt("rollbacks"));
                    reporterResult.setAutoRepair(rs.getInt("autoRepairs"));
                    reporterResult.setManualRepair(rs.getInt("manualRepairs"));
                    reporterResult.setNotRepair(rs.getInt("notRepairs"));
                }
                return null;
            });
            return reporterResult;
        }
        catch (Exception e) {
            logger.error("Getting history dtx reporter infos. Error: ", (Throwable)e);
            return reporterResult;
        }
    }

    public Map<String, ReporterResult> getReporterResultBySceneId(KdtxReporterQueryParam kdtxReporterQueryParam) {
        HashMap<String, ReporterResult> sceneViewInfoMap = new HashMap<String, ReporterResult>();
        try {
            Map<String, Object> totalSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_TOTAL_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)totalSqlAndParams.get("sql")), (Object[])((Object[])totalSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    int totals = rs.getInt("totals");
                    if (totals == 0) continue;
                    ReporterResult reporterResult = new ReporterResult();
                    reporterResult.setTotal(totals);
                    reporterResult.setSceneId(sceneId);
                    sceneViewInfoMap.put(sceneId, reporterResult);
                }
                return null;
            });
            Map<String, Object> successSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_SUCCESS_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)successSqlAndParams.get("sql")), (Object[])((Object[])successSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    ReporterResult reporterResult = (ReporterResult)sceneViewInfoMap.get(sceneId);
                    if (reporterResult == null) continue;
                    reporterResult.setSuccess(rs.getInt("successes"));
                }
                return null;
            });
            Map<String, Object> rollbackSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_ROLLBACK_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)rollbackSqlAndParams.get("sql")), (Object[])((Object[])rollbackSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    ReporterResult reporterResult = (ReporterResult)sceneViewInfoMap.get(sceneId);
                    if (reporterResult == null) continue;
                    reporterResult.setRollback(rs.getInt("rollbacks"));
                }
                return null;
            });
            Map<String, Object> exceptionSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_EXCEPTION_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)exceptionSqlAndParams.get("sql")), (Object[])((Object[])exceptionSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    ReporterResult reporterResult = (ReporterResult)sceneViewInfoMap.get(sceneId);
                    if (reporterResult == null) continue;
                    reporterResult.setException(rs.getInt("exceptions"));
                }
                return null;
            });
            Map<String, Object> autoRepairSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_AUTO_REPAIR_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)autoRepairSqlAndParams.get("sql")), (Object[])((Object[])autoRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    ReporterResult reporterResult = (ReporterResult)sceneViewInfoMap.get(sceneId);
                    if (reporterResult == null) continue;
                    reporterResult.setAutoRepair(rs.getInt("autoRepairs"));
                }
                return null;
            });
            Map<String, Object> manualRepairSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_MANUAL_REPAIR_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)manualRepairSqlAndParams.get("sql")), (Object[])((Object[])manualRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    ReporterResult reporterResult = (ReporterResult)sceneViewInfoMap.get(sceneId);
                    if (reporterResult == null) continue;
                    reporterResult.setManualRepair(rs.getInt("manualRepairs"));
                }
                return null;
            });
            Map<String, Object> notRepairSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_NOT_REPAIR_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)notRepairSqlAndParams.get("sql")), (Object[])((Object[])notRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    ReporterResult reporterResult = (ReporterResult)sceneViewInfoMap.get(sceneId);
                    if (reporterResult == null) continue;
                    reporterResult.setNotRepair(rs.getInt("notRepairs"));
                }
                return null;
            });
            KdtxReporterQueryParam newParam = KdtxReporterQueryParam.copyFromKdtxReporterQueryParam(kdtxReporterQueryParam);
            newParam.setTxType(0);
            ArrayList tccScenes = new ArrayList();
            Map<String, Object> tccRollbackSqlAndParams = this.getSceneViewCompleteSql(SceneViewSQL.QUERY_ROLLBACK_SQL.getSql(), newParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)tccRollbackSqlAndParams.get("sql")), (Object[])((Object[])tccRollbackSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    tccScenes.add(sceneId);
                }
                return null;
            });
            for (Map.Entry entry : sceneViewInfoMap.entrySet()) {
                ReporterResult reporterResult = (ReporterResult)entry.getValue();
                if (tccScenes.contains(reporterResult.getSceneId())) continue;
                reporterResult.setTotal(reporterResult.getTotal() - reporterResult.getRollback());
                reporterResult.setRollback(0);
            }
        }
        catch (Exception e) {
            logger.error("Getting dtx sceneView infos. Error: ", (Throwable)e);
        }
        return sceneViewInfoMap;
    }

    public Map<String, ReporterResult> getHistoryReporterResultBySceneId(KdtxReporterQueryParam kdtxReporterQueryParam) {
        HashMap<String, ReporterResult> sceneViewInfoMap = new HashMap<String, ReporterResult>();
        try {
            Map<String, Object> sceneViewSqlAndParams = this.getHistoryCompleteSql(HistorySQL.SCENE_VIEW_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)sceneViewSqlAndParams.get("sql")), (Object[])((Object[])sceneViewSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    ReporterResult reporterResult = new ReporterResult();
                    reporterResult.setTotal(rs.getInt("totals"));
                    reporterResult.setSuccess(rs.getInt("successes"));
                    reporterResult.setException(rs.getInt("exceptions"));
                    reporterResult.setRollback(rs.getInt("rollbacks"));
                    reporterResult.setAutoRepair(rs.getInt("autoRepairs"));
                    reporterResult.setManualRepair(rs.getInt("manualRepairs"));
                    reporterResult.setNotRepair(rs.getInt("notRepairs"));
                    sceneViewInfoMap.put(sceneId, reporterResult);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Getting dtx history sceneView infos. Error: ", (Throwable)e);
        }
        return sceneViewInfoMap;
    }

    public static Map<String, Object> getCompleteSql(CommonSQL sql, KdtxReporterQueryParam kdtxReporterQueryParam) {
        HashMap<String, Object> completeResult = new HashMap<String, Object>();
        StringBuilder whereSql = new StringBuilder(sql.getSql());
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        long sceneId = kdtxReporterQueryParam.getTxSceneId();
        int type = kdtxReporterQueryParam.getTxType();
        String startDate = kdtxReporterQueryParam.getStartDate();
        String endDate = kdtxReporterQueryParam.getEndDate();
        if (sceneId != 0L) {
            whereSql.append(" and t.fscenes_tx_id = ?");
            params.add(Long.valueOf(sceneId));
        }
        if (type != -1) {
            whereSql.append(" and t.ftx_type = ?");
            params.add(Integer.valueOf(type));
        } else if (sql == CommonSQL.QUERY_ROLLBACK_INFO_SQL) {
            whereSql.append(" and t.ftx_type = ?");
            params.add(Integer.valueOf(0));
        }
        if (startDate != null && endDate != null) {
            whereSql.append(" and (t.fcreate_time >= ?").append(" and t.fcreate_time < ?)");
            params.add(LocalDate.parse(startDate));
            params.add(LocalDate.parse(endDate).plusDays(1L));
        }
        completeResult.put("sql", whereSql.toString());
        completeResult.put("params", params.toArray());
        return completeResult;
    }

    public Map<String, Object> getSceneViewCompleteSql(String sql, KdtxReporterQueryParam kdtxReporterQueryParam) {
        HashMap<String, Object> completeResult = new HashMap<String, Object>();
        StringBuilder whereSql = new StringBuilder();
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        long sceneId = kdtxReporterQueryParam.getTxSceneId();
        String startDate = kdtxReporterQueryParam.getStartDate();
        String endDate = kdtxReporterQueryParam.getEndDate();
        int type = kdtxReporterQueryParam.getTxType();
        if (sceneId != 0L) {
            whereSql.append(" and t.fscenes_tx_id = ?");
            params.add(Long.valueOf(sceneId));
        }
        if (type != -1) {
            whereSql.append(" and t.ftx_type = ?");
            params.add(Integer.valueOf(type));
        }
        if (startDate != null && endDate != null) {
            whereSql.append(" and (t.fcreate_time >= ?").append(" and t.fcreate_time < ?)");
            params.add(LocalDate.parse(startDate));
            params.add(LocalDate.parse(endDate).plusDays(1L));
        }
        completeResult.put("sql", String.format(sql, whereSql));
        completeResult.put("params", params.toArray());
        return completeResult;
    }

    public Map<String, Object> getHistoryCompleteSql(String sql, KdtxReporterQueryParam kdtxReporterQueryParam) {
        HashMap<String, Object> completeResult = new HashMap<String, Object>();
        StringBuilder whereSql = new StringBuilder();
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        long sceneId = kdtxReporterQueryParam.getTxSceneId();
        String startDate = kdtxReporterQueryParam.getStartDate();
        String endDate = kdtxReporterQueryParam.getEndDate();
        if (sceneId != 0L) {
            whereSql.append(" and t.fscenes_tx_id = ?");
            params.add(Long.valueOf(sceneId));
        }
        if (startDate != null && endDate != null) {
            whereSql.append(" and (t.farchive_date >= ?").append(" and t.farchive_date < ?)");
            params.add(LocalDate.parse(startDate));
            params.add(LocalDate.parse(endDate).plusDays(1L));
        }
        completeResult.put("sql", String.format(sql, whereSql));
        completeResult.put("params", params.toArray());
        return completeResult;
    }

    private Map<String, String> getSceneIdAndCode() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        List<BaseTxSceneInfo> txSceneInfoList = new DtxCompensate().queryTxSceneInfo();
        for (BaseTxSceneInfo baseTxSceneInfo : txSceneInfoList) {
            map.put(baseTxSceneInfo.getId(), baseTxSceneInfo.getCode());
        }
        return map;
    }
}

