/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.reporter;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMetaFactory;
import kd.bos.cbs.plugin.kdtx.common.TXDetailReporterConstant;
import kd.bos.cbs.plugin.kdtx.reporter.ReporterListDataPlugin;
import kd.bos.cbs.plugin.kdtx.reporter.entity.KdtxReporterQueryParam;
import kd.bos.cbs.plugin.kdtx.reporter.entity.TXDetailResult;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.eye.api.dtx.sql.CommonSQL;
import kd.bos.eye.api.dtx.sql.HistorySQL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TXDetailReporterListDataPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(TXDetailReporterListDataPlugin.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String reporterType = reportQueryParam.getFilter().getString("reporter_type");
        long txSceneId = reportQueryParam.getFilter().getLong("tx_scene");
        int txType = reportQueryParam.getFilter().getInt("tx_type");
        String txStatusType = reportQueryParam.getFilter().getString("tx_status_type");
        Date startDate = reportQueryParam.getFilter().getDate("daterange_startdate");
        Date endDate = reportQueryParam.getFilter().getDate("daterange_enddate");
        String startDateString = startDate == null ? null : TXDetailReporterConstant.DATE_TIME_FORMATTER.format(startDate.toInstant().atZone(ZoneId.systemDefault()));
        String endDateString = endDate == null ? null : TXDetailReporterConstant.DATE_TIME_FORMATTER.format(endDate.toInstant().atZone(ZoneId.systemDefault()));
        KdtxReporterQueryParam kdtxReporterQueryParam = new KdtxReporterQueryParam(txSceneId, txType, reporterType, startDateString, endDateString, txStatusType);
        return this.query0(kdtxReporterQueryParam);
    }

    private DataSet query0(KdtxReporterQueryParam kdtxReporterQueryParam) {
        String reporterType = kdtxReporterQueryParam.getReporterType();
        DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.TimestampType};
        DataSetBuilder builder = Algo.create((String)"reporter").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])TXDetailReporterConstant.REPORTER_FIELDS, (DataType[])dataTypes));
        List<TXDetailResult> TXDetailResults = reporterType.equals("realtime") ? this.getRealTimeNoSuccessInfo(kdtxReporterQueryParam) : this.getHistoryNoSuccessInfo(kdtxReporterQueryParam);
        for (TXDetailResult TXDetailResult2 : TXDetailResults) {
            builder.append(new Object[]{TXDetailResult2.getXid(), TXDetailResult2.getSceneName(), TXDetailResult2.getCreateTime()});
        }
        return builder.build();
    }

    private List<TXDetailResult> getRealTimeNoSuccessInfo(KdtxReporterQueryParam kdtxReporterQueryParam) {
        ArrayList<TXDetailResult> TXDetailResults = new ArrayList<TXDetailResult>();
        try {
            Map<String, Object> sqlAndParams = this.chooseSqlByTxStatusType(kdtxReporterQueryParam);
            if (sqlAndParams == null) {
                throw new NullPointerException("getting query sql by params is error.");
            }
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)sqlAndParams.get("sql")), (Object[])((Object[])sqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    TXDetailResult TXDetailResult2 = new TXDetailResult();
                    TXDetailResult2.setXid(rs.getString("xid"));
                    TXDetailResult2.setSceneName(rs.getString("sceneName"));
                    TXDetailResult2.setCreateTime(rs.getTimestamp("createTime"));
                    TXDetailResults.add(TXDetailResult2);
                }
                return null;
            });
            return TXDetailResults;
        }
        catch (Exception e) {
            logger.error("Getting dtx no sucess tx info. Error: ", (Throwable)e);
            return TXDetailResults;
        }
    }

    private List<TXDetailResult> getHistoryNoSuccessInfo(KdtxReporterQueryParam kdtxReporterQueryParam) {
        ArrayList<TXDetailResult> TXDetailResults = new ArrayList<TXDetailResult>();
        try {
            Map<String, Object> notRepairSqlAndParams = new ReporterListDataPlugin().getHistoryCompleteSql(HistorySQL.NOT_REPAIR_SQL.getSql(), kdtxReporterQueryParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)notRepairSqlAndParams.get("sql")), (Object[])((Object[])notRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    TXDetailResult TXDetailResult2 = new TXDetailResult();
                    TXDetailResult2.setXid(rs.getString("xid"));
                    TXDetailResult2.setSceneName(rs.getString("sceneName"));
                    TXDetailResult2.setCreateTime(rs.getTimestamp("createTime"));
                    TXDetailResults.add(TXDetailResult2);
                }
                return null;
            });
            return TXDetailResults;
        }
        catch (Exception e) {
            logger.error("Getting history not repaired transaction infos. Error: ", (Throwable)e);
            return TXDetailResults;
        }
    }

    private Map<String, Object> chooseSqlByTxStatusType(KdtxReporterQueryParam kdtxReporterQueryParam) {
        String txStatusType;
        Map<String, Object> sqlAndParams = null;
        switch (txStatusType = kdtxReporterQueryParam.getTxStatusType()) {
            case "exception": {
                sqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_EXCEPTION_INFO_SQL, kdtxReporterQueryParam);
                break;
            }
            case "rollback": {
                sqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_ROLLBACK_INFO_SQL, kdtxReporterQueryParam);
                break;
            }
            case "auto_repair": {
                sqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_AUTO_REPAIR_INFO_SQL, kdtxReporterQueryParam);
                break;
            }
            case "manual_repair": {
                sqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_MANUAL_REPAIR_INFO_SQL, kdtxReporterQueryParam);
                break;
            }
            case "not_repair": {
                sqlAndParams = ReporterListDataPlugin.getCompleteSql(CommonSQL.QUERY_NOT_REPAIR_INFO_SQL, kdtxReporterQueryParam);
            }
        }
        return sqlAndParams;
    }
}

