/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.rpt;

import java.sql.ResultSet;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.kdtx.rpt.DtxCompensateStrategyListPugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;

public class DtxCompensateStrategyGridPlugin
extends AbstractBillPlugIn {
    private static final String PATTER = "\\d+;(\\d+:\\d+,?)+";
    private static final String TOTAL_DAYS_KEY = "total_days";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String[] KEY_ENTRYFIELD = new String[]{"day", "retry_count"};
    private static final String BTN_SAVE = "save";
    private static final String CUSTOM_TYPE = "1";
    private static final String DECLINE_TYPE = "2";
    private static final String FIRST_RETRY_COUNT = "first_retry_count";
    private static final String DAY_DECLINE_COUNT = "day_decline_count";
    private static final String MIN_RETRY_COUNT = "min_retry_count";
    private static final String TYPE = "type";
    private static final String EXPRESS = "express";
    private static final String NUMBER = "number";
    private static final String DAY = "day";
    private static final String RETRY_COUNT = "retry_count";
    private static final String BTN_DELETE = "delete";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        String type = (String)this.getModel().getValue(TYPE);
        if (type.equals(CUSTOM_TYPE) && TOTAL_DAYS_KEY.equals(fieldKey)) {
            int value = (Integer)e.getChangeSet()[0].getNewValue();
            this.changeEntryEntity(value);
        } else if (type.equals(DECLINE_TYPE) && (TOTAL_DAYS_KEY.equals(fieldKey) || FIRST_RETRY_COUNT.equals(fieldKey) || DAY_DECLINE_COUNT.equals(fieldKey) || MIN_RETRY_COUNT.equals(fieldKey))) {
            int totalDays = (Integer)this.getModel().getValue(TOTAL_DAYS_KEY);
            int firstRetryCount = (Integer)this.getModel().getValue(FIRST_RETRY_COUNT);
            int dayDeclineCount = (Integer)this.getModel().getValue(DAY_DECLINE_COUNT);
            int minRetryCount = (Integer)this.getModel().getValue(MIN_RETRY_COUNT);
            if (totalDays > 0 && firstRetryCount > 0) {
                this.changeExpress(totalDays, firstRetryCount, dayDeclineCount, minRetryCount);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        FieldEdit edit = (FieldEdit)this.getView().getControl(FIRST_RETRY_COUNT);
        edit.setMustInput(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        IDataModel dataModel = this.getModel();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String type = (String)dataModel.getValue(TYPE);
        String code = (String)dataModel.getValue(NUMBER);
        int totalDays = (Integer)dataModel.getValue(TOTAL_DAYS_KEY);
        if (BTN_SAVE.equals(operateKey)) {
            if (operationStatus.equals((Object)OperationStatus.ADDNEW) && this.existCode(code)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u8bd5\u7b56\u7565\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"DTXTxCompensateListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (CUSTOM_TYPE.equals(type)) {
                DynamicObjectCollection collection = dataModel.getEntryEntity(KEY_ENTRYENTITY);
                if (collection.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b56\u7565\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DTXTxCompensateListPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                StringBuilder builder = new StringBuilder();
                builder.append(totalDays).append(";");
                for (int i = 0; i < collection.size(); ++i) {
                    int day = ((DynamicObject)collection.get(i)).getInt(DAY);
                    int count = ((DynamicObject)collection.get(i)).getInt(RETRY_COUNT);
                    builder.append(day).append(":").append(count);
                    if (i == collection.size() - 1) continue;
                    builder.append(",");
                }
                this.getModel().setValue(EXPRESS, (Object)builder.toString());
            } else if (DECLINE_TYPE.equals(type)) {
                String express = (String)this.getModel().getValue(EXPRESS);
                if (StringUtils.isEmpty((CharSequence)express)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u91cd\u8bd5\u5929\u6570\u3001\u7b2c\u4e00\u6b21\u91cd\u8bd5\u6b21\u6570\u662f\u5426\u586b\u5199\u5b8c\u6574\u3002", (String)"DTXTxCompensateListPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!express.matches(PATTER)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DTXTxCompensateListPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Long id = (Long)this.getModel().getValue("id");
        if (BTN_SAVE.equals(operateKey)) {
            DtxCompensateStrategyListPugin.updateAssignedTarget(new Object[]{id});
        } else if (BTN_DELETE.equals(operateKey)) {
            DtxCompensateStrategyListPugin.deleteAssignedTarget(new Object[]{id});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private boolean existCode(String code) {
        String sql = "select fid from t_cbs_dtx_retry_strategy where fcode = ?";
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{code}, ResultSet::next);
    }

    private void changeEntryEntity(int num) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(KEY_ENTRYENTITY);
        dataModel.batchCreateNewEntryRow(KEY_ENTRYENTITY, num);
        for (int i = 0; i < num; ++i) {
            dataModel.setValue(KEY_ENTRYFIELD[0], (Object)(i + 1), i);
            dataModel.setValue(KEY_ENTRYFIELD[1], (Object)1, i);
        }
    }

    private void changeExpress(int totalDays, int firstRetryCount, int dayDeclineCount, int minRetryCount) {
        StringBuilder builder = new StringBuilder();
        builder.append(totalDays).append(";");
        for (int i = 1; i <= totalDays; ++i) {
            builder.append(i).append(":").append(firstRetryCount > minRetryCount ? firstRetryCount : minRetryCount);
            firstRetryCount -= dayDeclineCount;
            if (i == totalDays) continue;
            builder.append(",");
        }
        this.getModel().setValue(EXPRESS, (Object)builder.toString());
    }
}

