/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.rpt;

import java.util.ArrayList;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.kdtx.rpt.DtxCompensateStrategyNotifier;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;

public class DtxCompensateStrategyListPugin
extends AbstractListPlugin {
    private static final String BTN_DELETE = "delete";
    public static final String NEW = "new";
    public static final String DTX_COMPENSATE_STRATEGY = "dtx_compensate_strategy";
    public static final String WIDTH = "800";
    public static final String HEIGHT = "600";
    public static final String NUMBER = "number";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if (NEW.equals(operateKey)) {
            args.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(DTX_COMPENSATE_STRATEGY);
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth(WIDTH);
            styleCss.setHeight(HEIGHT);
            billShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (NUMBER.equals(args.getFieldName()) && args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            args.setCancel(true);
            BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            String formId = billList.getBillFormId();
            Object pkId = linkClickEvent.getCurrentRow().getPrimaryKeyValue();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.setPkId(pkId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            if (showParameter.getFormConfig() == null) {
                showParameter.setFormConfig(FormMetadataCache.getFormConfig((String)formId));
            }
            showParameter.getFormConfig().setHeight(new LocaleString(HEIGHT));
            showParameter.getFormConfig().setWidth(new LocaleString(WIDTH));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        super.afterDoOperation(ae);
        String operateKey = ae.getOperateKey();
        if (BTN_DELETE.equals(operateKey)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            Object[] primaryKeys = selectedRows.getPrimaryKeyValues();
            DtxCompensateStrategyListPugin.deleteAssignedTarget(primaryKeys);
        }
    }

    public static void deleteAssignedTarget(Object[] primaryKeys) {
        SqlBuilder queryDeletedAssignSceneSql = new SqlBuilder();
        queryDeletedAssignSceneSql.append("select ftarget_id from t_cbs_dtx_retry_assign where", new Object[0]);
        queryDeletedAssignSceneSql.appendIn("fstrategy_id", primaryKeys);
        ArrayList<Long> deleteISceneId = new ArrayList<Long>();
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)queryDeletedAssignSceneSql, rs -> {
            while (rs.next()) {
                deleteISceneId.add(rs.getLong(1));
            }
            return null;
        });
        SqlBuilder deleteSql = new SqlBuilder();
        deleteSql.append("delete from t_cbs_dtx_retry_assign where", new Object[0]);
        deleteSql.appendIn("fstrategy_id", primaryKeys);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                boolean count = DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)deleteSql);
                if (count) {
                    DtxCompensateStrategyNotifier.notifyScheduleTask(null, deleteISceneId);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    public static void updateAssignedTarget(Object[] primaryKeys) {
        SqlBuilder queryNeedUpdateTarget = new SqlBuilder();
        queryNeedUpdateTarget.append("select ftarget_id from t_cbs_dtx_retry_assign where", new Object[0]);
        queryNeedUpdateTarget.appendIn("fstrategy_id", primaryKeys);
        ArrayList<Long> needUpdateSceneId = new ArrayList<Long>();
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)queryNeedUpdateTarget, rs -> {
            while (rs.next()) {
                needUpdateSceneId.add(rs.getLong(1));
            }
            return null;
        });
        DtxCompensateStrategyNotifier.notifyScheduleTask(null, needUpdateSceneId);
    }
}

