/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.rpt;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.cbs.plugin.kdtx.rpt.DtxCompensateStrategyNotifier;
import kd.bos.cbs.plugin.tools.OperationLogUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.AssignType;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DtxStrategyAssignScenePlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(DtxStrategyAssignScenePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String code = (String)this.getView().getFormShowParameter().getCustomParam("strategy_code");
        String scenes = (String)this.getView().getFormShowParameter().getCustomParam("assign_target");
        String initDesc = BosRes.get((String)"bos-cbs-plugin", (String)"DTXTxCompensateListPlugin_14", (String)"\u672a\u5206\u914d", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)scenes) && !initDesc.equals(scenes)) {
            String sceneIds = this.getAssignedScenes(scenes);
            this.getModel().setValue("scenes", (Object)this.toObjectArray(sceneIds));
            this.getView().getPageCache().put("oldSceneIds", sceneIds);
        }
        this.getModel().setValue("strategy_code", (Object)code);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)source.getKey())) {
            String strategyCode = (String)this.getModel().getValue("strategy_code");
            long strategyId = this.getStrategyId(strategyCode);
            if (strategyId == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u7b56\u7565\u7f16\u7801[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DTXTxCompensateListPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[]{strategyCode}));
                return;
            }
            String oldSceneIdStr = this.getView().getPageCache().get("oldSceneIds");
            Long[] oldSceneIds = StringUtils.isNotEmpty((CharSequence)oldSceneIdStr) ? this.toLongArray(oldSceneIdStr) : null;
            MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("scenes");
            ArrayList<Long> sceneIds = new ArrayList<Long>();
            HashMap<Long, String> newSceneIds = new HashMap<Long, String>();
            ArrayList<Long> deleteIds = new ArrayList<Long>();
            ArrayList<Long> insertIds = new ArrayList<Long>();
            if (!mulBasedataDynamicObjectCollection.isEmpty()) {
                for (DynamicObject dynamicObject : mulBasedataDynamicObjectCollection) {
                    DynamicObject basedataObj = (DynamicObject)dynamicObject.get("fbasedataid");
                    String sceneCode = (String)basedataObj.get("code");
                    long sceneId = (Long)basedataObj.get("id");
                    newSceneIds.put(sceneId, sceneCode);
                    sceneIds.add(sceneId);
                }
                if (oldSceneIds != null) {
                    for (int i = 0; i < oldSceneIds.length; ++i) {
                        if (newSceneIds.containsKey(oldSceneIds[i])) continue;
                        deleteIds.add(oldSceneIds[i]);
                    }
                }
                for (Long newSceneId : sceneIds) {
                    boolean insert = true;
                    if (oldSceneIds != null) {
                        for (int i = 0; i < oldSceneIds.length; ++i) {
                            if (!newSceneId.equals(oldSceneIds[i])) continue;
                            insert = false;
                            break;
                        }
                    }
                    if (!insert) continue;
                    insertIds.add(newSceneId);
                }
                for (Long sceneId : insertIds) {
                    if (!this.alreadyAssign(sceneId)) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u573a\u666f[%s]\u5df2\u5206\u914d\u8fc7\u7b56\u7565\uff0c\u8bf7\u52ff\u91cd\u590d\u5206\u914d\u3002", (String)"DTXTxCompensateListPlugin_11", (String)"bos-cbs-plugin", (Object[])new Object[]{newSceneIds.get(sceneId)}));
                    return;
                }
            } else if (oldSceneIds != null && oldSceneIds.length != 0) {
                deleteIds.addAll(Arrays.asList(oldSceneIds));
            }
            try {
                this.doOperator(strategyId, insertIds, deleteIds);
                this.writeLog(String.format(ResManager.loadKDString((String)"\u7b56\u7565[%1$s]\u5206\u914d\u6210\u529f:\u5206\u914d\u81f3\u573a\u666f%2$s,\u573a\u666f%3$s\u53d6\u6d88\u5206\u914d\u3002", (String)"DTXTxCompensateListPlugin_16", (String)"bos-cbs-plugin", (Object[])new Object[0]), strategyCode, insertIds, deleteIds), source.getKey());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            IFormView parentView = this.getView().getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"DTXTxCompensateListPlugin_12", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            this.getView().invokeOperation("close");
        }
    }

    private void doOperator(long strategyId, List<Long> insertIds, List<Long> deleteIds) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.batchDelete(strategyId, deleteIds);
                this.batchSave(strategyId, insertIds);
                DtxCompensateStrategyNotifier.notifyScheduleTask(insertIds, deleteIds);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25,\u8bf7\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"DTXTxCompensateListPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]), e);
            }
        }
    }

    private void writeLog(String desc, String operateKey) {
        MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "DTXTxCompensateListPlugin_22", "bos-cbs-plugin");
        OpLogAppInfo opLogAppInfo = OperationLogUtil.buildLogInfo(desc, 0L, operateKey, this.getView(), langEnumBridge);
        OperationLogUtil.writeLog(Collections.singletonList(opLogAppInfo));
    }

    private void batchSave(long strategyId, List<Long> sceneIds) {
        if (sceneIds != null && sceneIds.size() > 0) {
            String insertSql = "insert into t_cbs_dtx_retry_assign(fid,fstrategy_id,ftarget_id,fassign_type) values(?,?,?,?)";
            ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(2);
            for (long sceneId : sceneIds) {
                insertParamsList.add(new Object[]{ID.genLongId(), strategyId, sceneId, AssignType.ASSIGN_SCENE.getCode()});
            }
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParamsList);
        }
    }

    private void batchDelete(long strategyId, List<Long> sceneIds) {
        if (sceneIds != null && sceneIds.size() > 0) {
            String deleteSql = "delete from t_cbs_dtx_retry_assign where fassign_type=? and fstrategy_id=? and ftarget_id=?";
            ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(2);
            for (long sceneId : sceneIds) {
                insertParamsList.add(new Object[]{AssignType.ASSIGN_SCENE.getCode(), strategyId, sceneId});
            }
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, insertParamsList);
        }
    }

    private long getStrategyId(String strategyCode) {
        return (Long)DB.query((DBRoute)DBRoute.basedata, (String)"select fid from t_cbs_dtx_retry_strategy where fcode=?", (Object[])new Object[]{strategyCode}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    private String getAssignedScenes(String scenesCodes) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_cbs_dtx_tx_scenes where", new Object[0]);
        sql.appendIn("fcode", Arrays.asList(scenesCodes.split(";")));
        return (String)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sql, rs -> {
            StringBuilder builder = new StringBuilder();
            while (rs.next()) {
                builder.append(rs.getLong(1));
                builder.append(";");
            }
            String ids = builder.toString();
            if (ids.endsWith(";")) {
                ids = ids.substring(0, ids.length() - 1);
            }
            return ids;
        });
    }

    private Object[] toObjectArray(String sceneIds) {
        String[] ids;
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (String id : ids = sceneIds.split(";")) {
            list.add(Long.parseLong(id));
        }
        return list.toArray();
    }

    private Long[] toLongArray(String sceneIds) {
        String[] ids;
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (String id : ids = sceneIds.split(";")) {
            list.add(Long.parseLong(id));
        }
        return list.toArray(new Long[list.size()]);
    }

    private boolean alreadyAssign(long sceneId) {
        String sql = "select fid from t_cbs_dtx_retry_assign where ftarget_id = ? and fassign_type=0";
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{sceneId}, ResultSet::next);
    }
}

