/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.rpt;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMetaFactory;
import kd.bos.cbs.plugin.kdtx.common.Constant;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.kdtx.common.constant.AppInfo;
import kd.bos.kdtx.common.entity.BusinessEntryInfo;
import kd.bos.kdtx.common.param.BusinessParam;
import kd.bos.kdtx.common.service.DtxTxDispatchService;
import kd.bos.service.lookup.ServiceLookup;

public class TxBusinessListDataPlugin
extends AbstractReportListDataPlugin {
    private static String[] listFields = new String[]{"xid", "branch_xid", "business_type", "business_id", "create_time"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        if (!Constant.isTccApp()) {
            DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.TimestampType};
            DataSetBuilder builder = Algo.create((String)"kdtx_business_info").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])listFields, (DataType[])dataTypes));
            return builder.build();
        }
        int limitSize = reportQueryParam.getFilter().getInt("search_limit_size");
        String xid = reportQueryParam.getFilter().getString("search_xid");
        String businessType = reportQueryParam.getFilter().getString("search_business_type");
        String businessId = reportQueryParam.getFilter().getString("search_business_id");
        Date startTimeFrom = reportQueryParam.getFilter().getDate("search_start_time");
        Date startTimeTo = reportQueryParam.getFilter().getDate("search_end_time");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTimeFromStr = null;
        String startTimeToStr = null;
        if (startTimeFrom != null) {
            startTimeFromStr = sdf.format(startTimeFrom);
        }
        if (startTimeTo != null) {
            startTimeToStr = sdf.format(startTimeTo);
        }
        return this.getBusinessInfo(xid, businessType, businessId, startTimeFromStr, startTimeToStr, limitSize);
    }

    public DataSet getBusinessInfo(String xid, String businessType, String businessId, String startTime, String endTime, int limitSize) {
        String serviceAppId = ServiceLookup.getServiceAppId((String)AppInfo.APP_ID.getName());
        DtxTxDispatchService dtxTxDispatchService = (DtxTxDispatchService)ServiceLookup.lookup(DtxTxDispatchService.class, (String)serviceAppId);
        BusinessParam param = new BusinessParam();
        param.setXid(xid);
        param.setBusinessType(businessType);
        param.setBusinessId(businessId);
        param.setCreateTimeFrom(startTime);
        param.setCreateTimeTo(endTime);
        param.setLimitSize(limitSize);
        List businessEntryInfos = dtxTxDispatchService.queryBusinessEntry(param);
        DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.TimestampType};
        DataSetBuilder builder = Algo.create((String)"kdtx_business_info").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])listFields, (DataType[])dataTypes));
        for (BusinessEntryInfo entry : businessEntryInfos) {
            builder.append(new Object[]{entry.getXid(), entry.getBranchId(), entry.getBusinessType(), entry.getBusinessId(), entry.getCreateTime()});
        }
        return builder.build();
    }
}

