/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.logorm;

import java.util.Map;
import kd.bos.cbs.plugin.logorm.DataSourceRoute;
import kd.bos.cbs.plugin.logorm.ElasticDisposableDataSource;
import kd.bos.context.RequestContext;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.exception.LogORMExceptionFactory;
import kd.bos.logorm.impl.DataEntityMetaProvider;
import org.apache.http.HttpHost;

public class ElasticMonitorQueryBuilder {
    private final DataSourceRoute dataSourceRoute;
    private final RequestContext rc;
    private final boolean queryIndex;
    private final boolean queryArchiveIndex;
    private final ElasticDisposableDataSource dataSource;
    private final String esConfigSchema;
    private final kd.bos.logorm.request.RequestContext context;

    public ElasticMonitorQueryBuilder(String route) {
        this.dataSourceRoute = DataSourceRoute.of(route);
        this.rc = RequestContext.get();
        ESConfig esConfig = MCApi.create().get(this.rc.getTenantId(), this.rc.getAccountId());
        this.dataSource = this.buildDisposableDataSource(esConfig);
        if (this.dataSourceRoute.getQueryDimension() == DataSourceRoute.QueryDimension.physical) {
            this.queryArchiveIndex = true;
            this.queryIndex = true;
        } else {
            this.queryIndex = this.dataSourceRoute.isMaster();
            this.queryArchiveIndex = !this.queryIndex;
        }
        this.esConfigSchema = esConfig.getSchema();
        this.context = new kd.bos.logorm.request.RequestContext(DataEntityMetaProvider.create());
    }

    private ElasticDisposableDataSource buildDisposableDataSource(ESConfig esConfig) {
        ESConfig.ESCluster cluster = null;
        if (this.dataSourceRoute.isMaster()) {
            cluster = esConfig.getCluster();
        } else {
            for (Map.Entry entry : esConfig.getArchiveHostInfo().entrySet()) {
                if (!this.dataSourceRoute.getDataSourceKey().equalsIgnoreCase((String)entry.getKey())) continue;
                cluster = ((ESConfig.ArchiveESInfo)entry.getValue()).getEsCluster();
                break;
            }
        }
        if (cluster == null || cluster.getUrls().isEmpty()) {
            throw LogORMExceptionFactory.createWithContext((String)("Elastic data source not found.route:" + this.dataSourceRoute));
        }
        return new ElasticDisposableDataSource(this.esConfig2HttpHost(cluster), cluster.getUsername(), cluster.getNp1(), esConfig.getSchema(), cluster);
    }

    private HttpHost[] esConfig2HttpHost(ESConfig.ESCluster cluster) {
        HttpHost[] httpHosts = new HttpHost[cluster.getUrls().size()];
        for (int i = 0; i < cluster.getUrls().size(); ++i) {
            ESConfig.URL url = (ESConfig.URL)cluster.getUrls().get(i);
            httpHosts[i] = new HttpHost(url.getHost(), url.getPort(), url.getSchema());
        }
        return httpHosts;
    }

    public DataSourceRoute getDataSourceRoute() {
        return this.dataSourceRoute;
    }

    public RequestContext getRc() {
        return this.rc;
    }

    public boolean isQueryIndex() {
        return this.queryIndex;
    }

    public boolean isQueryArchiveIndex() {
        return this.queryArchiveIndex;
    }

    public ElasticDisposableDataSource getDataSource() {
        return this.dataSource;
    }

    public String getEsConfigSchema() {
        return this.esConfigSchema;
    }

    public kd.bos.logorm.request.RequestContext getContext() {
        return this.context;
    }
}

