/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.operationcollect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.context.RequestContext;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.tx.TX;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.operationcollect.CbsOperationCollectService;
import kd.bos.operationcollect.CollectInfo;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0BuilderImpl;
import kd.bos.redis.pool.builder.ClusterBuilder;
import kd.bos.redis.pool.builder.SentinelBuilder;
import kd.bos.redis.pool.builder.ShardBuilder;

public class CommonOperationCollect
implements CbsOperationCollectService {
    private static final String TYPE_KEY = "type";
    private static final String VERSION_KEY = "version";
    public static final String UNKNOWN = "Unknown";
    public static final String REDIS_VERSION = "redis_version";
    private static Log log = LogFactory.getLog(CommonOperationCollect.class);

    public List<CollectInfo> collect() {
        ArrayList<CollectInfo> collectInfoList = new ArrayList<CollectInfo>(3);
        collectInfoList.addAll(this.getDBCollectInfoList());
        collectInfoList.addAll(this.getRedisCollectInfoList());
        CollectInfo mqCollectInfo = this.getMQCollectInfo();
        if (mqCollectInfo != null) {
            collectInfoList.add(mqCollectInfo);
        }
        return collectInfoList;
    }

    private List<CollectInfo> getRedisCollectInfoList() {
        try {
            ArrayList<CollectInfo> collectInfoList = new ArrayList<CollectInfo>(2);
            collectInfoList.add(this.buildRedisCollectInfo(CacheConfigKeys.getSessionlessConfigKey(null)));
            collectInfoList.add(this.buildRedisCollectInfo(CacheConfigKeys.getSessionableConfigKey()));
            return collectInfoList;
        }
        catch (Exception e) {
            log.error("cbs collect error, Redis collect error!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private CollectInfo buildRedisCollectInfo(String redisKey) {
        String redisUrl = System.getProperty(redisKey);
        String type = "Standalone";
        String version = UNKNOWN;
        if (Instance.isLightWeightDeploy()) {
            type = "Fake";
        } else {
            Pool0 pool0 = Pool0BuilderImpl.getPool((String)Encrypters.decode((String)redisUrl));
            if (pool0 instanceof ShardBuilder) {
                type = "Shard";
            } else if (pool0 instanceof ClusterBuilder) {
                type = "Cluster";
            } else if (pool0 instanceof SentinelBuilder) {
                type = "Sentinel";
            }
            JedisClient jedisClient = RedisFactory.getJedisClient((String)redisUrl);
            List mapList = jedisClient.getRedisInfo();
            for (Map map : mapList) {
                if (!map.containsKey(REDIS_VERSION)) continue;
                version = String.valueOf(map.get(REDIS_VERSION));
                break;
            }
        }
        CollectInfo collectInfo = new CollectInfo();
        collectInfo.setBusinessScene("Redis");
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put(TYPE_KEY, type);
        data.put(VERSION_KEY, version);
        data.put("redisKey", redisKey);
        collectInfo.setData(data);
        return collectInfo;
    }

    private CollectInfo getMQCollectInfo() {
        try {
            String type = QueueManager.getMQType((String)"base");
            String version = UNKNOWN;
            CollectInfo collectInfo = new CollectInfo();
            collectInfo.setBusinessScene("MQ");
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put(TYPE_KEY, type);
            data.put(VERSION_KEY, version);
            collectInfo.setData(data);
            return collectInfo;
        }
        catch (Exception e) {
            log.error("cbs collect error, MQ collect error!", (Throwable)e);
            return null;
        }
    }

    private List<CollectInfo> getDBCollectInfoList() {
        try {
            RequestContext rc = RequestContext.getOrCreate();
            Account account = AccountUtils.getAccountById((String)rc.getAccountId());
            HashMap<String, List> dbTypeRoteKeysMap = new HashMap<String, List>(1);
            List dbInstanceList = account.getDBInstanceList();
            for (DBInstance dbInstance : dbInstanceList) {
                DBConfig dbConfig;
                String routeKey = dbInstance.getRouteKey();
                try {
                    dbConfig = DataSourceFactory.getDBConfig((String)rc.getTenantId(), (String)routeKey, (String)rc.getAccountId());
                }
                catch (Throwable throwable) {
                    log.warn("cbs collect error, exception while getting db config, error is: " + throwable.getMessage(), throwable);
                    continue;
                }
                String dbType = dbConfig.getDBType().toString();
                List routeKeys = dbTypeRoteKeysMap.computeIfAbsent(dbType, type -> new ArrayList(dbInstanceList.size()));
                routeKeys.add(routeKey);
            }
            ArrayList<CollectInfo> collectInfoList = new ArrayList<CollectInfo>(1);
            for (Map.Entry entry : dbTypeRoteKeysMap.entrySet()) {
                CollectInfo collectInfo = new CollectInfo();
                collectInfo.setBusinessScene("DB");
                HashMap data = new HashMap(2);
                data.put(TYPE_KEY, entry.getKey());
                data.put(VERSION_KEY, this.getFirstRouteKeyDBVersion((List)entry.getValue()));
                data.put("routeKeys", ((List)entry.getValue()).toString());
                collectInfo.setData(data);
                collectInfoList.add(collectInfo);
            }
            return collectInfoList;
        }
        catch (Exception e) {
            log.error("cbs collect error, DB collect error!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFirstRouteKeyDBVersion(List<String> routeKeys) {
        if (routeKeys == null) return UNKNOWN;
        if (routeKeys.isEmpty()) {
            return UNKNOWN;
        }
        String routeKey = routeKeys.get(0);
        try (Connection conn = TX.__getConnection((String)routeKey, (boolean)false);){
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String string = String.format("%s@%s", dbMetaData.getDatabaseProductName(), dbMetaData.getDatabaseProductVersion());
            return string;
        }
        catch (Throwable throwable6) {
            log.warn("Exception while getting database version, error message is: " + throwable6.getMessage(), throwable6);
            return UNKNOWN;
        }
    }
}

