/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.readwritesplit;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cbs.plugin.readwritesplit.ReadWriteScenesEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;

public class ReadWriteSplitPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String PROP_SCENES = "scenes";
    private static final String PROP_BILLNO = "billno";
    private static final String PROP_NAME = "name";
    private static final String PROP_ENTITY_NO = "entity_no";
    private static final String PROP_GROUP = "group";

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PROP_ENTITY_NO});
        BillView billView = (BillView)e.getSource();
        FormShowParameter parameter = billView.getFormShowParameter();
        String group = (String)parameter.getCustomParam(PROP_GROUP);
        if (group != null) {
            this.getModel().setValue(PROP_GROUP, (Object)group);
        }
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ctl = (BasedataEdit)this.getControl(PROP_ENTITY_NO);
        ctl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if (PROP_SCENES.equals(e.getProperty().getName())) {
            String newValue = (String)changeData.getNewValue();
            boolean visit = false;
            if (newValue.equals(ReadWriteScenesEnum.CUSTOM.getValue())) {
                visit = true;
            }
            view.setVisible(Boolean.valueOf(visit), new String[]{PROP_BILLNO});
            view.setVisible(Boolean.valueOf(!visit), new String[]{PROP_ENTITY_NO});
            model.setValue(PROP_BILLNO, null);
            model.setValue(PROP_NAME, null);
            model.setValue(PROP_ENTITY_NO, null);
            view.setEnable(Boolean.valueOf(true), new String[]{PROP_GROUP});
        } else if (PROP_ENTITY_NO.equals(e.getProperty().getName())) {
            if (changeData.getNewValue() == null) {
                return;
            }
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            model.setValue(PROP_BILLNO, (Object)newValue.getString("number").toLowerCase(Locale.getDefault()));
            model.setValue(PROP_NAME, (Object)newValue.getLocaleString(PROP_NAME));
            model.setValue(PROP_GROUP, (Object)newValue.getString("bizappid.id"));
            view.setEnable(Boolean.valueOf(false), new String[]{PROP_GROUP});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals(PROP_ENTITY_NO)) {
            Object scenesObj = this.getModel().getValue(PROP_SCENES);
            if (scenesObj == null) {
                return;
            }
            String scenes = (String)scenesObj;
            ReadWriteScenesEnum scenesEnum = ReadWriteScenesEnum.fromValue(scenes);
            QFilter filter = null;
            if (scenesEnum == ReadWriteScenesEnum.BILL_LIST) {
                filter = new QFilter("modeltype", "in", (Object)Lists.newArrayList((Object[])new String[]{"BillFormModel", "BaseFormModel"}));
            } else if (scenesEnum == ReadWriteScenesEnum.REPORT) {
                filter = new QFilter("modeltype", "=", (Object)"ReportFormModel");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u5199\u5206\u79bb\u914d\u7f6e\u76ee\u524d\u4ec5\u652f\u6301\u5bf9\uff1a\u5355\u636e\uff0c\u57fa\u7840\u8d44\u6599\uff0c\u62a5\u8868 \u8fdb\u884c\u914d\u7f6e\u3002", (String)"ReadWriteAllowTypes", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            if (filter != null) {
                beforeF7SelectEvent.getCustomQFilters().add(filter);
            }
        }
    }
}

