/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.readwritesplit;

import java.util.ArrayList;
import kd.bos.cbs.plugin.readwritesplit.ReadWriteSplitConfigEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.splittingread.RWManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReadWriteSplitScenesListPlugin
extends AbstractListPlugin {
    private static final String BTN_SAVE = "save";
    private static final String BTN_RELEASE = "release";
    private static final String CONFIRM_RELEASE_CALL_BACK_ID = "release";
    private static final String BTN_SAVE_AS_MASTER_FIRST = "save_as_master_first";
    private static final String BTN_SAVE_AS_SLAVE_FIRST = "save_as_slave_first";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String itemKey;
            Donothing donothing = (Donothing)source;
            switch (itemKey = donothing.getOperateKey()) {
                case "save_as_master_first": 
                case "save_as_slave_first": {
                    this.onSaveAsClick(itemKey);
                    break;
                }
                case "release": {
                    this.onRelease();
                    break;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("release".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.release();
        }
        super.confirmCallBack(event);
    }

    private void release() {
        String releaseSQL = "UPDATE t_rw_split_scenes SET frelease_config=fcurrent_config";
        BillList billList = (BillList)this.getControl("billlistap");
        try (TXHandle txHandle = TX.requiresNew((String)"kd.bos.cbs.readwritesplit");){
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)releaseSQL);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"ReleaseSuccess", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            billList.refreshData();
        }
        RWManager manager = RWManager.getInstance();
        manager.invalidScenesCache();
    }

    private void onRelease() {
        ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("release", (IFormPlugin)this);
        String title = ResManager.loadKDString((String)"\u53d8\u66f4\u914d\u7f6e\u4f1a\u5bfc\u81f4\u67e5\u8be2\u5207\u6362\u5230\u4e3b\u5e93\u6216\u4ece\u5e93\u6267\u884c\uff0c\u662f\u5426\u786e\u8ba4\u53d1\u5e03\u914d\u7f6e\uff1f", (String)"ConfirmReleaseConfig", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        this.getView().showConfirm(title, MessageBoxOptions.YesNo, confirmListener);
    }

    private void onSaveAsClick(String key) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRowCollection = billList.getSelectedRows();
        if (selectedRowCollection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6570\u636e\u884c\u3002", (String)"NoneSelectedRows", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        String value = BTN_SAVE_AS_MASTER_FIRST.equalsIgnoreCase(key) ? ReadWriteSplitConfigEnum.MasterFirst.getValue() : ReadWriteSplitConfigEnum.SlaveFirst.getValue();
        ArrayList<DynamicObject> updateObjects = new ArrayList<DynamicObject>(selectedRowCollection.size());
        for (ListSelectedRow row : selectedRowCollection) {
            Object primary = row.getPrimaryKeyValue();
            if (primary == null) continue;
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"rw_split_scenes");
            data.set("id", primary);
            data.set("current_config", (Object)value);
            updateObjects.add(data);
        }
        try (TXHandle txHandle = TX.requiresNew((String)"kd.bos.cbs.readwritesplit");){
            SaveServiceHelper.update((DynamicObject[])updateObjects.toArray(new DynamicObject[0]));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"SaveSuccess", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        billList.refreshData();
    }
}

