/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;

public class SearchMappingPlugin
extends AbstractFormPlugin {
    private static final String FULLTEXT = "fulltext";
    private static final String REGION = "region";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String ENTITY_ID = "dentityid";
    private static final String TABLE_NAME = "tablename";
    private static final String SYNC_FIELDS = "entityfields";
    private static final String TIMING_FIELD = "timingsequence";
    private static final String OPERATE_SAVE = "save";
    private static final String ENTITY_NAME = "bos_cbs_qs_config";

    public void initialize() {
        super.initialize();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName = propertyChangedArgs.getProperty().getName();
        IDataModel model = this.getModel();
        if (ENTITY_NUMBER.equals(propertyName)) {
            Object value = model.getValue(ENTITY_NUMBER);
            if (value == null) {
                this.setComboData(null, true);
                return;
            }
            String tableName = ((DynamicObject)value).getString(TABLE_NAME);
            String id = ((DynamicObject)value).getString("id");
            ArrayList<String> entityNameList = new ArrayList<String>();
            ORM orm = ORM.create();
            try (DataSet dataSet = orm.queryDataSet("quick search config", ENTITY_NAME, "id,entitynumber", null, null, -1);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    entityNameList.add((String)row.get(1));
                }
            }
            for (String entityName : entityNameList) {
                String t = EntityMetadataCache.getDataEntityType((String)entityName).getAlias();
                if (!tableName.equalsIgnoreCase(t)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53[{0}]\u5df2\u7ecf\u5305\u542b\u5f53\u524d\u9009\u62e9\u5b9e\u4f53[{1}]\u7684\u8868\u3002", (String)"SearchMappingPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{entityName, id}));
                this.getModel().setValue(ENTITY_NUMBER, null);
                return;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)value).getString(ENTITY_ID));
            this.setComboData(mainEntityType, true);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Object value = model.getValue(ENTITY_NUMBER);
        if (value == null) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)value).getString(ENTITY_ID));
        this.setComboData(mainEntityType, false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if (OPERATE_SAVE.equals(operateKey)) {
            String[] split;
            String value = (String)model.getValue(SYNC_FIELDS);
            if (value != null && (split = value.split(",")).length - 1 > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5b57\u6bb5\u4e0d\u80fd\u9009\u62e9\u8d85\u8fc710\u4e2a\u5b57\u6bb5\u3002", (String)"DtsMappingPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean enable = (Boolean)this.getModel().getValue("enable");
            if (enable) {
                String dtsEnable = System.getProperty("dts.sync.enable");
                if (dtsEnable != null && !"true".equalsIgnoreCase(dtsEnable)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728MC\u4e2d\u914d\u7f6e\u53c2\u6570dts.sync.enable=true\u3002", (String)"DtsMappingPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
                if (!account.isDtsEnable()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728MC\u7684\u6570\u636e\u4e2d\u5fc3\u5f00\u542f\u5f53\u524d\u8d26\u5957\u7684\u6570\u636e\u4f20\u8f93\u529f\u80fd\u3002", (String)"DtsMappingPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    private void setComboData(MainEntityType dt, boolean cleanCache) {
        ComboEdit timingComboEdit = (ComboEdit)this.getControl(TIMING_FIELD);
        MulComboEdit syncMulComboEdit = (MulComboEdit)this.getControl(SYNC_FIELDS);
        if (dt == null) {
            timingComboEdit.setComboItems(Collections.emptyList());
            syncMulComboEdit.setComboItems(Collections.emptyList());
            if (cleanCache) {
                this.getModel().setValue(SYNC_FIELDS, null);
                this.getModel().setValue(TIMING_FIELD, null);
            }
            return;
        }
        DataEntityPropertyCollection ps = dt.getProperties();
        ArrayList<ComboItem> timingItems = new ArrayList<ComboItem>();
        ArrayList<ComboItem> syncItems = new ArrayList<ComboItem>();
        for (IDataEntityProperty dp : ps) {
            String name = dp.getName();
            if (name.endsWith("_id") || ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp) || dp instanceof BasedataProp || dp instanceof MulBasedataProp || dp instanceof AttachmentProp) continue;
            ComboItem item = dp instanceof PKFieldProp ? new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"SearchMappingPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0])), name) : new ComboItem(dp.getDisplayName(), name);
            syncItems.add(item);
            if (!(dp instanceof DateTimeProp) && !(dp instanceof BigIntProp) && !(dp instanceof IntegerProp) && !(dp instanceof LongProp) && !(dp instanceof DecimalProp) && !(dp instanceof DateProp)) continue;
            timingItems.add(item);
        }
        syncMulComboEdit.setComboItems(syncItems);
        timingComboEdit.setComboItems(timingItems);
        if (cleanCache) {
            this.getModel().setValue(SYNC_FIELDS, null);
            this.getModel().setValue(TIMING_FIELD, null);
        }
    }
}

