/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.search;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class SearchOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SearchOperationServicePlugIn.class);
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String REGION = "region";
    private static final String SYNC_FIELDS = "entityfields";
    private static final String TIMING_FIELD = "timingsequence";
    private static final String OPERATE_SAVE = "save";
    private static final String OPERATE_DELETE = "delete";
    private static final String FEILD_ENABLE = "enable";
    private static final String FEILD_NUMBER = "number";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (operationKey.equals(OPERATE_SAVE)) {
            this.operateSave(e);
        } else if (operationKey.equals(OPERATE_DELETE)) {
            this.operateDelete(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void operateSave(BeginOperationTransactionArgs e) throws KDException {
        try {
            DynamicObject[] dynamicObjects = e.getDataEntities();
            long fidSearch = (Long)dynamicObjects[0].getPkValue();
            ORM orm = ORM.create();
            IDataEntityType dataSyncConfigType = orm.getDataEntityType("data_sync_config");
            int count = 0;
            long dtsId = this.querySearchDts(fidSearch).getDtsId();
            if (dtsId > 0L) {
                ++count;
            }
            String entityType = ((DynamicObject)dynamicObjects[0].get(ENTITY_NUMBER)).getString(FEILD_NUMBER);
            String region = dynamicObjects[0].getString(REGION);
            String timingField = dynamicObjects[0].getString(TIMING_FIELD);
            String syncFields = dynamicObjects[0].getString(SYNC_FIELDS);
            boolean feildEnable = dynamicObjects[0].getBoolean(FEILD_ENABLE);
            if (count == 0) {
                DynamicObject dataSyncConfigObject = orm.newDynamicObject("data_sync_config");
                dataSyncConfigObject.set("businesstype", (Object)"quicksearch");
                dataSyncConfigObject.set(ENTITY_NUMBER, (Object)entityType);
                dataSyncConfigObject.set("destinationtype", (Object)"fulltext");
                dataSyncConfigObject.set(REGION, (Object)region);
                dataSyncConfigObject.set(TIMING_FIELD, (Object)timingField);
                dataSyncConfigObject.set(SYNC_FIELDS, (Object)syncFields);
                dataSyncConfigObject.set(FEILD_ENABLE, (Object)feildEnable);
                Object[] data = BusinessDataWriter.save((IDataEntityType)dataSyncConfigType, (Object[])new Object[]{dataSyncConfigObject});
                if (data == null || data.length <= 0) throw new KDException(BosErrorCode.otherUnknow, new Object[]{"save dataSyncConfig error"});
                dtsId = ((DynamicObject)data[0]).getLong("id");
                String insertSql = "insert into t_ft_qs_dts(fid, fsearchid,fdtsid) values(?,?,?)";
                ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>();
                insertParamsList.add(new Object[]{DB.genGlobalLongId(), fidSearch, dtsId});
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParamsList);
                return;
            } else {
                QFilter q;
                QFilter[] filters;
                DynamicObject dynamicObject;
                if (count <= 0 || (dynamicObject = orm.queryOne("data_sync_config", filters = new QFilter[]{q = new QFilter("id", "=", (Object)dtsId)})) == null) return;
                dynamicObject.set("businesstype", (Object)"quicksearch");
                dynamicObject.set(ENTITY_NUMBER, (Object)entityType);
                dynamicObject.set("destinationtype", (Object)"fulltext");
                dynamicObject.set(REGION, (Object)region);
                dynamicObject.set(TIMING_FIELD, (Object)timingField);
                dynamicObject.set(SYNC_FIELDS, (Object)syncFields);
                dynamicObject.set(FEILD_ENABLE, (Object)feildEnable);
                BusinessDataWriter.update((IDataEntityType)dataSyncConfigType, (Object[])new Object[]{dynamicObject});
            }
            return;
        }
        catch (KDException saveEx) {
            logger.error("quick search save error. ", (Throwable)saveEx);
            e.setCancelOperation(true);
            throw saveEx;
        }
    }

    private void operateDelete(BeginOperationTransactionArgs e) throws KDException {
        try {
            DynamicObject[] dynamicObjects = e.getDataEntities();
            ORM orm = ORM.create();
            IDataEntityType dataSyncConfigType = orm.getDataEntityType("data_sync_config");
            String deleteSql = "delete from t_ft_qs_dts where fid = ?";
            ArrayList<Object[]> deleteParamsList = new ArrayList<Object[]>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                long fidSearch = dynamicObject.getLong("id");
                SearchDts searchDts = this.querySearchDts(fidSearch);
                long dtsId = searchDts.getDtsId();
                if (dtsId <= 0L) continue;
                BusinessDataWriter.delete((IDataEntityType)dataSyncConfigType, (Object[])new Object[]{searchDts.getDtsId()});
                deleteParamsList.add(new Object[]{searchDts.getId()});
            }
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, deleteParamsList);
        }
        catch (KDException deleteEx) {
            logger.error("quick search delete error. ", (Throwable)deleteEx);
            e.setCancelOperation(true);
            throw deleteEx;
        }
    }

    private SearchDts querySearchDts(long fidSearch) {
        SearchDts searchDts = new SearchDts();
        String querySearchDtsSql = "select fid, fsearchid, fdtsid from t_ft_qs_dts where fsearchid = ?";
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.basedata, (String)querySearchDtsSql, (Object[])new Object[]{fidSearch});){
            for (Row row : ds) {
                if (row.getLong("fdtsid") == null) continue;
                searchDts.setId(row.getLong("fid"));
                searchDts.setSearchId(row.getLong("fsearchid"));
                searchDts.setDtsId(row.getLong("fdtsid"));
                break;
            }
        }
        return searchDts;
    }

    private static class SearchDts {
        private long id;
        private long searchId;
        private long dtsId;

        private SearchDts() {
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public long getSearchId() {
            return this.searchId;
        }

        public void setSearchId(long searchId) {
            this.searchId = searchId;
        }

        public long getDtsId() {
            return this.dtsId;
        }

        public void setDtsId(long dtsId) {
            this.dtsId = dtsId;
        }
    }
}

