/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.search;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.impl.ORMUtil;

public class SimpleSearchMappingPlugin
extends AbstractFormPlugin {
    private static final String FULLTEXT = "fulltext";
    private static final String REGION = "region";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String ENTITY_ID = "dentityid";
    private static final String SYNC_FIELDS = "entityfields";
    private static final String OPERATE_SAVE = "save";

    public void initialize() {
        super.initialize();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName = propertyChangedArgs.getProperty().getName();
        IDataModel model = this.getModel();
        if (ENTITY_NUMBER.equals(propertyName)) {
            Object value = model.getValue(ENTITY_NUMBER);
            if (value == null) {
                return;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)value).getString(ENTITY_ID));
            this.setComboData(mainEntityType, true);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Object value = model.getValue(ENTITY_NUMBER);
        if (value == null) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)value).getString(ENTITY_ID));
        this.setComboData(mainEntityType, false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String[] split;
        String value;
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if (OPERATE_SAVE.equals(operateKey) && (value = (String)model.getValue(SYNC_FIELDS)) != null && (split = value.split(",")).length - 1 > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5b57\u6bb5\u4e0d\u80fd\u9009\u62e9\u8d85\u8fc710\u4e2a\u5b57\u6bb5\u3002", (String)"DtsMappingPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setComboData(MainEntityType dt, boolean cleanCache) {
        MulComboEdit syncMulComboEdit = (MulComboEdit)this.getControl(SYNC_FIELDS);
        DataEntityPropertyCollection ps = dt.getProperties();
        ArrayList<ComboItem> syncItems = new ArrayList<ComboItem>(8);
        for (IDataEntityProperty dp : ps) {
            String name = dp.getName();
            if (name.endsWith("_id") || ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp)) continue;
            ComboItem item = dp instanceof PKFieldProp ? new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"SearchMappingPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0])), name) : new ComboItem(dp.getDisplayName(), name);
            syncItems.add(item);
        }
        syncMulComboEdit.setComboItems(syncItems);
        if (cleanCache) {
            this.getModel().setValue(SYNC_FIELDS, null);
        }
    }
}

